/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application;

import com.intellij.ide.CliResult;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationStarter;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Future;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ApplicationStarterBase
implements ApplicationStarter {
    private final String myCommandName;
    private final int[] myArgsCount;

    protected ApplicationStarterBase(@NotNull String commandName, int ... possibleArgumentsCount) {
        if (commandName == null) {
            ApplicationStarterBase.$$$reportNull$$$0(0);
        }
        this.myCommandName = commandName;
        this.myArgsCount = possibleArgumentsCount;
    }

    @Override
    public String getCommandName() {
        return this.myCommandName;
    }

    @Override
    public boolean isHeadless() {
        return false;
    }

    @Override
    public boolean canProcessExternalCommandLine() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Future<CliResult> processExternalCommandLineAsync(@NotNull List<String> args, @Nullable String currentDirectory) {
        Future<CliResult> future2;
        if (args == null) {
            ApplicationStarterBase.$$$reportNull$$$0(1);
        }
        if (!this.checkArguments(args)) {
            Messages.showMessageDialog(this.getUsageMessage(), StringUtil.toTitleCase(this.getCommandName()), Messages.getInformationIcon());
            Future<CliResult> future3 = CliResult.error(1, this.getUsageMessage());
            if (future3 == null) {
                ApplicationStarterBase.$$$reportNull$$$0(2);
            }
            return future3;
        }
        try {
            Future<CliResult> future4 = this.processCommand(args, currentDirectory);
            future2 = future4;
        }
        catch (Exception e) {
            String message = String.format("Error executing %s: %s", this.getCommandName(), e.getMessage());
            Messages.showMessageDialog(message, StringUtil.toTitleCase(this.getCommandName()), Messages.getErrorIcon());
            Future<CliResult> future5 = CliResult.error(1, message);
            Future<CliResult> future6 = future5;
            if (future6 == null) {
                ApplicationStarterBase.$$$reportNull$$$0(4);
            }
            return future6;
        }
        finally {
            ApplicationStarterBase.saveAll();
        }
        if (future2 == null) {
            ApplicationStarterBase.$$$reportNull$$$0(3);
        }
        return future2;
    }

    protected static void saveAll() {
        FileDocumentManager.getInstance().saveAllDocuments();
        ApplicationManager.getApplication().saveSettings();
    }

    private boolean checkArguments(@NotNull List<String> args) {
        if (args == null) {
            ApplicationStarterBase.$$$reportNull$$$0(5);
        }
        return Arrays.binarySearch(this.myArgsCount, args.size() - 1) != -1 && this.getCommandName().equals(args.get(0));
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    public abstract String getUsageMessage();

    @NotNull
    protected abstract Future<CliResult> processCommand(@NotNull List<String> var1, @Nullable String var2) throws Exception;

    @Override
    public void premain(@NotNull List<String> args) {
        if (args == null) {
            ApplicationStarterBase.$$$reportNull$$$0(6);
        }
        if (!this.checkArguments(args)) {
            System.err.println(this.getUsageMessage());
            System.exit(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void main(String @NotNull [] args) {
        if (args == null) {
            ApplicationStarterBase.$$$reportNull$$$0(7);
        }
        int exitCode = 0;
        try {
            Future<CliResult> commandFuture = this.processCommand(Arrays.asList(args), null);
            CliResult result2 = commandFuture.get();
            if (result2.message != null) {
                System.out.println(result2.message);
            }
            exitCode = result2.exitCode;
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        catch (Throwable t) {
            t.printStackTrace();
            System.exit(2);
        }
        finally {
            ApplicationStarterBase.saveAll();
        }
        System.exit(exitCode);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandName";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/application/ApplicationStarterBase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/application/ApplicationStarterBase";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "processExternalCommandLineAsync";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "processExternalCommandLineAsync";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "checkArguments";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "premain";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "main";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

