/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application;

import com.intellij.diagnostic.VMOptions;
import com.intellij.ide.cloudConfig.CloudConfigProvider;
import com.intellij.ide.highlighter.ArchiveFileType;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.startup.StartupActionScriptManager;
import com.intellij.idea.Main;
import com.intellij.idea.SplashManager;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ConfigImportSettings;
import com.intellij.openapi.application.CustomConfigMigrationOption;
import com.intellij.openapi.application.ImportOldConfigsPanel;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.RestoreDefaultConfigCustomizer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.AppUIUtil;
import com.intellij.util.PlatformUtils;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.Restarter;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.Decompressor;
import com.intellij.util.text.VersionComparatorUtil;
import java.awt.Dialog;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.DosFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.PropertyResourceBundle;
import java.util.ServiceLoader;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ConfigImportHelper {
    private static final String FIRST_SESSION_KEY = "intellij.first.ide.session";
    private static final String CONFIG_IMPORTED_IN_CURRENT_SESSION_KEY = "intellij.config.imported.in.current.session";
    private static final String CONFIG = "config";
    private static final String[] OPTIONS = new String[]{"options/other.xml", "options/ide.general.xml", "options/options.xml"};
    private static final String BIN = "bin";
    private static final String CONTENTS = "Contents";
    private static final String PLIST = "Info.plist";
    private static final String PLUGINS = "plugins";
    private static final String SYSTEM = "system";
    private static final Pattern SELECTOR_PATTERN = Pattern.compile("\\.?([^\\d]+)(\\d+(?:\\.\\d+)?)");
    private static final String SHOW_IMPORT_CONFIG_DIALOG_PROPERTY = "idea.initially.ask.config";
    public static final String CUSTOM_MARKER_FILE_NAME = "migrate.config";

    private ConfigImportHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void importConfigsTo(boolean veryFirstStartOnThisComputer, @NotNull Path newConfigDir, @NotNull Logger log) {
        boolean vmOptionFileChanged;
        block29: {
            if (newConfigDir == null) {
                ConfigImportHelper.$$$reportNull$$$0(0);
            }
            if (log == null) {
                ConfigImportHelper.$$$reportNull$$$0(1);
            }
            log.info("Importing configs to " + newConfigDir);
            System.setProperty(FIRST_SESSION_KEY, Boolean.TRUE.toString());
            CustomConfigMigrationOption customMigrationOption = CustomConfigMigrationOption.readCustomConfigMigrationOptionAndRemoveMarkerFile(newConfigDir);
            if (customMigrationOption instanceof CustomConfigMigrationOption.SetProperties) {
                List<String> properties = ((CustomConfigMigrationOption.SetProperties)customMigrationOption).getProperties();
                log.info("Enabling system properties after restart: " + properties);
                Iterator<String> iterator2 = properties.iterator();
                while (iterator2.hasNext()) {
                    String property = iterator2.next();
                    System.setProperty(property, Boolean.TRUE.toString());
                }
                return;
            }
            ConfigImportSettings settings = null;
            try {
                String customProviderName = "com.intellij.openapi.application." + PlatformUtils.getPlatformPrefix() + "ConfigImportSettings";
                Class<?> customProviderClass = Class.forName(customProviderName);
                if (ConfigImportSettings.class.isAssignableFrom(customProviderClass)) {
                    settings = (ConfigImportSettings)ReflectionUtil.newInstance(customProviderClass);
                }
            }
            catch (Exception customProviderName) {
                // empty catch block
            }
            @NotNull List<PathAndFileTime> guessedOldConfigDirs = ConfigImportHelper.findConfigDirectories(newConfigDir);
            File tempBackup = null;
            vmOptionFileChanged = false;
            try {
                Pair<Path, Path> oldConfigDirAndOldIdePath;
                block28: {
                    oldConfigDirAndOldIdePath = null;
                    if (customMigrationOption != null) {
                        log.info("Custom migration option: " + customMigrationOption);
                        vmOptionFileChanged = ConfigImportHelper.doesVmOptionFileExist(newConfigDir);
                        try {
                            if (customMigrationOption instanceof CustomConfigMigrationOption.MigrateFromCustomPlace) {
                                tempBackup = ConfigImportHelper.backupCurrentConfigToTempAndDelete(newConfigDir, log, false);
                                Path location2 = ((CustomConfigMigrationOption.MigrateFromCustomPlace)customMigrationOption).getLocation();
                                oldConfigDirAndOldIdePath = ConfigImportHelper.findConfigDirectoryByPath(location2);
                                break block28;
                            }
                            tempBackup = ConfigImportHelper.backupCurrentConfigToTempAndDelete(newConfigDir, log, true);
                        }
                        catch (IOException e) {
                            log.error("Couldn't backup current config or delete current config directory", e);
                        }
                    } else if (ConfigImportHelper.shouldAskForConfig()) {
                        oldConfigDirAndOldIdePath = ConfigImportHelper.showDialogAndGetOldConfigPath(guessedOldConfigDirs);
                    } else if (guessedOldConfigDirs.isEmpty()) {
                        boolean importedFromCloud = false;
                        CloudConfigProvider configProvider = CloudConfigProvider.getProvider();
                        if (configProvider != null) {
                            importedFromCloud = configProvider.importSettingsSilently(newConfigDir);
                        }
                        if (!importedFromCloud && !veryFirstStartOnThisComputer) {
                            oldConfigDirAndOldIdePath = ConfigImportHelper.showDialogAndGetOldConfigPath(guessedOldConfigDirs);
                        }
                    } else {
                        PathAndFileTime bestConfigGuess = guessedOldConfigDirs.get(0);
                        oldConfigDirAndOldIdePath = ConfigImportHelper.isConfigOld(bestConfigGuess.fileTime) ? ConfigImportHelper.showDialogAndGetOldConfigPath(guessedOldConfigDirs) : ConfigImportHelper.findConfigDirectoryByPath(bestConfigGuess.path);
                    }
                }
                if (oldConfigDirAndOldIdePath != null) {
                    ConfigImportHelper.doImport((Path)oldConfigDirAndOldIdePath.first, newConfigDir, (Path)oldConfigDirAndOldIdePath.second, log);
                    if (settings != null) {
                        settings.importFinished(newConfigDir);
                    }
                    System.setProperty(CONFIG_IMPORTED_IN_CURRENT_SESSION_KEY, Boolean.TRUE.toString());
                } else {
                    log.info("No configs imported, starting with clean configs at " + newConfigDir);
                }
                vmOptionFileChanged |= ConfigImportHelper.doesVmOptionFileExist(newConfigDir);
                if (tempBackup == null) break block29;
            }
            catch (Throwable throwable) {
                if (tempBackup == null) throw throwable;
                try {
                    ConfigImportHelper.moveTempBackupToStandardBackup(tempBackup, log);
                    throw throwable;
                }
                catch (IOException e) {
                    log.warn(String.format("Couldn't move the backup of current config from temp dir [%s] to backup dir [%s]", tempBackup, ConfigImportHelper.getBackupPath()), e);
                }
                throw throwable;
            }
            try {
                ConfigImportHelper.moveTempBackupToStandardBackup(tempBackup, log);
            }
            catch (IOException e) {
                log.warn(String.format("Couldn't move the backup of current config from temp dir [%s] to backup dir [%s]", tempBackup, ConfigImportHelper.getBackupPath()), e);
            }
        }
        if (!vmOptionFileChanged) return;
        log.info("The vmoptions file has changed, restarting...");
        ArrayList<String> properties = new ArrayList<String>();
        properties.add(FIRST_SESSION_KEY);
        if (ConfigImportHelper.isConfigImported()) {
            properties.add(CONFIG_IMPORTED_IN_CURRENT_SESSION_KEY);
        }
        new CustomConfigMigrationOption.SetProperties(properties).writeConfigMarkerFile();
        ConfigImportHelper.restart();
    }

    private static boolean isConfigOld(@NotNull FileTime time) {
        if (time == null) {
            ConfigImportHelper.$$$reportNull$$$0(2);
        }
        Instant deadline = Instant.now().minus(180L, ChronoUnit.DAYS);
        return time.toInstant().compareTo(deadline) < 0;
    }

    private static boolean doesVmOptionFileExist(@NotNull Path configDir) {
        if (configDir == null) {
            ConfigImportHelper.$$$reportNull$$$0(3);
        }
        return Files.isRegularFile(configDir.resolve(VMOptions.getCustomVMOptionsFileName()), new LinkOption[0]);
    }

    private static void restart() {
        if (Restarter.isSupported()) {
            try {
                Restarter.scheduleRestart(false, new String[0]);
            }
            catch (IOException e) {
                Main.showMessage((String)"Restart failed", (Throwable)e);
            }
            System.exit(0);
        } else {
            String no;
            String yes;
            String title = ApplicationBundle.message("title.import.settings", ApplicationNamesInfo.getInstance().getFullProductName());
            String message = ApplicationBundle.message("restart.import.settings", new Object[0]);
            if (Messages.showYesNoDialog(message, title, yes = ApplicationBundle.message("restart.import.now", new Object[0]), no = ApplicationBundle.message("restart.import.later", new Object[0]), Messages.getQuestionIcon()) == 0) {
                System.exit(0);
            }
        }
    }

    @NotNull
    private static File backupCurrentConfigToTempAndDelete(@NotNull Path currentConfig, @NotNull Logger log, boolean smartDelete) throws IOException {
        if (currentConfig == null) {
            ConfigImportHelper.$$$reportNull$$$0(4);
        }
        if (log == null) {
            ConfigImportHelper.$$$reportNull$$$0(5);
        }
        File tempBackupDir = FileUtil.createTempDirectory(ConfigImportHelper.getConfigDirName(), "-backup");
        log.info("Backup config from " + currentConfig + " to " + tempBackupDir);
        FileUtil.copyDir(PathManager.getConfigDir().toFile(), tempBackupDir);
        ConfigImportHelper.deleteCurrentConfigDir(currentConfig, log, smartDelete);
        Path pluginsDir = currentConfig.getFileSystem().getPath(PathManager.getPluginsPath(), new String[0]);
        if (Files.exists(pluginsDir, new LinkOption[0]) && !pluginsDir.startsWith(currentConfig)) {
            File pluginsBackup = new File(tempBackupDir, PLUGINS);
            log.info("Backup plugins dir separately from " + pluginsDir + " to " + pluginsBackup);
            if (pluginsBackup.mkdir()) {
                FileUtil.copyDir(new File(pluginsDir.toString()), pluginsBackup);
                FileUtil.delete(pluginsDir);
            } else {
                log.warn("Couldn't backup plugins directory to " + pluginsBackup);
            }
        }
        File file2 = tempBackupDir;
        if (file2 == null) {
            ConfigImportHelper.$$$reportNull$$$0(6);
        }
        return file2;
    }

    private static void deleteCurrentConfigDir(@NotNull Path currentConfig, @NotNull Logger log, boolean smartDelete) throws IOException {
        if (currentConfig == null) {
            ConfigImportHelper.$$$reportNull$$$0(7);
        }
        if (log == null) {
            ConfigImportHelper.$$$reportNull$$$0(8);
        }
        log.debug("Removing current config directory, smartDelete: " + smartDelete);
        if (!smartDelete) {
            FileUtil.delete(currentConfig);
            return;
        }
        boolean removedViaCustomizer = false;
        try {
            Iterator<RestoreDefaultConfigCustomizer> iterator2 = ServiceLoader.load(RestoreDefaultConfigCustomizer.class).iterator();
            if (iterator2.hasNext()) {
                RestoreDefaultConfigCustomizer customizer = iterator2.next();
                log.debug("Found " + customizer);
                customizer.removeCurrentConfigDir(currentConfig);
                removedViaCustomizer = true;
            }
        }
        catch (Exception e) {
            log.warn("Couldn't remove current config dir using the customizer", e);
        }
        if (!removedViaCustomizer) {
            log.debug("RestoreDefaultConfigCustomizer not found, removing config directory manually...");
            FileUtil.delete(currentConfig);
        }
    }

    private static void moveTempBackupToStandardBackup(@NotNull File backupToMove, @NotNull Logger log) throws IOException {
        if (backupToMove == null) {
            ConfigImportHelper.$$$reportNull$$$0(9);
        }
        if (log == null) {
            ConfigImportHelper.$$$reportNull$$$0(10);
        }
        Path backupPath = ConfigImportHelper.getBackupPath();
        log.info("Move backup from " + backupToMove + " to " + backupPath);
        FileUtil.delete(backupPath);
        FileUtil.copyDir(backupToMove, backupPath.toFile());
    }

    @NotNull
    public static Path getBackupPath() {
        Path configDir = PathManager.getConfigDir();
        Path path2 = configDir.resolveSibling(ConfigImportHelper.getConfigDirName() + "-backup");
        if (path2 == null) {
            ConfigImportHelper.$$$reportNull$$$0(11);
        }
        return path2;
    }

    @NotNull
    private static String getConfigDirName() {
        String string = PathManager.getConfigDir().getFileName().toString();
        if (string == null) {
            ConfigImportHelper.$$$reportNull$$$0(12);
        }
        return string;
    }

    private static boolean shouldAskForConfig() {
        String showImportDialog = System.getProperty(SHOW_IMPORT_CONFIG_DIALOG_PROPERTY);
        if ("force-not".equals(showImportDialog)) {
            return false;
        }
        return PluginManagerCore.isRunningFromSources() || System.getProperty("idea.config.path") != null || "true".equals(showImportDialog);
    }

    @Nullable
    private static Pair<Path, Path> showDialogAndGetOldConfigPath(@NotNull List<PathAndFileTime> guessedOldConfigDirs) {
        if (guessedOldConfigDirs == null) {
            ConfigImportHelper.$$$reportNull$$$0(13);
        }
        ImportOldConfigsPanel dialog2 = new ImportOldConfigsPanel(ContainerUtil.map(guessedOldConfigDirs, it -> it.path), ConfigImportHelper::findConfigDirectoryByPath);
        dialog2.setModalityType(Dialog.ModalityType.TOOLKIT_MODAL);
        AppUIUtil.updateWindowIcon(dialog2);
        Ref result2 = new Ref();
        SplashManager.executeWithHiddenSplash(dialog2, () -> {
            dialog2.setVisible(true);
            result2.set(dialog2.getSelectedFile());
            dialog2.dispose();
        });
        return (Pair)result2.get();
    }

    public static boolean isFirstSession() {
        return Boolean.getBoolean(FIRST_SESSION_KEY);
    }

    public static boolean isSettingsFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            ConfigImportHelper.$$$reportNull$$$0(14);
        }
        return FileTypeRegistry.getInstance().isFileOfType(file2, ArchiveFileType.INSTANCE);
    }

    public static boolean isConfigImported() {
        return Boolean.getBoolean(CONFIG_IMPORTED_IN_CURRENT_SESSION_KEY);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static boolean isValidSettingsFile(@NotNull File file2) {
        if (file2 == null) {
            ConfigImportHelper.$$$reportNull$$$0(15);
        }
        try (ZipFile zip = new ZipFile(file2);){
            boolean bl = zip.getEntry("IntelliJ IDEA Global Settings") != null;
            return bl;
        }
        catch (IOException ignored) {
            return false;
        }
    }

    public static boolean isConfigDirectory(@NotNull Path candidate) {
        if (candidate == null) {
            ConfigImportHelper.$$$reportNull$$$0(16);
        }
        return Arrays.stream(OPTIONS).anyMatch(name -> Files.exists(candidate.resolve((String)name), new LinkOption[0]));
    }

    @NotNull
    static List<PathAndFileTime> findConfigDirectories(@NotNull Path newConfigDir) {
        String productName;
        if (newConfigDir == null) {
            ConfigImportHelper.$$$reportNull$$$0(17);
        }
        HashSet<Path> homes = new HashSet<Path>();
        homes.add(newConfigDir.getParent());
        homes.add(newConfigDir.getFileSystem().getPath(PathManager.getDefaultConfigPathFor("X"), new String[0]).getParent());
        Path historic = newConfigDir.getFileSystem().getPath(ConfigImportHelper.defaultConfigPath("X2019.3"), new String[0]);
        homes.add(SystemInfo.isMac ? historic.getParent() : historic.getParent().getParent());
        String prefix = ConfigImportHelper.getPrefixFromSelector(PathManager.getPathsSelector());
        if (prefix == null) {
            prefix = ConfigImportHelper.getPrefixFromSelector(ConfigImportHelper.getNameWithVersion(newConfigDir));
        }
        if (prefix == null && (productName = ApplicationNamesInfo.getInstance().getFullProductName()) != null) {
            prefix = productName.replace(" ", "");
        }
        if (prefix == null) {
            prefix = PlatformUtils.getPlatformPrefix();
        }
        String dotPrefix = '.' + prefix;
        ArrayList<Path> candidates = new ArrayList<Path>();
        for (Path home : homes) {
            if (home == null || !Files.isDirectory(home, new LinkOption[0])) continue;
            try {
                DirectoryStream<Path> stream = Files.newDirectoryStream(home);
                Throwable throwable = null;
                try {
                    for (Path path2 : stream) {
                        String name;
                        if (path2.equals(newConfigDir) || !StringUtil.startsWithIgnoreCase(name = path2.getFileName().toString(), prefix) && !StringUtil.startsWithIgnoreCase(name, dotPrefix) || !Files.isDirectory(path2, new LinkOption[0])) continue;
                        candidates.add(path2);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (stream == null) continue;
                    if (throwable != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    stream.close();
                }
            }
            catch (IOException stream) {}
        }
        if (candidates.isEmpty()) {
            List<PathAndFileTime> list2 = Collections.emptyList();
            if (list2 == null) {
                ConfigImportHelper.$$$reportNull$$$0(18);
            }
            return list2;
        }
        ArrayList<PathAndFileTime> lastModified = new ArrayList<PathAndFileTime>();
        Iterator iterator2 = candidates.iterator();
        while (iterator2.hasNext()) {
            Path child2;
            Path candidate = child2 = (Path)iterator2.next();
            Path config2 = child2.resolve(CONFIG);
            if (Files.isDirectory(config2, new LinkOption[0])) {
                candidate = config2;
            }
            FileTime max = null;
            for (String name : OPTIONS) {
                try {
                    FileTime cur = Files.getLastModifiedTime(candidate.resolve(name), new LinkOption[0]);
                    if (max != null && cur.compareTo(max) <= 0) continue;
                    max = cur;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            lastModified.add(new PathAndFileTime(candidate, max != null ? max : FileTime.fromMillis(0L)));
        }
        lastModified.sort((o1, o2) -> {
            int diff = o2.fileTime.compareTo(o1.fileTime);
            if (diff == 0) {
                diff = StringUtil.naturalCompare(o2.path.toString(), o1.path.toString());
            }
            return diff;
        });
        ArrayList<PathAndFileTime> arrayList = lastModified;
        if (arrayList == null) {
            ConfigImportHelper.$$$reportNull$$$0(19);
        }
        return arrayList;
    }

    private static String getNameWithVersion(Path configDir) {
        String name = configDir.getFileName().toString();
        if (CONFIG.equals(name)) {
            name = StringUtil.trimStart(configDir.getParent().getFileName().toString(), ".");
        }
        return name;
    }

    @Nullable
    private static String getPrefixFromSelector(@Nullable String nameWithSelector) {
        Matcher m;
        if (nameWithSelector != null && (m = SELECTOR_PATTERN.matcher(nameWithSelector)).matches()) {
            return m.group(1);
        }
        return null;
    }

    @Nullable
    private static Pair<Path, Path> findConfigDirectoryByPath(Path selectedDir) {
        Path configDir;
        if (ConfigImportHelper.isConfigDirectory(selectedDir)) {
            return Pair.pair(selectedDir, null);
        }
        Path config2 = selectedDir.resolve(CONFIG);
        if (ConfigImportHelper.isConfigDirectory(config2)) {
            return Pair.pair(config2, null);
        }
        if (Files.isDirectory(selectedDir.resolve(SystemInfo.isMac ? CONTENTS : BIN), new LinkOption[0]) && (configDir = ConfigImportHelper.getSettingsPath(selectedDir, "idea.config.path", ConfigImportHelper::defaultConfigPath)) != null && ConfigImportHelper.isConfigDirectory(configDir)) {
            return Pair.pair(configDir, selectedDir);
        }
        return null;
    }

    @Nullable
    private static Path getSettingsPath(Path ideHome, String propertyName, Function<String, String> pathBySelector) {
        Path candidate;
        ArrayList<Path> files2 = new ArrayList<Path>();
        if (SystemInfo.isMac) {
            files2.add(ideHome.resolve("Contents/bin/idea.properties"));
            files2.add(ideHome.resolve("Contents/Info.plist"));
        } else {
            files2.add(ideHome.resolve("bin/idea.properties"));
            String scriptName = ApplicationNamesInfo.getInstance().getScriptName();
            files2.add(ideHome.resolve("bin/" + scriptName + ".bat"));
            files2.add(ideHome.resolve("bin/" + scriptName + ".sh"));
        }
        for (Path file2 : files2) {
            String candidatePath;
            if (!Files.isRegularFile(file2, new LinkOption[0]) || (candidatePath = PathManager.substituteVars(ConfigImportHelper.getPropertyFromFile(file2, propertyName), ideHome.toString())) == null || !Files.isDirectory(candidate = ideHome.getFileSystem().getPath(candidatePath, new String[0]), new LinkOption[0])) continue;
            return candidate.toAbsolutePath();
        }
        for (Path file2 : files2) {
            String selector;
            if (!Files.isRegularFile(file2, new LinkOption[0]) || (selector = ConfigImportHelper.getPropertyFromFile(file2, "idea.paths.selector")) == null || !Files.isDirectory(candidate = ideHome.getFileSystem().getPath(pathBySelector.apply(selector), new String[0]), new LinkOption[0])) continue;
            return candidate;
        }
        return null;
    }

    @Nullable
    private static String getPropertyFromFile(Path file2, String propertyName) {
        try {
            String propertyValue;
            String fileContent = new String(Files.readAllBytes(file2), StandardCharsets.UTF_8);
            String fileName = file2.getFileName().toString();
            if (fileName.endsWith(".properties")) {
                PropertyResourceBundle bundle = new PropertyResourceBundle(new StringReader(fileContent));
                return bundle.containsKey(propertyName) ? bundle.getString(propertyName) : null;
            }
            if (fileName.endsWith(".plist") && !StringUtil.isEmpty(propertyValue = ConfigImportHelper.findPListKey(propertyName, fileContent))) {
                return propertyValue;
            }
            propertyValue = ConfigImportHelper.findProperty(propertyName, fileContent);
            if (!StringUtil.isEmpty(propertyValue)) {
                return propertyValue;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    @Nullable
    private static String findPListKey(String propertyName, String fileContent) {
        String key = "<key>" + propertyName + "</key>";
        int idx = fileContent.indexOf(key);
        if (idx > 0 && (idx = fileContent.indexOf("<string>", idx + key.length())) != -1) {
            return ConfigImportHelper.fixDirName(fileContent.substring(idx += "<string>".length(), fileContent.indexOf("</string>", idx)));
        }
        return null;
    }

    @Nullable
    private static String findProperty(String propertyName, String fileContent) {
        String prefix = propertyName + "=";
        int idx = fileContent.indexOf(prefix);
        if (idx >= 0) {
            StringBuilder configDir = new StringBuilder();
            if (fileContent.length() > (idx += prefix.length())) {
                boolean quoted;
                boolean bl = quoted = fileContent.charAt(idx) == '\"';
                if (quoted) {
                    ++idx;
                }
                while (fileContent.length() > idx && (quoted ? fileContent.charAt(idx) != '\"' : fileContent.charAt(idx) != ' ' && fileContent.charAt(idx) != '\t') && fileContent.charAt(idx) != '\n' && fileContent.charAt(idx) != '\r') {
                    configDir.append(fileContent.charAt(idx));
                    ++idx;
                }
            }
            if (configDir.length() > 0) {
                return Paths.get(ConfigImportHelper.fixDirName(configDir.toString()), new String[0]).toString();
            }
        }
        return null;
    }

    private static String fixDirName(String dir) {
        return FileUtil.expandUserHome(StringUtil.unquoteString(dir, '\"'));
    }

    private static void doImport(@NotNull Path oldConfigDir, @NotNull Path newConfigDir, @Nullable Path oldIdeHome, @NotNull Logger log) {
        if (oldConfigDir == null) {
            ConfigImportHelper.$$$reportNull$$$0(20);
        }
        if (newConfigDir == null) {
            ConfigImportHelper.$$$reportNull$$$0(21);
        }
        if (log == null) {
            ConfigImportHelper.$$$reportNull$$$0(22);
        }
        if (oldConfigDir.equals(newConfigDir)) {
            log.info("New config directory is the same as the old one, no import needed.");
            return;
        }
        Path oldPluginsDir = oldConfigDir.resolve(PLUGINS);
        if (!Files.isDirectory(oldPluginsDir, new LinkOption[0])) {
            oldPluginsDir = null;
            if (oldIdeHome != null) {
                oldPluginsDir = ConfigImportHelper.getSettingsPath(oldIdeHome, "idea.plugins.path", ConfigImportHelper::defaultPluginsPath);
            }
            if (oldPluginsDir == null && !Files.isDirectory(oldPluginsDir = oldConfigDir.getFileSystem().getPath(ConfigImportHelper.defaultPluginsPath(ConfigImportHelper.getNameWithVersion(oldConfigDir)), new String[0]), new LinkOption[0]) && oldPluginsDir.toString().contains("2020.1")) {
                oldPluginsDir = oldConfigDir.getFileSystem().getPath(ConfigImportHelper.defaultPluginsPath(ConfigImportHelper.getNameWithVersion(oldConfigDir).replace("2020.1", "2019.3")).replace("2019.3", "2020.1"), new String[0]);
            }
        }
        Path newPluginsDir = newConfigDir.getFileSystem().getPath(PathManager.getPluginsPath(), new String[0]);
        try {
            log.info(String.format("Importing configs: oldConfigDir=[%s], newConfigDir=[%s], oldIdeHome=[%s], oldPluginsDir=[%s], newPluginsDir=[%s]", oldConfigDir, newConfigDir, oldIdeHome, oldPluginsDir, newPluginsDir));
            ConfigImportHelper.doImport(oldConfigDir, newConfigDir, oldIdeHome, oldPluginsDir, newPluginsDir, log);
        }
        catch (Exception e) {
            log.warn(e);
            String message = ApplicationBundle.message("error.unable.to.import.settings", e.getMessage());
            Main.showMessage((String)ApplicationBundle.message("title.settings.import.failed", new Object[0]), (String)message, (boolean)false);
        }
    }

    static void doImport(@NotNull Path oldConfigDir, @NotNull Path newConfigDir, @Nullable Path oldIdeHome, @NotNull Path oldPluginsDir, @NotNull Path newPluginsDir, @NotNull Logger log) throws IOException {
        if (oldConfigDir == null) {
            ConfigImportHelper.$$$reportNull$$$0(23);
        }
        if (newConfigDir == null) {
            ConfigImportHelper.$$$reportNull$$$0(24);
        }
        if (oldPluginsDir == null) {
            ConfigImportHelper.$$$reportNull$$$0(25);
        }
        if (newPluginsDir == null) {
            ConfigImportHelper.$$$reportNull$$$0(26);
        }
        if (log == null) {
            ConfigImportHelper.$$$reportNull$$$0(27);
        }
        if (Files.isRegularFile(oldConfigDir, new LinkOption[0])) {
            new Decompressor.Zip(oldConfigDir.toFile()).extract(newConfigDir.toFile());
            return;
        }
        FileUtil.copyDir(oldConfigDir.toFile(), newConfigDir.toFile(), file2 -> !ConfigImportHelper.blockImport(file2.toPath(), oldConfigDir, newConfigDir, oldPluginsDir));
        if (!Files.isDirectory(oldPluginsDir, new LinkOption[0])) {
            log.info("non-existing plugins directory: " + oldPluginsDir);
        } else if (!ConfigImportHelper.isEmptyDirectory(newPluginsDir)) {
            log.info("non-empty plugins directory: " + newPluginsDir);
        } else {
            FileUtil.copyDir(oldPluginsDir.toFile(), newPluginsDir.toFile());
        }
        if (SystemInfo.isMac && (PlatformUtils.isIntelliJ() || "AndroidStudio".equals(PlatformUtils.getPlatformPrefix()))) {
            ConfigImportHelper.setKeymapIfNeeded(oldConfigDir, newConfigDir, log);
        }
        if (Files.isDirectory(oldPluginsDir, new LinkOption[0])) {
            Path script;
            Path oldSystemDir = oldConfigDir.getParent().resolve(SYSTEM);
            if (!Files.isDirectory(oldSystemDir, new LinkOption[0])) {
                oldSystemDir = null;
                if (oldIdeHome != null) {
                    oldSystemDir = ConfigImportHelper.getSettingsPath(oldIdeHome, "idea.system.path", ConfigImportHelper::defaultSystemPath);
                }
                if (oldSystemDir == null) {
                    oldSystemDir = oldConfigDir.getFileSystem().getPath(ConfigImportHelper.defaultSystemPath(ConfigImportHelper.getNameWithVersion(oldConfigDir)), new String[0]);
                }
            }
            if (Files.isRegularFile(script = oldSystemDir.resolve("plugins/action.script"), new LinkOption[0])) {
                StartupActionScriptManager.executeActionScript((File)script.toFile(), (File)oldPluginsDir.toFile(), (File)new File(PathManager.getPluginsPath()));
            }
        }
        ConfigImportHelper.updateVMOptions(newConfigDir, log);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isEmptyDirectory(Path newPluginsDir) {
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(newPluginsDir);){
            Path path2;
            boolean hidden;
            Iterator<Path> iterator2 = stream.iterator();
            do {
                if (!iterator2.hasNext()) return true;
                path2 = iterator2.next();
            } while (hidden = SystemInfo.isWindows ? Files.readAttributes(path2, DosFileAttributes.class, new LinkOption[0]).isHidden() : path2.getFileName().startsWith("."));
            boolean bl = false;
            return bl;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    static void setKeymapIfNeeded(@NotNull Path oldConfigDir, @NotNull Path newConfigDir, @NotNull Logger log) {
        if (oldConfigDir == null) {
            ConfigImportHelper.$$$reportNull$$$0(28);
        }
        if (newConfigDir == null) {
            ConfigImportHelper.$$$reportNull$$$0(29);
        }
        if (log == null) {
            ConfigImportHelper.$$$reportNull$$$0(30);
        }
        String nameWithVersion = ConfigImportHelper.getNameWithVersion(oldConfigDir);
        Matcher m = Pattern.compile("\\.?[^\\d]+(\\d+\\.\\d+)?").matcher(nameWithVersion);
        if (!m.matches() || VersionComparatorUtil.compare("2019.1", m.group(1)) < 0) {
            return;
        }
        Path keymapOptionFile = newConfigDir.resolve("options/keymap.xml");
        if (Files.exists(keymapOptionFile, new LinkOption[0])) {
            return;
        }
        try {
            Files.createDirectories(keymapOptionFile.getParent(), new FileAttribute[0]);
            Files.write(keymapOptionFile, "<application>\n  <component name=\"KeymapManager\">\n    <active_keymap name=\"Mac OS X\" />\n  </component>\n</application>".getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (IOException e) {
            log.error("Cannot set keymap", e);
        }
    }

    private static void updateVMOptions(Path newConfigDir, Logger log) {
        Path vmOptionsFile = newConfigDir.resolve(VMOptions.getCustomVMOptionsFileName());
        if (Files.exists(vmOptionsFile, new LinkOption[0])) {
            try {
                List<String> lines = Files.readAllLines(vmOptionsFile);
                boolean updated = false;
                ListIterator<String> i = lines.listIterator();
                while (i.hasNext()) {
                    String line = i.next().trim();
                    if (line.equals("-XX:MaxJavaStackTraceDepth=-1")) {
                        i.set("-XX:MaxJavaStackTraceDepth=10000");
                        updated = true;
                        continue;
                    }
                    if (!line.startsWith("-agentlib:yjpagent")) continue;
                    i.remove();
                    updated = true;
                }
                if (updated) {
                    Files.write(vmOptionsFile, lines, new OpenOption[0]);
                }
            }
            catch (IOException e) {
                log.warn("Failed to update custom VM options file " + vmOptionsFile, e);
            }
        }
    }

    private static boolean blockImport(Path path2, Path oldConfig, Path newConfig, Path oldPluginsDir) {
        if (oldConfig.equals(path2.getParent())) {
            String name = path2.getFileName().toString();
            return "user.web.token".equals(name) || name.startsWith("chrome-user-data") || Files.exists(newConfig.resolve(path2.getFileName()), new LinkOption[0]) || path2.startsWith(oldPluginsDir);
        }
        return false;
    }

    private static String defaultConfigPath(String selector) {
        return ConfigImportHelper.newOrUnknown(selector) ? PathManager.getDefaultConfigPathFor(selector) : (SystemInfo.isMac ? SystemProperties.getUserHome() + "/Library/Preferences/" + selector : SystemProperties.getUserHome() + "/." + selector + '/' + CONFIG);
    }

    private static String defaultPluginsPath(String selector) {
        return ConfigImportHelper.newOrUnknown(selector) ? PathManager.getDefaultPluginPathFor(selector) : (SystemInfo.isMac ? SystemProperties.getUserHome() + "/Library/Application Support/" + selector : SystemProperties.getUserHome() + "/." + selector + '/' + CONFIG + '/' + PLUGINS);
    }

    private static String defaultSystemPath(String selector) {
        return ConfigImportHelper.newOrUnknown(selector) ? PathManager.getDefaultSystemPathFor(selector) : (SystemInfo.isMac ? SystemProperties.getUserHome() + "/Library/Caches/" + selector : SystemProperties.getUserHome() + "/." + selector + '/' + SYSTEM);
    }

    private static boolean newOrUnknown(String selector) {
        Matcher m = SELECTOR_PATTERN.matcher(selector);
        return !m.matches() || "2020.1".compareTo(m.group(2)) <= 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 11: 
            case 12: 
            case 18: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 11: 
            case 12: 
            case 18: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newConfigDir";
                break;
            }
            case 1: 
            case 5: 
            case 8: 
            case 10: 
            case 22: 
            case 27: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "log";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "time";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configDir";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentConfig";
                break;
            }
            case 6: 
            case 11: 
            case 12: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/application/ConfigImportHelper";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "backupToMove";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "guessedOldConfigDirs";
                break;
            }
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidate";
                break;
            }
            case 20: 
            case 23: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldConfigDir";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldPluginsDir";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newPluginsDir";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/application/ConfigImportHelper";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "backupCurrentConfigToTempAndDelete";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getBackupPath";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigDirName";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "findConfigDirectories";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "importConfigsTo";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isConfigOld";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "doesVmOptionFileExist";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "backupCurrentConfigToTempAndDelete";
                break;
            }
            case 6: 
            case 11: 
            case 12: 
            case 18: 
            case 19: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "deleteCurrentConfigDir";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "moveTempBackupToStandardBackup";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "showDialogAndGetOldConfigPath";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isSettingsFile";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isValidSettingsFile";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isConfigDirectory";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "findConfigDirectories";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "doImport";
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "setKeymapIfNeeded";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 11: 
            case 12: 
            case 18: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class PathAndFileTime {
        final Path path;
        final FileTime fileTime;

        PathAndFileTime(@NotNull Path path2, @NotNull FileTime fileTime) {
            if (path2 == null) {
                PathAndFileTime.$$$reportNull$$$0(0);
            }
            if (fileTime == null) {
                PathAndFileTime.$$$reportNull$$$0(1);
            }
            this.path = path2;
            this.fileTime = fileTime;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "path";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "fileTime";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/application/ConfigImportHelper$PathAndFileTime";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

