/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application;

import com.intellij.diagnostic.LoadingState;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ExperimentalFeature;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SmartList;
import com.intellij.util.concurrency.NonUrgentExecutor;
import com.intellij.util.containers.ContainerUtil;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
public final class Experiments {
    public static final ExtensionPointName<ExperimentalFeature> EP_NAME = ExtensionPointName.create("com.intellij.experimentalFeature");
    private static final Logger LOG = Logger.getInstance(Experiments.class);
    private final Map<String, Boolean> cache = ContainerUtil.newConcurrentMap();

    public Experiments() {
        NonUrgentExecutor.getInstance().execute(() -> {
            SmartList<String> enabledIds = new SmartList<String>();
            PropertiesComponent propertyManager = PropertiesComponent.getInstance();
            for (ExperimentalFeature feature : EP_NAME.getExtensionList()) {
                Boolean result2 = this.cache.get(feature.id);
                if (result2 == null) {
                    result2 = Experiments.calcIsFeatureEnabled(feature, propertyManager);
                    this.cache.put(feature.id, result2);
                }
                if (!result2.booleanValue()) continue;
                enabledIds.add(feature.id);
            }
            if (!enabledIds.isEmpty()) {
                LOG.info("Experimental features enabled for user: " + StringUtil.join(enabledIds, ", "));
            }
        });
    }

    @NotNull
    public static Experiments getInstance() {
        Experiments experiments = ApplicationManager.getApplication().getService(Experiments.class);
        if (experiments == null) {
            Experiments.$$$reportNull$$$0(0);
        }
        return experiments;
    }

    public boolean isFeatureEnabled(@NotNull String featureId) {
        if (featureId == null) {
            Experiments.$$$reportNull$$$0(1);
        }
        if (!LoadingState.COMPONENTS_REGISTERED.isOccurred()) {
            return false;
        }
        Boolean result2 = this.cache.get(featureId);
        if (result2 == null) {
            ExperimentalFeature feature = Experiments.getFeatureById(featureId);
            result2 = feature != null && Experiments.calcIsFeatureEnabled(feature, PropertiesComponent.getInstance());
            this.cache.put(featureId, result2);
        }
        return result2;
    }

    private static boolean calcIsFeatureEnabled(@NotNull ExperimentalFeature feature, @NotNull PropertiesComponent propertyManager) {
        String key;
        if (feature == null) {
            Experiments.$$$reportNull$$$0(2);
        }
        if (propertyManager == null) {
            Experiments.$$$reportNull$$$0(3);
        }
        return propertyManager.isValueSet(key = Experiments.toPropertyKey(feature)) ? propertyManager.getBoolean(key, false) : feature.isEnabled();
    }

    public void setFeatureEnabled(@NotNull String featureId, boolean enabled) {
        ExperimentalFeature feature;
        if (featureId == null) {
            Experiments.$$$reportNull$$$0(4);
        }
        if ((feature = Experiments.getFeatureById(featureId)) != null) {
            this.cache.put(featureId, enabled);
            String key = Experiments.toPropertyKey(feature);
            PropertiesComponent.getInstance().setValue(key, enabled, feature.isEnabled());
            LOG.info("Experimental feature '" + featureId + "' is now turned " + (enabled ? "ON" : "OFF"));
        }
    }

    @Nullable
    private static ExperimentalFeature getFeatureById(@NotNull String featureId) {
        if (featureId == null) {
            Experiments.$$$reportNull$$$0(5);
        }
        if (!LoadingState.COMPONENTS_REGISTERED.isOccurred()) {
            return null;
        }
        return EP_NAME.findFirstSafe(feature -> feature.id.equals(featureId));
    }

    public boolean isChanged(@NotNull String featureId) {
        ExperimentalFeature feature;
        if (featureId == null) {
            Experiments.$$$reportNull$$$0(6);
        }
        return (feature = Experiments.getFeatureById(featureId)) != null && feature.isEnabled() != this.isFeatureEnabled(featureId);
    }

    private static String toPropertyKey(@NotNull ExperimentalFeature feature) {
        if (feature == null) {
            Experiments.$$$reportNull$$$0(7);
        }
        return "experimentalFeature." + feature.id;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/application/Experiments";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "featureId";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "feature";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/application/Experiments";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isFeatureEnabled";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "calcIsFeatureEnabled";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setFeatureEnabled";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getFeatureById";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isChanged";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "toPropertyKey";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

