/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application;

import com.intellij.ide.ApplicationInitializedListener;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.service.fus.collectors.FUCounterUsageLogger;
import javax.swing.JRadioButton;
import org.jetbrains.annotations.NotNull;

public class ImportOldConfigsUsagesCollector {

    public static enum ImportOldConfigType {
        FROM_PREVIOUS,
        FROM_CUSTOM,
        DO_NOT_IMPORT,
        OTHER,
        NOT_INITIALIZED;

    }

    public static class ImportOldConfigsState {
        private static final ImportOldConfigsState ourInstance = new ImportOldConfigsState();
        private volatile boolean myOldConfigPanelWasOpened = false;
        private volatile boolean mySourceConfigFolderExists = false;
        @NotNull
        private volatile ImportOldConfigType myType = ImportOldConfigType.NOT_INITIALIZED;

        public static ImportOldConfigsState getInstance() {
            return ourInstance;
        }

        public void saveImportOldConfigType(@NotNull JRadioButton previous, @NotNull JRadioButton custom, @NotNull JRadioButton doNotImport, boolean configFolderExists) {
            if (previous == null) {
                ImportOldConfigsState.$$$reportNull$$$0(0);
            }
            if (custom == null) {
                ImportOldConfigsState.$$$reportNull$$$0(1);
            }
            if (doNotImport == null) {
                ImportOldConfigsState.$$$reportNull$$$0(2);
            }
            this.myOldConfigPanelWasOpened = true;
            this.mySourceConfigFolderExists = configFolderExists;
            this.myType = ImportOldConfigsState.getOldImportType(previous, custom, doNotImport);
        }

        @NotNull
        private static ImportOldConfigType getOldImportType(@NotNull JRadioButton previous, @NotNull JRadioButton custom, @NotNull JRadioButton doNotImport) {
            if (previous == null) {
                ImportOldConfigsState.$$$reportNull$$$0(3);
            }
            if (custom == null) {
                ImportOldConfigsState.$$$reportNull$$$0(4);
            }
            if (doNotImport == null) {
                ImportOldConfigsState.$$$reportNull$$$0(5);
            }
            if (previous.isSelected()) {
                ImportOldConfigType importOldConfigType = ImportOldConfigType.FROM_PREVIOUS;
                if (importOldConfigType == null) {
                    ImportOldConfigsState.$$$reportNull$$$0(6);
                }
                return importOldConfigType;
            }
            if (custom.isSelected()) {
                ImportOldConfigType importOldConfigType = ImportOldConfigType.FROM_CUSTOM;
                if (importOldConfigType == null) {
                    ImportOldConfigsState.$$$reportNull$$$0(7);
                }
                return importOldConfigType;
            }
            if (doNotImport.isSelected()) {
                ImportOldConfigType importOldConfigType = ImportOldConfigType.DO_NOT_IMPORT;
                if (importOldConfigType == null) {
                    ImportOldConfigsState.$$$reportNull$$$0(8);
                }
                return importOldConfigType;
            }
            ImportOldConfigType importOldConfigType = ImportOldConfigType.OTHER;
            if (importOldConfigType == null) {
                ImportOldConfigsState.$$$reportNull$$$0(9);
            }
            return importOldConfigType;
        }

        public boolean isOldConfigPanelWasOpened() {
            return this.myOldConfigPanelWasOpened;
        }

        public boolean isSourceConfigFolderExists() {
            return this.mySourceConfigFolderExists;
        }

        @NotNull
        public ImportOldConfigType getType() {
            ImportOldConfigType importOldConfigType = this.myType;
            if (importOldConfigType == null) {
                ImportOldConfigsState.$$$reportNull$$$0(10);
            }
            return importOldConfigType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "previous";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "custom";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "doNotImport";
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/application/ImportOldConfigsUsagesCollector$ImportOldConfigsState";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/application/ImportOldConfigsUsagesCollector$ImportOldConfigsState";
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOldImportType";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "saveImportOldConfigType";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "getOldImportType";
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class Trigger
    implements ApplicationInitializedListener {
        @Override
        public void componentsInitialized() {
            ImportOldConfigsState state = ImportOldConfigsState.getInstance();
            if (state.isOldConfigPanelWasOpened()) {
                FeatureUsageData data2 = new FeatureUsageData().addData("selected", state.getType().name()).addData("config_folder_exists", state.isSourceConfigFolderExists());
                FUCounterUsageLogger.getInstance().logEvent("import.old.config", "import.dialog.shown", data2);
            }
        }
    }
}

