/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application.impl;

import com.intellij.execution.process.OSProcessUtil;
import com.intellij.ide.ApplicationInitializedListener;
import com.intellij.ide.PowerSaveMode;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SystemProperties;
import com.sun.tools.attach.VirtualMachine;
import java.io.File;
import sun.tools.attach.HotSpotVirtualMachine;

final class JitSuppressor
implements ApplicationInitializedListener {
    private static final Logger LOG = Logger.getInstance(JitSuppressor.class);
    private static final String SELF_ATTACH_PROP = "jdk.attach.allowAttachSelf";
    private static final String EXCLUDE_ALL_FROM_C2_CLAUSE = "{ match : [\"*.*\"], c2 : { Exclude : true }}";
    private static final String[] C2_WHITELIST = new String[]{"com/intellij/openapi/application/*.*", "com/intellij/openapi/editor/*.*", "com/intellij/openapi/project/*.*", "com/intellij/openapi/util/text/*.*", "com/intellij/openapi/util/io/*.*", "com/intellij/openapi/vfs/*.*", "com/intellij/openapi/fileTypes/*.*", "com/intellij/openapi/progress/*.*", "com/intellij/psi/codeStyle/*.*", "com/intellij/psi/util/*.*", "com/intellij/psi/impl/source/tree/*.*", "com/intellij/util/*.*", "com/intellij/semantic/*.*", "com/intellij/lang/impl/*.*", "com/intellij/lang/parser/*.*", "java/lang/*.*", "java/math/*.*", "jdk/internal/*.*", "sun/*.*"};
    private static final String[] C2_BLACKLIST = new String[]{"javax/swing/*.*", "javax/awt/*.*", "sun/awt/*.*", "sun/java2d/*.*"};
    private static final boolean ourBlacklistMode = true;

    JitSuppressor() {
    }

    @Override
    public void componentsInitialized() {
        if (!SystemProperties.getBooleanProperty("enable.jit.suppressor", false)) {
            return;
        }
        if (System.getProperty("java.specification.version").contains(".")) {
            return;
        }
        String javaSpecVendor = System.getProperty("java.vm.specification.vendor");
        if (!"Oracle Corporation".equals(javaSpecVendor)) {
            LOG.warn("JitSuppressor functionality is not supported on non-Oracle vm. This one is " + javaSpecVendor);
            return;
        }
        if (!"true".equals(System.getProperty(SELF_ATTACH_PROP))) {
            String msg = "JitSuppressor wasn't registered. Please ensure the command line contains -Djdk.attach.allowAttachSelf=true";
            if (ApplicationInfoImpl.isInStressTest()) {
                LOG.warn(msg + " to get production-like performance");
            } else if (!ApplicationManager.getApplication().isUnitTestMode()) {
                LOG.warn(msg);
            }
            return;
        }
        LOG.info("JitSuppressor is active");
        ApplicationManager.getApplication().getMessageBus().connect().subscribe(PowerSaveMode.TOPIC, new PowerSaveMode.Listener(){

            @Override
            public void powerSaveStateChanged() {
                JitSuppressor.powerSaveStateChanged();
            }
        });
        JitSuppressor.powerSaveStateChanged();
    }

    private static void powerSaveStateChanged() {
        String directives = "[" + JitSuppressor.generateDirectives() + "]";
        Runnable runnable2 = () -> JitSuppressor.setDirectives(directives);
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            runnable2.run();
        } else {
            ApplicationManager.getApplication().executeOnPooledThread(runnable2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setDirectives(String directives) {
        File tmpFile = null;
        try {
            tmpFile = FileUtil.createTempFile("c2_directive", "json");
            FileUtil.writeToFile(tmpFile, directives);
            VirtualMachine vm = VirtualMachine.attach(OSProcessUtil.getApplicationPid());
            HotSpotVirtualMachine hvm = (HotSpotVirtualMachine)vm;
            hvm.executeJCmd("Compiler.directives_clear");
            hvm.executeJCmd("Compiler.directives_add " + tmpFile.getAbsolutePath());
            vm.detach();
        }
        catch (Exception e) {
            LOG.error(e);
        }
        finally {
            if (tmpFile != null) {
                FileUtil.delete(tmpFile);
            }
        }
    }

    private static String generateDirectives() {
        if (PowerSaveMode.isEnabled()) {
            return EXCLUDE_ALL_FROM_C2_CLAUSE;
        }
        return StringUtil.join(C2_BLACKLIST, mask -> "{ match: [\"" + mask + "\"], c2: { Exclude: true, }, },", "");
    }

    private static /* synthetic */ String lambda$generateDirectives$2(String mask) {
        return "{ match: [\"" + mask + "\"], c2: { Exclude: false, }, },";
    }
}

