/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application.impl;

import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ex.ApplicationUtil;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.impl.CoreProgressManager;
import com.intellij.util.containers.ConcurrentList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.LockSupport;
import org.jetbrains.annotations.NotNull;

class ReadMostlyRWLock {
    volatile Thread writeThread = null;
    private volatile Thread writeIntendedThread = null;
    volatile boolean writeRequested;
    private final AtomicBoolean writeIntent = new AtomicBoolean(false);
    private volatile boolean writeAcquired;
    private final ConcurrentList<Reader> readers = ContainerUtil.createConcurrentList();
    private volatile boolean writeSuspended;
    private final ThreadLocal<Reader> R = ThreadLocal.withInitial(() -> {
        Reader status = new Reader(Thread.currentThread());
        boolean added = this.readers.addIfAbsent(status);
        assert (added) : this.readers + "; " + Thread.currentThread();
        return status;
    });
    private static final int SPIN_TO_WAIT_FOR_LOCK = 100;

    ReadMostlyRWLock() {
    }

    void setWriteThread(Thread thread) {
        assert (!this.writeAcquired);
        assert (!this.writeRequested);
        assert (this.writeThread == null);
        this.writeThread = thread;
    }

    boolean isWriteThread() {
        return Thread.currentThread() == this.writeThread;
    }

    boolean isReadLockedByThisThread() {
        this.checkReadThreadAccess();
        Reader status = this.R.get();
        return status.readRequested;
    }

    boolean checkReadLockedByThisThreadAndNoPendingWrites() throws ApplicationUtil.CannotRunReadActionException {
        this.checkReadThreadAccess();
        Reader status = this.R.get();
        this.throwIfImpatient(status);
        return status.readRequested;
    }

    void readLock() {
        this.checkReadThreadAccess();
        Reader status = this.R.get();
        this.throwIfImpatient(status);
        if (this.tryReadLock(status)) {
            return;
        }
        int iter = 0;
        while (!this.tryReadLock(status)) {
            ProgressManager.checkCanceled();
            this.waitABit(status, iter);
            ++iter;
        }
    }

    private void waitABit(Reader status, int iteration) {
        if (iteration > 100) {
            status.blocked = true;
            try {
                this.throwIfImpatient(status);
                LockSupport.parkNanos(this, 1000000L);
            }
            finally {
                status.blocked = false;
            }
        } else {
            Thread.yield();
        }
    }

    private void throwIfImpatient(Reader status) throws ApplicationUtil.CannotRunReadActionException {
        if (status.impatientReads && this.writeRequested && !ProgressManager.getInstance().isInNonCancelableSection() && CoreProgressManager.ENABLED) {
            throw ApplicationUtil.CannotRunReadActionException.create();
        }
    }

    boolean isInImpatientReader() {
        return this.R.get().impatientReads;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void executeByImpatientReader(@NotNull Runnable runnable2) throws ApplicationUtil.CannotRunReadActionException {
        if (runnable2 == null) {
            ReadMostlyRWLock.$$$reportNull$$$0(0);
        }
        this.checkReadThreadAccess();
        Reader status = this.R.get();
        boolean old = status.impatientReads;
        try {
            status.impatientReads = true;
            runnable2.run();
        }
        finally {
            status.impatientReads = old;
        }
    }

    void readUnlock() {
        this.checkReadThreadAccess();
        Reader status = this.R.get();
        status.readRequested = false;
        if (this.writeRequested) {
            LockSupport.unpark(this.writeThread);
        }
    }

    boolean tryReadLock() {
        this.checkReadThreadAccess();
        Reader status = this.R.get();
        return this.tryReadLock(status);
    }

    private boolean tryReadLock(Reader status) {
        this.throwIfImpatient(status);
        if (!this.writeRequested) {
            status.readRequested = true;
            if (!this.writeRequested) {
                return true;
            }
            status.readRequested = false;
        }
        return false;
    }

    void writeIntentLock() {
        this.writeIntendedThread = Thread.currentThread();
        int iter = 0;
        while (true) {
            if (this.writeIntent.compareAndSet(false, true)) {
                assert (!this.writeRequested);
                assert (!this.writeAcquired);
                break;
            }
            if (iter > 100) {
                LockSupport.parkNanos(this, 1000000L);
            } else {
                Thread.yield();
            }
            ++iter;
        }
        this.writeThread = Thread.currentThread();
    }

    void writeIntentUnlock() {
        this.checkWriteThreadAccess();
        assert (!this.writeAcquired);
        assert (!this.writeRequested);
        this.writeThread = null;
        this.writeIntent.set(false);
        LockSupport.unpark(this.writeIntendedThread);
    }

    void writeLock() {
        this.checkWriteThreadAccess();
        assert (!this.writeRequested);
        assert (!this.writeAcquired);
        this.writeRequested = true;
        int iter = 0;
        while (true) {
            if (this.areAllReadersIdle()) break;
            if (iter > 100) {
                LockSupport.parkNanos(this, 1000000L);
            } else {
                Thread.yield();
            }
            ++iter;
        }
        this.writeAcquired = true;
    }

    AccessToken writeSuspend() {
        final boolean prev = this.writeSuspended;
        this.writeSuspended = true;
        this.writeUnlock();
        return new AccessToken(){

            @Override
            public void finish() {
                ReadMostlyRWLock.this.writeLock();
                ReadMostlyRWLock.this.writeSuspended = prev;
            }
        };
    }

    void writeUnlock() {
        this.checkWriteThreadAccess();
        this.writeAcquired = false;
        this.writeRequested = false;
        ArrayList<Reader> dead = new ArrayList<Reader>(this.readers.size());
        for (Reader reader : this.readers) {
            if (reader.blocked) {
                LockSupport.unpark(reader.thread);
                continue;
            }
            if (reader.thread.isAlive()) continue;
            dead.add(reader);
        }
        this.readers.removeAll(dead);
    }

    private void checkWriteThreadAccess() {
        if (Thread.currentThread() != this.writeThread) {
            throw new IllegalStateException("Current thread: " + Thread.currentThread() + "; expected: " + this.writeThread);
        }
    }

    private void checkReadThreadAccess() {
        if (Thread.currentThread() == this.writeThread) {
            throw new IllegalStateException("Must not start read from the write thread: " + Thread.currentThread());
        }
    }

    private boolean areAllReadersIdle() {
        for (Reader reader : this.readers) {
            if (!reader.readRequested) continue;
            return false;
        }
        return true;
    }

    boolean isWriteLocked() {
        return this.writeAcquired;
    }

    public String toString() {
        return "ReadMostlyRWLock{writeThread=" + this.writeThread + ", writeRequested=" + this.writeRequested + ", writeAcquired=" + this.writeAcquired + ", readers=" + this.readers + ", writeSuspended=" + this.writeSuspended + '}';
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/openapi/application/impl/ReadMostlyRWLock", "executeByImpatientReader"));
    }

    private static class Reader {
        @NotNull
        private final Thread thread;
        private volatile boolean readRequested;
        private volatile boolean blocked;
        private boolean impatientReads;

        Reader(@NotNull Thread readerThread) {
            if (readerThread == null) {
                Reader.$$$reportNull$$$0(0);
            }
            this.thread = readerThread;
        }

        public String toString() {
            return "Reader{thread=" + this.thread + ", readRequested=" + this.readRequested + ", blocked=" + this.blocked + ", impatientReads=" + this.impatientReads + '}';
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "readerThread", "com/intellij/openapi/application/impl/ReadMostlyRWLock$Reader", "<init>"));
        }
    }
}

