/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.command.impl;

import com.intellij.history.core.LocalHistoryFacade;
import com.intellij.history.core.changes.Change;
import com.intellij.history.integration.IdeaGateway;
import com.intellij.history.integration.revertion.UndoChangeRevertingVisitor;
import com.intellij.openapi.util.Ref;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangeRange {
    private final IdeaGateway myGateway;
    private final LocalHistoryFacade myVcs;
    private final Long myFromChangeId;
    @Nullable
    private final Long myToChangeId;

    public ChangeRange(IdeaGateway gw, LocalHistoryFacade vcs, @NotNull Long changeId) {
        if (changeId == null) {
            ChangeRange.$$$reportNull$$$0(0);
        }
        this(gw, vcs, changeId, changeId);
    }

    private ChangeRange(IdeaGateway gw, LocalHistoryFacade vcs, @Nullable Long fromChangeId, @Nullable Long toChangeId) {
        this.myGateway = gw;
        this.myVcs = vcs;
        this.myFromChangeId = fromChangeId;
        this.myToChangeId = toChangeId;
    }

    public ChangeRange revert(ChangeRange reverse) throws IOException {
        final Ref<Long> first = new Ref<Long>();
        final Ref<Long> last = new Ref<Long>();
        LocalHistoryFacade.Listener l = new LocalHistoryFacade.Listener(){

            @Override
            public void changeAdded(Change c) {
                if (first.isNull()) {
                    first.set(c.getId());
                }
                last.set(c.getId());
            }
        };
        this.myVcs.addListener(l, null);
        try {
            this.myVcs.accept(new UndoChangeRevertingVisitor(this.myGateway, this.myToChangeId, this.myFromChangeId));
        }
        catch (UndoChangeRevertingVisitor.RuntimeIOException e) {
            throw (IOException)e.getCause();
        }
        finally {
            this.myVcs.removeListener(l);
        }
        if (reverse != null) {
            if (first.isNull()) {
                first.set(reverse.myFromChangeId);
            }
            if (last.isNull()) {
                last.set(reverse.myToChangeId);
            }
        }
        return new ChangeRange(this.myGateway, this.myVcs, (Long)first.get(), (Long)last.get());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changeId", "com/intellij/openapi/command/impl/ChangeRange", "<init>"));
    }
}

