/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.command.impl;

import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.command.impl.EditorAndState;
import com.intellij.openapi.command.impl.NonUndoableAction;
import com.intellij.openapi.command.impl.Redo;
import com.intellij.openapi.command.impl.Undo;
import com.intellij.openapi.command.impl.UndoManagerImpl;
import com.intellij.openapi.command.impl.UndoRedo;
import com.intellij.openapi.command.impl.UndoableGroup;
import com.intellij.openapi.command.undo.BasicUndoableAction;
import com.intellij.openapi.command.undo.DocumentReference;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.ArrayUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommandMerger {
    private final UndoManagerImpl myManager;
    private Object myLastGroupId;
    private boolean myForcedGlobal;
    private boolean myTransparent;
    private String myCommandName;
    private boolean myValid;
    private List<UndoableAction> myCurrentActions;
    private Set<DocumentReference> myAllAffectedDocuments;
    private Set<DocumentReference> myAdditionalAffectedDocuments;
    private EditorAndState myStateBefore;
    private EditorAndState myStateAfter;
    private UndoConfirmationPolicy myUndoConfirmationPolicy;

    CommandMerger(@NotNull UndoManagerImpl manager) {
        if (manager == null) {
            CommandMerger.$$$reportNull$$$0(0);
        }
        this.myValid = true;
        this.myCurrentActions = new ArrayList<UndoableAction>();
        this.myAllAffectedDocuments = new THashSet<DocumentReference>();
        this.myAdditionalAffectedDocuments = new THashSet<DocumentReference>();
        this.myUndoConfirmationPolicy = UndoConfirmationPolicy.DEFAULT;
        this.myManager = manager;
    }

    CommandMerger(@NotNull UndoManagerImpl manager, boolean isTransparent) {
        if (manager == null) {
            CommandMerger.$$$reportNull$$$0(1);
        }
        this.myValid = true;
        this.myCurrentActions = new ArrayList<UndoableAction>();
        this.myAllAffectedDocuments = new THashSet<DocumentReference>();
        this.myAdditionalAffectedDocuments = new THashSet<DocumentReference>();
        this.myUndoConfirmationPolicy = UndoConfirmationPolicy.DEFAULT;
        this.myManager = manager;
        this.myTransparent = isTransparent;
    }

    public String getCommandName() {
        return this.myCommandName;
    }

    public void addAction(@NotNull UndoableAction action2) {
        if (action2 == null) {
            CommandMerger.$$$reportNull$$$0(2);
        }
        this.myCurrentActions.add(action2);
        DocumentReference[] refs = action2.getAffectedDocuments();
        if (refs != null) {
            Collections.addAll(this.myAllAffectedDocuments, refs);
        }
        this.myForcedGlobal |= action2.isGlobal();
    }

    public void commandFinished(String commandName, Object groupId2, @NotNull CommandMerger nextCommandToMerge) {
        if (nextCommandToMerge == null) {
            CommandMerger.$$$reportNull$$$0(3);
        }
        if (!nextCommandToMerge.isTransparent() && nextCommandToMerge.hasActions()) {
            this.clearRedoStacks(nextCommandToMerge);
        }
        if (!this.shouldMerge(groupId2, nextCommandToMerge)) {
            this.flushCurrentCommand();
            this.myManager.compact();
        }
        this.merge(nextCommandToMerge);
        if (nextCommandToMerge.isTransparent() || !this.hasActions()) {
            return;
        }
        this.myLastGroupId = groupId2;
        if (this.myCommandName == null) {
            this.myCommandName = commandName;
        }
    }

    private boolean shouldMerge(Object groupId2, @NotNull CommandMerger nextCommandToMerge) {
        if (nextCommandToMerge == null) {
            CommandMerger.$$$reportNull$$$0(4);
        }
        if (nextCommandToMerge.isTransparent() && nextCommandToMerge.myStateAfter == null && this.myStateAfter != null) {
            return false;
        }
        if (this.isTransparent() && this.myStateBefore == null && nextCommandToMerge.myStateBefore != null) {
            return false;
        }
        if (this.isTransparent() || nextCommandToMerge.isTransparent()) {
            return !this.hasActions() || !nextCommandToMerge.hasActions() || this.myAllAffectedDocuments.equals(nextCommandToMerge.myAllAffectedDocuments);
        }
        return !this.myForcedGlobal && !nextCommandToMerge.myForcedGlobal && CommandMerger.canMergeGroup(groupId2, this.myLastGroupId);
    }

    public static boolean canMergeGroup(Object groupId2, Object lastGroupId) {
        return groupId2 != null && Comparing.equal(lastGroupId, groupId2);
    }

    private void merge(@NotNull CommandMerger nextCommandToMerge) {
        if (nextCommandToMerge == null) {
            CommandMerger.$$$reportNull$$$0(5);
        }
        this.setBeforeState(nextCommandToMerge.myStateBefore);
        this.myStateAfter = nextCommandToMerge.myStateAfter;
        if (this.myTransparent) {
            if (nextCommandToMerge.hasActions()) {
                this.myTransparent &= nextCommandToMerge.myTransparent;
            }
        } else if (!this.hasActions()) {
            this.myTransparent = nextCommandToMerge.myTransparent;
        }
        this.myValid &= nextCommandToMerge.myValid;
        this.myForcedGlobal |= nextCommandToMerge.myForcedGlobal;
        this.myCurrentActions.addAll(nextCommandToMerge.myCurrentActions);
        this.myAllAffectedDocuments.addAll(nextCommandToMerge.myAllAffectedDocuments);
        this.myAdditionalAffectedDocuments.addAll(nextCommandToMerge.myAdditionalAffectedDocuments);
        this.mergeUndoConfirmationPolicy(nextCommandToMerge.getUndoConfirmationPolicy());
    }

    void mergeUndoConfirmationPolicy(UndoConfirmationPolicy undoConfirmationPolicy) {
        if (this.myUndoConfirmationPolicy == UndoConfirmationPolicy.DEFAULT) {
            this.myUndoConfirmationPolicy = undoConfirmationPolicy;
        } else if (this.myUndoConfirmationPolicy == UndoConfirmationPolicy.DO_NOT_REQUEST_CONFIRMATION && undoConfirmationPolicy == UndoConfirmationPolicy.REQUEST_CONFIRMATION) {
            this.myUndoConfirmationPolicy = UndoConfirmationPolicy.REQUEST_CONFIRMATION;
        }
    }

    void flushCurrentCommand() {
        if (this.hasActions()) {
            if (!this.myAdditionalAffectedDocuments.isEmpty()) {
                DocumentReference[] refs = this.myAdditionalAffectedDocuments.toArray(DocumentReference.EMPTY_ARRAY);
                this.myCurrentActions.add(new BasicUndoableAction(refs){

                    @Override
                    public void undo() {
                    }

                    @Override
                    public void redo() {
                    }
                });
            }
            this.myManager.getUndoStacksHolder().addToStacks(new UndoableGroup(this.myCommandName, this.isGlobal(), this.myManager, this.myStateBefore, this.myStateAfter, this.myCurrentActions, this.myUndoConfirmationPolicy, this.isTransparent(), this.myValid));
        }
        this.reset();
    }

    private void reset() {
        this.myCurrentActions = new ArrayList<UndoableAction>();
        this.myAllAffectedDocuments = new THashSet<DocumentReference>();
        this.myAdditionalAffectedDocuments = new THashSet<DocumentReference>();
        this.myLastGroupId = null;
        this.myForcedGlobal = false;
        this.myTransparent = false;
        this.myCommandName = null;
        this.myValid = true;
        this.myStateAfter = null;
        this.myStateBefore = null;
        this.myUndoConfirmationPolicy = UndoConfirmationPolicy.DEFAULT;
    }

    private void clearRedoStacks(@NotNull CommandMerger nextMerger) {
        if (nextMerger == null) {
            CommandMerger.$$$reportNull$$$0(6);
        }
        this.myManager.getRedoStacksHolder().clearStacks(nextMerger.isGlobal(), nextMerger.myAllAffectedDocuments);
    }

    boolean isGlobal() {
        return this.myForcedGlobal || this.affectsMultiplePhysicalDocs();
    }

    void markAsGlobal() {
        this.myForcedGlobal = true;
    }

    public boolean isTransparent() {
        return this.myTransparent;
    }

    private boolean affectsMultiplePhysicalDocs() {
        HashSet<VirtualFile> affectedFiles = new HashSet<VirtualFile>();
        for (DocumentReference each : this.myAllAffectedDocuments) {
            VirtualFile file2 = each.getFile();
            if (CommandMerger.isVirtualDocumentChange(file2)) continue;
            affectedFiles.add(file2);
            if (affectedFiles.size() <= 1) continue;
            return true;
        }
        return false;
    }

    private static boolean isVirtualDocumentChange(VirtualFile file2) {
        return file2 == null || file2 instanceof LightVirtualFile;
    }

    void undoOrRedo(FileEditor editor, boolean isUndo) {
        UndoRedo undoRedo;
        this.flushCurrentCommand();
        while ((undoRedo = this.createUndoOrRedo(editor, true)) != null && undoRedo.isTemporary()) {
            if (!undoRedo.execute(true, false)) {
                return;
            }
            if (undoRedo.hasMoreActions()) continue;
        }
        while ((undoRedo = this.createUndoOrRedo(editor, isUndo)) != null && undoRedo.isTransparent()) {
            if (!undoRedo.execute(false, false)) {
                return;
            }
            if (undoRedo.hasMoreActions()) continue;
        }
        boolean isInsideStartFinishGroup = false;
        while ((undoRedo = this.createUndoOrRedo(editor, isUndo)) != null) {
            boolean shouldRepeat;
            UndoRedo blockingChange;
            if (editor != null && undoRedo.isBlockedByOtherChanges() && (blockingChange = this.createUndoOrRedo(null, isUndo)) != null && blockingChange.myUndoableGroup != undoRedo.myUndoableGroup) {
                if (!undoRedo.confirmSwitchTo(blockingChange)) break;
                blockingChange.execute(false, true);
                break;
            }
            if (!undoRedo.execute(false, isInsideStartFinishGroup)) {
                return;
            }
            if ((isInsideStartFinishGroup = undoRedo.myUndoableGroup.isInsideStartFinishGroup(isUndo, isInsideStartFinishGroup)) || (shouldRepeat = undoRedo.isTransparent() && undoRedo.hasMoreActions())) continue;
            break;
        }
    }

    @Nullable
    private UndoRedo createUndoOrRedo(FileEditor editor, boolean isUndo) {
        if (!this.myManager.isUndoOrRedoAvailable(editor, isUndo)) {
            return null;
        }
        return isUndo ? new Undo(this.myManager, editor) : new Redo(this.myManager, editor);
    }

    public UndoConfirmationPolicy getUndoConfirmationPolicy() {
        return this.myUndoConfirmationPolicy;
    }

    boolean hasActions() {
        return !this.myCurrentActions.isEmpty();
    }

    public boolean isPhysical() {
        if (this.myAllAffectedDocuments.isEmpty()) {
            return false;
        }
        for (DocumentReference each : this.myAllAffectedDocuments) {
            if (!CommandMerger.isVirtualDocumentChange(each.getFile())) continue;
            return false;
        }
        return true;
    }

    public boolean isUndoAvailable(@NotNull Collection<? extends DocumentReference> refs) {
        if (refs == null) {
            CommandMerger.$$$reportNull$$$0(7);
        }
        if (this.hasNonUndoableActions()) {
            return false;
        }
        if (refs.isEmpty()) {
            return this.isGlobal() && this.hasActions();
        }
        for (DocumentReference documentReference : refs) {
            if (!this.hasChangesOf(documentReference)) continue;
            return true;
        }
        return false;
    }

    private boolean hasNonUndoableActions() {
        for (UndoableAction each : this.myCurrentActions) {
            if (!(each instanceof NonUndoableAction)) continue;
            return true;
        }
        return false;
    }

    private boolean hasChangesOf(DocumentReference ref) {
        return this.hasChangesOf(ref, false);
    }

    boolean hasChangesOf(DocumentReference ref, boolean onlyDirectChanges) {
        for (UndoableAction action2 : this.myCurrentActions) {
            DocumentReference[] refs = action2.getAffectedDocuments();
            if (!(refs == null ? !onlyDirectChanges : ArrayUtil.contains(ref, refs))) continue;
            return true;
        }
        return this.hasActions() && this.myAdditionalAffectedDocuments.contains(ref);
    }

    void setBeforeState(EditorAndState state) {
        if (this.myStateBefore == null || !this.hasActions()) {
            this.myStateBefore = state;
        }
    }

    void setAfterState(EditorAndState state) {
        this.myStateAfter = state;
    }

    void addAdditionalAffectedDocuments(@NotNull Collection<? extends DocumentReference> refs) {
        if (refs == null) {
            CommandMerger.$$$reportNull$$$0(8);
        }
        this.myAllAffectedDocuments.addAll(refs);
        this.myAdditionalAffectedDocuments.addAll(refs);
    }

    void invalidateActionsFor(@NotNull DocumentReference ref) {
        if (ref == null) {
            CommandMerger.$$$reportNull$$$0(9);
        }
        if (this.myAllAffectedDocuments.contains(ref)) {
            this.myValid = false;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nextCommandToMerge";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nextMerger";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refs";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/command/impl/CommandMerger";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "addAction";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "commandFinished";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "shouldMerge";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "merge";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "clearRedoStacks";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "isUndoAvailable";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "addAdditionalAffectedDocuments";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "invalidateActionsFor";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

