/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.command.impl;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.command.CommandToken;
import com.intellij.openapi.command.impl.CommandLog;
import com.intellij.openapi.command.impl.CoreCommandProcessor;
import com.intellij.openapi.command.impl.UndoManagerImpl;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.impl.FocusBasedCurrentEditorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ExceptionUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CommandProcessorImpl
extends CoreCommandProcessor {
    CommandProcessorImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finishCommand(@NotNull CommandToken command, @Nullable Throwable throwable) {
        boolean failed;
        if (command == null) {
            CommandProcessorImpl.$$$reportNull$$$0(0);
        }
        if (this.myCurrentCommand != command) {
            return;
        }
        try {
            if (throwable != null) {
                failed = true;
                ExceptionUtil.rethrowUnchecked(throwable);
                CommandLog.LOG.error(throwable);
            } else {
                failed = false;
            }
        }
        finally {
            try {
                super.finishCommand(command, throwable);
            }
            catch (Throwable e) {
                if (throwable != null) {
                    e.addSuppressed(throwable);
                }
                throw e;
            }
        }
        if (failed) {
            Project project2 = command.getProject();
            if (project2 != null) {
                FileEditor editor = new FocusBasedCurrentEditorProvider().getCurrentEditor();
                UndoManager undoManager = UndoManager.getInstance(project2);
                if (undoManager.isUndoAvailable(editor)) {
                    undoManager.undo(editor);
                }
            }
            Messages.showErrorDialog(project2, IdeBundle.message("dialog.message.cannot.perform.operation.too.complex.sorry", new Object[0]), IdeBundle.message("dialog.title.failed.to.perform.operation", new Object[0]));
        }
    }

    @Override
    public void markCurrentCommandAsGlobal(Project project2) {
        CommandProcessorImpl.getUndoManager(project2).markCurrentCommandAsGlobal();
    }

    private static UndoManagerImpl getUndoManager(Project project2) {
        return (UndoManagerImpl)(project2 != null ? UndoManager.getInstance(project2) : UndoManager.getGlobalInstance());
    }

    @Override
    public void addAffectedDocuments(Project project2, Document ... docs) {
        if (docs == null) {
            CommandProcessorImpl.$$$reportNull$$$0(1);
        }
        CommandProcessorImpl.getUndoManager(project2).addAffectedDocuments(docs);
    }

    @Override
    public void addAffectedFiles(Project project2, VirtualFile ... files2) {
        if (files2 == null) {
            CommandProcessorImpl.$$$reportNull$$$0(2);
        }
        CommandProcessorImpl.getUndoManager(project2).addAffectedFiles(files2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "docs";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/command/impl/CommandProcessorImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "finishCommand";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "addAffectedDocuments";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "addAffectedFiles";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

