/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.command.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.impl.DocumentReferenceByDocument;
import com.intellij.openapi.command.impl.DocumentReferenceByNonlocalVirtualFile;
import com.intellij.openapi.command.impl.DocumentReferenceByVirtualFile;
import com.intellij.openapi.command.impl.FilePath;
import com.intellij.openapi.command.undo.DocumentReference;
import com.intellij.openapi.command.undo.DocumentReferenceManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.AsyncFileListener;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.reference.SoftReference;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.NotNullList;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public final class DocumentReferenceManagerImpl
extends DocumentReferenceManager {
    private final Map<Document, DocumentReference> myDocToRef = ContainerUtil.createWeakKeyWeakValueMap();
    private static final Key<Reference<DocumentReference>> FILE_TO_REF_KEY = Key.create("FILE_TO_REF_KEY");
    private static final Key<DocumentReference> FILE_TO_STRONG_REF_KEY = Key.create("FILE_TO_STRONG_REF_KEY");
    private final Map<FilePath, DocumentReference> myDeletedFilePathToRef = ContainerUtil.createWeakValueMap();

    DocumentReferenceManagerImpl() {
        VirtualFileManager.getInstance().addAsyncFileListener(new AsyncFileListener(){

            @Override
            public AsyncFileListener.ChangeApplier prepareChange(final @NotNull List<? extends VFileEvent> events) {
                if (events == null) {
                    1.$$$reportNull$$$0(0);
                }
                final NotNullList deletedFiles = new NotNullList();
                for (VFileEvent vFileEvent : events) {
                    if (!(vFileEvent instanceof VFileDeleteEvent)) continue;
                    DocumentReferenceManagerImpl.collectDeletedFiles(((VFileDeleteEvent)vFileEvent).getFile(), deletedFiles);
                }
                return new AsyncFileListener.ChangeApplier(){

                    @Override
                    public void afterVfsChange() {
                        for (VirtualFile each : deletedFiles) {
                            this.fileDeleted(each);
                        }
                        for (VFileEvent event : events) {
                            if (!(event instanceof VFileCreateEvent)) continue;
                            this.fileCreated((VFileCreateEvent)event);
                        }
                    }
                };
            }

            private void fileDeleted(VirtualFile each) {
                DocumentReference ref = (DocumentReference)SoftReference.dereference((Reference)each.getUserData(FILE_TO_REF_KEY));
                each.putUserData(FILE_TO_REF_KEY, null);
                if (ref != null) {
                    DocumentReferenceManagerImpl.this.myDeletedFilePathToRef.put(new FilePath(each.getUrl()), ref);
                }
            }

            private void fileCreated(@NotNull VFileCreateEvent event) {
                VirtualFile f;
                DocumentReference ref;
                if (event == null) {
                    1.$$$reportNull$$$0(1);
                }
                DocumentReference documentReference = ref = (f = event.getFile()) == null ? null : (DocumentReference)DocumentReferenceManagerImpl.this.myDeletedFilePathToRef.remove(new FilePath(f.getUrl()));
                if (ref != null) {
                    f.putUserData(FILE_TO_REF_KEY, new WeakReference<DocumentReference>(ref));
                    ((DocumentReferenceByVirtualFile)ref).update(f);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "events";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "event";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/openapi/command/impl/DocumentReferenceManagerImpl$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "prepareChange";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "fileCreated";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, ApplicationManager.getApplication());
    }

    private static void collectDeletedFiles(@NotNull VirtualFile f, @NotNull List<VirtualFile> files2) {
        if (f == null) {
            DocumentReferenceManagerImpl.$$$reportNull$$$0(0);
        }
        if (files2 == null) {
            DocumentReferenceManagerImpl.$$$reportNull$$$0(1);
        }
        if (!(f instanceof NewVirtualFile)) {
            return;
        }
        ProgressManager.checkCanceled();
        if (!f.isDirectory()) {
            files2.add(f);
        } else {
            for (VirtualFile each : ((NewVirtualFile)f).iterInDbChildren()) {
                DocumentReferenceManagerImpl.collectDeletedFiles(each, files2);
            }
        }
    }

    @Override
    @NotNull
    public DocumentReference create(@NotNull Document document) {
        if (document == null) {
            DocumentReferenceManagerImpl.$$$reportNull$$$0(2);
        }
        DocumentReferenceManagerImpl.assertIsWriteThread();
        VirtualFile file2 = FileDocumentManager.getInstance().getFile(document);
        DocumentReference documentReference = file2 == null ? this.createFromDocument(document) : this.create(file2);
        if (documentReference == null) {
            DocumentReferenceManagerImpl.$$$reportNull$$$0(3);
        }
        return documentReference;
    }

    @NotNull
    private DocumentReference createFromDocument(@NotNull Document document) {
        DocumentReference result2;
        if (document == null) {
            DocumentReferenceManagerImpl.$$$reportNull$$$0(4);
        }
        if ((result2 = this.myDocToRef.get(document)) == null) {
            result2 = new DocumentReferenceByDocument(document);
            this.myDocToRef.put(document, result2);
        }
        DocumentReference documentReference = result2;
        if (documentReference == null) {
            DocumentReferenceManagerImpl.$$$reportNull$$$0(5);
        }
        return documentReference;
    }

    @Override
    @NotNull
    public DocumentReference create(@NotNull VirtualFile file2) {
        if (file2 == null) {
            DocumentReferenceManagerImpl.$$$reportNull$$$0(6);
        }
        DocumentReferenceManagerImpl.assertIsWriteThread();
        if (!file2.isInLocalFileSystem()) {
            DocumentReference reference2 = file2.getUserData(FILE_TO_STRONG_REF_KEY);
            if (reference2 == null) {
                reference2 = new DocumentReferenceByNonlocalVirtualFile(file2);
                file2.putUserData(FILE_TO_STRONG_REF_KEY, reference2);
            }
            DocumentReference documentReference = reference2;
            if (documentReference == null) {
                DocumentReferenceManagerImpl.$$$reportNull$$$0(7);
            }
            return documentReference;
        }
        assert (file2.isValid()) : "file is invalid: " + file2;
        DocumentReference result2 = SoftReference.dereference(file2.getUserData(FILE_TO_REF_KEY));
        if (result2 == null) {
            result2 = new DocumentReferenceByVirtualFile(file2);
            file2.putUserData(FILE_TO_REF_KEY, new WeakReference<DocumentReference>(result2));
        }
        DocumentReference documentReference = result2;
        if (documentReference == null) {
            DocumentReferenceManagerImpl.$$$reportNull$$$0(8);
        }
        return documentReference;
    }

    private static void assertIsWriteThread() {
        ApplicationManager.getApplication().assertIsWriteThread();
    }

    public void cleanupForNextTest() {
        this.myDeletedFilePathToRef.clear();
        this.myDocToRef.clear();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "f";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/command/impl/DocumentReferenceManagerImpl";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/command/impl/DocumentReferenceManagerImpl";
                break;
            }
            case 3: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createFromDocument";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "collectDeletedFiles";
                break;
            }
            case 2: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createFromDocument";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

