/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.command.impl;

import com.intellij.ide.IdeBundle;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.command.impl.EditorAndState;
import com.intellij.openapi.command.impl.UndoManagerImpl;
import com.intellij.openapi.command.impl.UndoRedo;
import com.intellij.openapi.command.impl.UndoRedoStacksHolder;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.util.text.StringUtil;

class Redo
extends UndoRedo {
    Redo(UndoManagerImpl manager, FileEditor editor) {
        super(manager, editor);
    }

    @Override
    protected UndoRedoStacksHolder getStackHolder() {
        return this.myManager.getRedoStacksHolder();
    }

    @Override
    protected UndoRedoStacksHolder getReverseStackHolder() {
        return this.myManager.getUndoStacksHolder();
    }

    @Override
    protected String getActionName() {
        return IdeBundle.message("redo.dialog.title", new Object[0]);
    }

    @Override
    protected String getActionName(String commandName) {
        if (StringUtil.isEmpty(commandName)) {
            commandName = ActionsBundle.message("action.redo.description.empty", new Object[0]);
        }
        return IdeBundle.message("redo.command", commandName);
    }

    @Override
    protected void performAction() {
        this.myUndoableGroup.redo();
    }

    @Override
    protected EditorAndState getBeforeState() {
        return this.myUndoableGroup.getStateBefore();
    }

    @Override
    protected EditorAndState getAfterState() {
        return this.myUndoableGroup.getStateAfter();
    }

    @Override
    protected void setBeforeState(EditorAndState state) {
        this.myUndoableGroup.setStateBefore(state);
    }

    @Override
    protected boolean isRedo() {
        return true;
    }
}

