/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.command.impl;

import com.intellij.ide.IdeBundle;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.command.impl.EditorAndState;
import com.intellij.openapi.command.impl.UndoManagerImpl;
import com.intellij.openapi.command.impl.UndoRedo;
import com.intellij.openapi.command.impl.UndoRedoStacksHolder;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.util.text.StringUtil;

class Undo
extends UndoRedo {
    Undo(UndoManagerImpl manager, FileEditor editor) {
        super(manager, editor);
    }

    @Override
    protected UndoRedoStacksHolder getStackHolder() {
        return this.myManager.getUndoStacksHolder();
    }

    @Override
    protected UndoRedoStacksHolder getReverseStackHolder() {
        return this.myManager.getRedoStacksHolder();
    }

    @Override
    protected String getActionName() {
        return IdeBundle.message("undo.dialog.title", new Object[0]);
    }

    @Override
    protected String getActionName(String commandName) {
        if (StringUtil.isEmpty(commandName)) {
            commandName = ActionsBundle.message("action.undo.description.empty", new Object[0]);
        }
        return IdeBundle.message("undo.command", commandName);
    }

    @Override
    protected void performAction() {
        this.myUndoableGroup.undo();
    }

    @Override
    protected EditorAndState getBeforeState() {
        return this.myUndoableGroup.getStateAfter();
    }

    @Override
    protected EditorAndState getAfterState() {
        return this.myUndoableGroup.getStateBefore();
    }

    @Override
    protected void setBeforeState(EditorAndState state) {
        this.myUndoableGroup.setStateAfter(state);
    }

    @Override
    protected boolean isRedo() {
        return false;
    }
}

