/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.command.impl;

import com.intellij.openapi.command.impl.UndoManagerImpl;
import com.intellij.openapi.command.impl.UndoableGroup;
import com.intellij.openapi.command.undo.DocumentReference;
import com.intellij.openapi.command.undo.DocumentReferenceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.WeakList;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

class UndoRedoStacksHolder {
    private static final Logger LOG = Logger.getInstance(UndoRedoStacksHolder.class);
    private final Key<LinkedList<UndoableGroup>> STACK_IN_DOCUMENT_KEY = Key.create("STACK_IN_DOCUMENT_KEY");
    private final boolean myUndo;
    private final LinkedList<UndoableGroup> myGlobalStack = new LinkedList();
    private final THashMap<DocumentReference, LinkedList<UndoableGroup>> myDocumentStacks = new THashMap();
    private final Collection<Document> myDocumentsWithStacks = new WeakList<Document>();
    private final Collection<VirtualFile> myNonlocalVirtualFilesWithStacks = new WeakList<VirtualFile>();

    UndoRedoStacksHolder(boolean isUndo) {
        this.myUndo = isUndo;
    }

    @NotNull
    LinkedList<UndoableGroup> getStack(@NotNull DocumentReference r) {
        if (r == null) {
            UndoRedoStacksHolder.$$$reportNull$$$0(0);
        }
        return r.getFile() != null ? this.doGetStackForFile(r) : this.doGetStackForDocument(r);
    }

    @NotNull
    private LinkedList<UndoableGroup> doGetStackForFile(@NotNull DocumentReference r) {
        LinkedList<UndoableGroup> result2;
        VirtualFile file2;
        if (r == null) {
            UndoRedoStacksHolder.$$$reportNull$$$0(1);
        }
        if (!(file2 = r.getFile()).isInLocalFileSystem()) {
            result2 = this.addWeaklyTrackedEmptyStack(file2, this.myNonlocalVirtualFilesWithStacks);
        } else {
            result2 = this.myDocumentStacks.get(r);
            if (result2 == null) {
                result2 = new LinkedList();
                this.myDocumentStacks.put(r, result2);
            }
        }
        LinkedList<UndoableGroup> linkedList = result2;
        if (linkedList == null) {
            UndoRedoStacksHolder.$$$reportNull$$$0(2);
        }
        return linkedList;
    }

    @NotNull
    private LinkedList<UndoableGroup> doGetStackForDocument(@NotNull DocumentReference r) {
        if (r == null) {
            UndoRedoStacksHolder.$$$reportNull$$$0(3);
        }
        return this.addWeaklyTrackedEmptyStack(r.getDocument(), this.myDocumentsWithStacks);
    }

    @NotNull
    private <T extends UserDataHolder> LinkedList<UndoableGroup> addWeaklyTrackedEmptyStack(@NotNull T holder, @NotNull Collection<T> allHolders) {
        LinkedList<UndoableGroup> result2;
        if (holder == null) {
            UndoRedoStacksHolder.$$$reportNull$$$0(4);
        }
        if (allHolders == null) {
            UndoRedoStacksHolder.$$$reportNull$$$0(5);
        }
        if ((result2 = holder.getUserData(this.STACK_IN_DOCUMENT_KEY)) == null) {
            result2 = new LinkedList();
            holder.putUserData(this.STACK_IN_DOCUMENT_KEY, result2);
            allHolders.add(holder);
        }
        LinkedList<UndoableGroup> linkedList = result2;
        if (linkedList == null) {
            UndoRedoStacksHolder.$$$reportNull$$$0(6);
        }
        return linkedList;
    }

    boolean canBeUndoneOrRedone(@NotNull Collection<? extends DocumentReference> refs) {
        if (refs == null) {
            UndoRedoStacksHolder.$$$reportNull$$$0(7);
        }
        if (refs.isEmpty()) {
            return !this.myGlobalStack.isEmpty() && this.myGlobalStack.getLast().isValid();
        }
        for (DocumentReference documentReference : refs) {
            if (this.getStack(documentReference).isEmpty() || !this.getStack(documentReference).getLast().isValid()) continue;
            return true;
        }
        return false;
    }

    @NotNull
    UndoableGroup getLastAction(@NotNull Collection<? extends DocumentReference> refs) {
        if (refs == null) {
            UndoRedoStacksHolder.$$$reportNull$$$0(8);
        }
        if (refs.isEmpty()) {
            UndoableGroup undoableGroup = this.myGlobalStack.getLast();
            if (undoableGroup == null) {
                UndoRedoStacksHolder.$$$reportNull$$$0(9);
            }
            return undoableGroup;
        }
        UndoableGroup mostRecentAction = null;
        int mostRecentDocTimestamp = 0;
        for (DocumentReference documentReference : refs) {
            LinkedList<UndoableGroup> stack = this.getStack(documentReference);
            if (stack.isEmpty()) continue;
            UndoableGroup lastAction = stack.getLast();
            int timestamp = lastAction.getCommandTimestamp();
            if (mostRecentAction != null && (!lastAction.isTemporary() || mostRecentAction.isTemporary()) && (lastAction.isTemporary() != mostRecentAction.isTemporary() || !(this.myUndo ? timestamp > mostRecentDocTimestamp : timestamp < mostRecentDocTimestamp))) continue;
            mostRecentAction = lastAction;
            mostRecentDocTimestamp = timestamp;
        }
        UndoableGroup undoableGroup = mostRecentAction;
        if (undoableGroup == null) {
            UndoRedoStacksHolder.$$$reportNull$$$0(10);
        }
        return undoableGroup;
    }

    @NotNull
    Set<DocumentReference> collectClashingActions(@NotNull UndoableGroup group) {
        UndoableGroup last;
        if (group == null) {
            UndoRedoStacksHolder.$$$reportNull$$$0(11);
        }
        THashSet<DocumentReference> result2 = new THashSet<DocumentReference>();
        for (DocumentReference each : group.getAffectedDocuments()) {
            UndoableGroup last2 = this.getStack(each).peekLast();
            if (last2 == null || last2 == group) continue;
            result2.addAll(last2.getAffectedDocuments());
        }
        if (group.isGlobal() && (last = this.myGlobalStack.peekLast()) != null && last != group) {
            result2.addAll(last.getAffectedDocuments());
        }
        THashSet<DocumentReference> tHashSet = result2;
        if (tHashSet == null) {
            UndoRedoStacksHolder.$$$reportNull$$$0(12);
        }
        return tHashSet;
    }

    private String getStacksDescription() {
        return this.myUndo ? "undo stacks" : "redo stacks";
    }

    void addToStacks(@NotNull UndoableGroup group) {
        if (group == null) {
            UndoRedoStacksHolder.$$$reportNull$$$0(13);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Adding to " + this.getStacksDescription() + ": " + group.dumpState());
        }
        for (LinkedList<UndoableGroup> each : this.getAffectedStacks(group)) {
            if (this.myUndo && !group.isTemporary()) {
                UndoRedoStacksHolder.convertTemporaryActionsToPermanent(each);
            }
            this.doAddToStack(each, group, each == this.myGlobalStack ? UndoManagerImpl.getGlobalUndoLimit() : UndoManagerImpl.getDocumentUndoLimit());
        }
    }

    private void doAddToStack(@NotNull LinkedList<UndoableGroup> stack, @NotNull UndoableGroup group, int limit) {
        if (stack == null) {
            UndoRedoStacksHolder.$$$reportNull$$$0(14);
        }
        if (group == null) {
            UndoRedoStacksHolder.$$$reportNull$$$0(15);
        }
        if (!group.isUndoable() && stack.isEmpty()) {
            return;
        }
        stack.add(group);
        while (stack.size() > limit) {
            this.clearStacksFrom(stack.getFirst());
        }
    }

    void removeFromStacks(@NotNull UndoableGroup group) {
        if (group == null) {
            UndoRedoStacksHolder.$$$reportNull$$$0(16);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Removing from " + this.getStacksDescription() + ": " + group.dumpState());
        }
        for (LinkedList<UndoableGroup> each : this.getAffectedStacks(group)) {
            assert (each.getLast() == group);
            each.removeLast();
        }
    }

    void clearStacks(boolean clearGlobal, @NotNull Set<? extends DocumentReference> refs) {
        if (refs == null) {
            UndoRedoStacksHolder.$$$reportNull$$$0(17);
        }
        for (LinkedList<UndoableGroup> each2 : this.getAffectedStacks(clearGlobal, refs)) {
            while (!each2.isEmpty()) {
                this.clearStacksFrom(each2.getLast());
            }
        }
        this.myDocumentStacks.entrySet().removeIf(each -> ((LinkedList)each.getValue()).isEmpty());
        this.myDocumentStacks.compact();
        this.cleanWeaklyTrackedEmptyStacks(this.myDocumentsWithStacks);
        this.cleanWeaklyTrackedEmptyStacks(this.myNonlocalVirtualFilesWithStacks);
    }

    private static void convertTemporaryActionsToPermanent(LinkedList<? extends UndoableGroup> each) {
        UndoableGroup group1;
        for (int i = each.size() - 1; i >= 0 && (group1 = each.get(i)).isTemporary(); --i) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Converting to permanent: " + group1);
            }
            group1.makePermanent();
        }
    }

    private <T extends UserDataHolder> void cleanWeaklyTrackedEmptyStacks(@NotNull Collection<T> stackHolders) {
        if (stackHolders == null) {
            UndoRedoStacksHolder.$$$reportNull$$$0(18);
        }
        THashSet<UserDataHolder> holdersToDrop = new THashSet<UserDataHolder>();
        for (UserDataHolder holder : stackHolders) {
            List stack = holder.getUserData(this.STACK_IN_DOCUMENT_KEY);
            if (stack == null || !stack.isEmpty()) continue;
            holder.putUserData(this.STACK_IN_DOCUMENT_KEY, null);
            holdersToDrop.add(holder);
        }
        stackHolders.removeAll(holdersToDrop);
    }

    private void clearStacksFrom(@NotNull UndoableGroup from) {
        if (from == null) {
            UndoRedoStacksHolder.$$$reportNull$$$0(19);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Clearing " + this.getStacksDescription() + " from " + from.dumpState());
        }
        for (LinkedList<UndoableGroup> each : this.getAffectedStacks(from)) {
            int pos = each.indexOf(from);
            if (pos == -1) continue;
            if (pos > 0) {
                int top = each.size() - pos;
                this.clearStacksFrom(each.get(pos - 1));
                assert (each.size() == top && each.indexOf(from) == 0);
            }
            each.removeFirst();
        }
    }

    @NotNull
    private List<LinkedList<UndoableGroup>> getAffectedStacks(@NotNull UndoableGroup group) {
        if (group == null) {
            UndoRedoStacksHolder.$$$reportNull$$$0(20);
        }
        return this.getAffectedStacks(group.isGlobal(), group.getAffectedDocuments());
    }

    @NotNull
    private List<LinkedList<UndoableGroup>> getAffectedStacks(boolean global, @NotNull Collection<? extends DocumentReference> refs) {
        if (refs == null) {
            UndoRedoStacksHolder.$$$reportNull$$$0(21);
        }
        ArrayList<LinkedList<UndoableGroup>> result2 = new ArrayList<LinkedList<UndoableGroup>>(refs.size() + 1);
        if (global) {
            result2.add(this.myGlobalStack);
        }
        for (DocumentReference documentReference : refs) {
            result2.add(this.getStack(documentReference));
        }
        ArrayList<LinkedList<UndoableGroup>> arrayList = result2;
        if (arrayList == null) {
            UndoRedoStacksHolder.$$$reportNull$$$0(22);
        }
        return arrayList;
    }

    void clearAllStacksInTests() {
        this.clearStacks(true, this.getAffectedDocuments());
        this.myGlobalStack.clear();
        this.myDocumentStacks.clear();
        this.myDocumentsWithStacks.clear();
        this.myNonlocalVirtualFilesWithStacks.clear();
    }

    void collectAllAffectedDocuments(@NotNull Collection<? super DocumentReference> result2) {
        if (result2 == null) {
            UndoRedoStacksHolder.$$$reportNull$$$0(23);
        }
        for (UndoableGroup each : this.myGlobalStack) {
            result2.addAll(each.getAffectedDocuments());
        }
        this.collectLocalAffectedDocuments(result2);
    }

    private void collectLocalAffectedDocuments(@NotNull Collection<? super DocumentReference> result2) {
        if (result2 == null) {
            UndoRedoStacksHolder.$$$reportNull$$$0(24);
        }
        result2.addAll(this.myDocumentStacks.keySet());
        DocumentReferenceManager documentReferenceManager = DocumentReferenceManager.getInstance();
        for (Document document : this.myDocumentsWithStacks) {
            result2.add(documentReferenceManager.create(document));
        }
        for (VirtualFile virtualFile2 : this.myNonlocalVirtualFilesWithStacks) {
            result2.add(documentReferenceManager.create(virtualFile2));
        }
    }

    @NotNull
    private Set<DocumentReference> getAffectedDocuments() {
        THashSet<DocumentReference> result2 = new THashSet<DocumentReference>();
        this.collectAllAffectedDocuments(result2);
        THashSet<DocumentReference> tHashSet = result2;
        if (tHashSet == null) {
            UndoRedoStacksHolder.$$$reportNull$$$0(25);
        }
        return tHashSet;
    }

    int getLastCommandTimestamp(@NotNull DocumentReference r) {
        LinkedList<UndoableGroup> stack;
        if (r == null) {
            UndoRedoStacksHolder.$$$reportNull$$$0(26);
        }
        if ((stack = this.getStack(r)).isEmpty()) {
            return 0;
        }
        return Math.max(stack.getFirst().getCommandTimestamp(), stack.getLast().getCommandTimestamp());
    }

    void invalidateActionsFor(@NotNull DocumentReference ref) {
        if (ref == null) {
            UndoRedoStacksHolder.$$$reportNull$$$0(27);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Invalidating actions in " + this.getStacksDescription() + " for " + ref);
        }
        for (List list2 : this.getAffectedStacks(true, Collections.singleton(ref))) {
            for (UndoableGroup eachGroup : list2) {
                eachGroup.invalidateActionsFor(ref);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 6: 
            case 9: 
            case 10: 
            case 12: 
            case 22: 
            case 25: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 6: 
            case 9: 
            case 10: 
            case 12: 
            case 22: 
            case 25: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "r";
                break;
            }
            case 2: 
            case 6: 
            case 9: 
            case 10: 
            case 12: 
            case 22: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/command/impl/UndoRedoStacksHolder";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allHolders";
                break;
            }
            case 7: 
            case 8: 
            case 17: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refs";
                break;
            }
            case 11: 
            case 13: 
            case 15: 
            case 16: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stack";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stackHolders";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/command/impl/UndoRedoStacksHolder";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "doGetStackForFile";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "addWeaklyTrackedEmptyStack";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getLastAction";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "collectClashingActions";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getAffectedStacks";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getAffectedDocuments";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getStack";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "doGetStackForFile";
                break;
            }
            case 2: 
            case 6: 
            case 9: 
            case 10: 
            case 12: 
            case 22: 
            case 25: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "doGetStackForDocument";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addWeaklyTrackedEmptyStack";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "canBeUndoneOrRedone";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getLastAction";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "collectClashingActions";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addToStacks";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "doAddToStack";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "removeFromStacks";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "clearStacks";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "cleanWeaklyTrackedEmptyStacks";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "clearStacksFrom";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getAffectedStacks";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "collectAllAffectedDocuments";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "collectLocalAffectedDocuments";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getLastCommandTimestamp";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "invalidateActionsFor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 6: 
            case 9: 
            case 10: 
            case 12: 
            case 22: 
            case 25: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

