/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.compiler;

import com.intellij.compiler.CompilerConfiguration;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEnumerationHandler;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.SmartList;
import com.intellij.util.containers.OrderedSet;
import java.io.File;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.compiler.AnnotationProcessingConfiguration;

public class CompilerPaths {
    private static final Logger LOG = Logger.getInstance(CompilerPaths.class);

    public static File getGeneratedDataDirectory(Project project2) {
        return new File(CompilerPaths.getCompilerSystemDirectory(project2), ".generated");
    }

    public static File getCacheStoreDirectory(Project project2) {
        return new File(CompilerPaths.getCompilerSystemDirectory(project2), ".caches");
    }

    @NotNull
    public static File getCompilerSystemDirectory(@NotNull Project project2) {
        if (project2 == null) {
            CompilerPaths.$$$reportNull$$$0(0);
        }
        File file2 = ProjectUtil.getProjectCachePath(project2, "compiler").toFile();
        if (file2 == null) {
            CompilerPaths.$$$reportNull$$$0(1);
        }
        return file2;
    }

    @Nullable
    public static VirtualFile getModuleOutputDirectory(@NotNull Module module2, boolean forTestClasses) {
        VirtualFile path2;
        CompilerModuleExtension compilerModuleExtension2;
        if (module2 == null) {
            CompilerPaths.$$$reportNull$$$0(2);
        }
        if ((compilerModuleExtension2 = CompilerModuleExtension.getInstance(module2)) == null) {
            return null;
        }
        VirtualFile outPath = forTestClasses ? ((path2 = compilerModuleExtension2.getCompilerOutputPathForTests()) != null ? path2 : compilerModuleExtension2.getCompilerOutputPath()) : compilerModuleExtension2.getCompilerOutputPath();
        if (outPath == null) {
            return null;
        }
        if (!outPath.isValid()) {
            LOG.info("Requested output path for module " + module2.getName() + " is not valid");
            return null;
        }
        return outPath;
    }

    @Nullable
    public static String getModuleOutputPath(Module module2, boolean forTestClasses) {
        String url;
        CompilerModuleExtension extension = CompilerModuleExtension.getInstance(module2);
        if (extension == null) {
            return null;
        }
        Application application = ApplicationManager.getApplication();
        String outPathUrl = forTestClasses ? (application.isDispatchThread() ? ((url = extension.getCompilerOutputUrlForTests()) != null ? url : extension.getCompilerOutputUrl()) : ReadAction.compute(() -> {
            String url = extension.getCompilerOutputUrlForTests();
            return url != null ? url : extension.getCompilerOutputUrl();
        })) : (application.isDispatchThread() ? extension.getCompilerOutputUrl() : ReadAction.compute(() -> extension.getCompilerOutputUrl()));
        return outPathUrl != null ? VirtualFileManager.extractPath(outPathUrl) : null;
    }

    @Nullable
    public static String getAnnotationProcessorsGenerationPath(Module module2, boolean forTests) {
        AnnotationProcessingConfiguration config2 = CompilerConfiguration.getInstance(module2.getProject()).getAnnotationProcessingConfiguration(module2);
        String sourceDirName = config2.getGeneratedSourcesDirectoryName(forTests);
        if (config2.isOutputRelativeToContentRoot()) {
            Object[] roots = ModuleRootManager.getInstance(module2).getContentRootUrls();
            if (roots.length == 0) {
                return null;
            }
            if (roots.length > 1) {
                Arrays.sort(roots);
            }
            return StringUtil.isEmpty(sourceDirName) ? VirtualFileManager.extractPath((String)roots[0]) : VirtualFileManager.extractPath((String)roots[0]) + "/" + sourceDirName;
        }
        String path2 = CompilerPaths.getModuleOutputPath(module2, forTests);
        if (path2 == null) {
            return null;
        }
        return StringUtil.isEmpty(sourceDirName) ? path2 : path2 + "/" + sourceDirName;
    }

    public static String @NotNull [] getOutputPaths(Module @NotNull [] modules) {
        if (modules == null) {
            CompilerPaths.$$$reportNull$$$0(3);
        }
        OrderedSet<String> outputPaths = new OrderedSet<String>();
        for (Module module2 : modules) {
            String outputPathForTestsUrl;
            CompilerModuleExtension compilerModuleExtension2;
            CompilerModuleExtension compilerModuleExtension3 = compilerModuleExtension2 = !module2.isDisposed() ? CompilerModuleExtension.getInstance(module2) : null;
            if (compilerModuleExtension2 == null) continue;
            String outputPathUrl = compilerModuleExtension2.getCompilerOutputUrl();
            if (outputPathUrl != null) {
                outputPaths.add(VirtualFileManager.extractPath(outputPathUrl).replace('/', File.separatorChar));
            }
            if ((outputPathForTestsUrl = compilerModuleExtension2.getCompilerOutputUrlForTests()) != null) {
                outputPaths.add(VirtualFileManager.extractPath(outputPathForTestsUrl).replace('/', File.separatorChar));
            }
            ModuleRootManager moduleRootManager = ModuleRootManager.getInstance(module2);
            for (OrderEnumerationHandler.Factory handlerFactory : OrderEnumerationHandler.EP_NAME.getExtensions()) {
                if (!handlerFactory.isApplicable(module2)) continue;
                OrderEnumerationHandler handler2 = handlerFactory.createHandler(module2);
                SmartList<String> outputUrls = new SmartList<String>();
                handler2.addCustomModuleRoots(OrderRootType.CLASSES, moduleRootManager, outputUrls, true, true);
                for (String outputUrl : outputUrls) {
                    outputPaths.add(VirtualFileManager.extractPath(outputUrl).replace('/', File.separatorChar));
                }
            }
        }
        String[] stringArray = ArrayUtilRt.toStringArray(outputPaths);
        if (stringArray == null) {
            CompilerPaths.$$$reportNull$$$0(4);
        }
        return stringArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/compiler/CompilerPaths";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modules";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/compiler/CompilerPaths";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompilerSystemDirectory";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getOutputPaths";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getCompilerSystemDirectory";
                break;
            }
            case 1: 
            case 4: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getModuleOutputDirectory";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getOutputPaths";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

