/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.compiler.options;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import org.jetbrains.annotations.Nullable;

public class ExcludeEntryDescription
implements Disposable {
    private boolean myIsFile;
    private boolean myIncludeSubdirectories;
    private VirtualFilePointer myFilePointer;
    private final Disposable myParentDisposable;

    public ExcludeEntryDescription(String url, boolean includeSubdirectories, boolean isFile, Disposable parent) {
        this.myParentDisposable = parent;
        this.myFilePointer = VirtualFilePointerManager.getInstance().create(url, parent, null);
        this.myIncludeSubdirectories = includeSubdirectories;
        this.myIsFile = isFile;
    }

    public ExcludeEntryDescription(VirtualFile virtualFile2, boolean includeSubdirectories, boolean isFile, Disposable parent) {
        this(virtualFile2.getUrl(), includeSubdirectories, isFile, parent);
    }

    public ExcludeEntryDescription copy(Disposable parent) {
        return new ExcludeEntryDescription(this.getUrl(), this.myIncludeSubdirectories, this.myIsFile, parent);
    }

    void setPresentableUrl(String newUrl) {
        this.myFilePointer = VirtualFilePointerManager.getInstance().create(VfsUtilCore.pathToUrl(FileUtil.toSystemIndependentName(newUrl)), this.myParentDisposable, null);
        VirtualFile file2 = this.getVirtualFile();
        if (file2 != null) {
            this.myIsFile = !file2.isDirectory();
        }
    }

    public boolean isFile() {
        return this.myIsFile;
    }

    public String getUrl() {
        return this.myFilePointer.getUrl();
    }

    public String getPresentableUrl() {
        return this.myFilePointer.getPresentableUrl();
    }

    public boolean isIncludeSubdirectories() {
        return this.myIncludeSubdirectories;
    }

    void setIncludeSubdirectories(boolean includeSubdirectories) {
        this.myIncludeSubdirectories = includeSubdirectories;
    }

    @Nullable
    public VirtualFile getVirtualFile() {
        return this.myFilePointer.getFile();
    }

    public boolean isValid() {
        return this.myFilePointer.isValid();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ExcludeEntryDescription)) {
            return false;
        }
        ExcludeEntryDescription entryDescription = (ExcludeEntryDescription)obj;
        if (entryDescription.myIsFile != this.myIsFile) {
            return false;
        }
        if (entryDescription.myIncludeSubdirectories != this.myIncludeSubdirectories) {
            return false;
        }
        return Comparing.equal(entryDescription.getUrl(), this.getUrl());
    }

    public int hashCode() {
        int result2 = this.myIsFile ? 1 : 0;
        result2 = 31 * result2 + (this.myIncludeSubdirectories ? 1 : 0);
        result2 = 31 * result2 + this.getUrl().hashCode();
        return result2;
    }

    @Override
    public void dispose() {
    }
}

