/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.compiler.options;

import com.intellij.compiler.CompilerConfiguration;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.compiler.JavaCompilerBundle;
import com.intellij.openapi.compiler.options.ExcludeEntryDescription;
import com.intellij.openapi.compiler.options.ExcludesConfiguration;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.JBColor;
import com.intellij.ui.PanelWithButtons;
import com.intellij.ui.RightAlignedLabelUI;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.table.JBTable;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.LabelUI;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.jetbrains.annotations.NotNull;

public final class ExcludedEntriesConfigurable
implements UnnamedConfigurable,
Configurable.NoScroll {
    private final Project myProject;
    private final ArrayList<ExcludeEntryDescription> myExcludeEntryDescriptions;
    private final FileChooserDescriptor myDescriptor;
    private final ExcludesConfiguration myConfiguration;
    private ExcludedEntriesPanel myExcludedEntriesPanel;

    public ExcludedEntriesConfigurable(@NotNull Project project2) {
        if (project2 == null) {
            ExcludedEntriesConfigurable.$$$reportNull$$$0(0);
        }
        this(project2, new FileChooserDescriptor(true, true, false, false, false, true), CompilerConfiguration.getInstance(project2).getExcludedEntriesConfiguration());
    }

    public ExcludedEntriesConfigurable(@NotNull Project project2, FileChooserDescriptor descriptor2, ExcludesConfiguration configuration) {
        if (project2 == null) {
            ExcludedEntriesConfigurable.$$$reportNull$$$0(1);
        }
        this.myExcludeEntryDescriptions = new ArrayList();
        this.myDescriptor = descriptor2;
        this.myConfiguration = configuration;
        this.myProject = project2;
    }

    @Override
    public void reset() {
        ExcludeEntryDescription[] descriptions = this.myConfiguration.getExcludeEntryDescriptions();
        this.disposeMyDescriptions();
        for (ExcludeEntryDescription description : descriptions) {
            this.myExcludeEntryDescriptions.add(description.copy(this.myProject));
        }
        ((AbstractTableModel)this.myExcludedEntriesPanel.myExcludedTable.getModel()).fireTableDataChanged();
    }

    public void addEntry(ExcludeEntryDescription description) {
        this.myExcludeEntryDescriptions.add(description);
        ((AbstractTableModel)this.myExcludedEntriesPanel.myExcludedTable.getModel()).fireTableDataChanged();
    }

    private void disposeMyDescriptions() {
        for (ExcludeEntryDescription description : this.myExcludeEntryDescriptions) {
            Disposer.dispose(description);
        }
        this.myExcludeEntryDescriptions.clear();
    }

    @Override
    public void apply() {
        this.myConfiguration.removeAllExcludeEntryDescriptions();
        for (ExcludeEntryDescription description : this.myExcludeEntryDescriptions) {
            this.myConfiguration.addExcludeEntryDescription(description.copy(this.myProject));
        }
        FileStatusManager.getInstance(this.myProject).fileStatusesChanged();
    }

    @Override
    public boolean isModified() {
        ExcludeEntryDescription[] excludeEntryDescriptions = this.myConfiguration.getExcludeEntryDescriptions();
        if (excludeEntryDescriptions.length != this.myExcludeEntryDescriptions.size()) {
            return true;
        }
        for (int i = 0; i < excludeEntryDescriptions.length; ++i) {
            ExcludeEntryDescription description = excludeEntryDescriptions[i];
            if (Comparing.equal(description, this.myExcludeEntryDescriptions.get(i))) continue;
            return true;
        }
        return false;
    }

    @Override
    public JComponent createComponent() {
        if (this.myExcludedEntriesPanel == null) {
            this.myExcludedEntriesPanel = new ExcludedEntriesPanel();
        }
        return this.myExcludedEntriesPanel;
    }

    @Override
    public void disposeUIResources() {
        this.myExcludedEntriesPanel = null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/compiler/options/ExcludedEntriesConfigurable", "<init>"));
    }

    private class MyObjectRenderer
    extends DefaultTableCellRenderer {
        MyObjectRenderer() {
            this.setUI((LabelUI)new RightAlignedLabelUI());
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value2, boolean isSelected, boolean hasFocus, int row, int column) {
            Component component2 = super.getTableCellRendererComponent(table, value2, isSelected, hasFocus, row, column);
            ExcludeEntryDescription description = (ExcludeEntryDescription)ExcludedEntriesConfigurable.this.myExcludeEntryDescriptions.get(row);
            component2.setForeground(!description.isValid() ? JBColor.RED : (isSelected ? table.getSelectionForeground() : table.getForeground()));
            component2.setBackground(isSelected ? table.getSelectionBackground() : table.getBackground());
            return component2;
        }
    }

    private static class BooleanRenderer
    extends JCheckBox
    implements TableCellRenderer {
        private final JPanel myPanel = new JPanel();

        BooleanRenderer() {
            this.setHorizontalAlignment(0);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value2, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value2 == null) {
                if (isSelected) {
                    this.myPanel.setBackground(table.getSelectionBackground());
                } else {
                    this.myPanel.setBackground(table.getBackground());
                }
                return this.myPanel;
            }
            if (isSelected) {
                this.setForeground(table.getSelectionForeground());
                super.setBackground(table.getSelectionBackground());
            } else {
                this.setForeground(table.getForeground());
                this.setBackground(table.getBackground());
            }
            this.setSelected((Boolean)value2);
            return this;
        }
    }

    private class ExcludedEntriesPanel
    extends PanelWithButtons {
        private JButton myRemoveButton;
        private JBTable myExcludedTable;

        ExcludedEntriesPanel() {
            this.initPanel();
        }

        @Override
        protected String getLabelText() {
            return null;
        }

        @Override
        protected JButton[] createButtons() {
            JButton addButton = new JButton(JavaCompilerBundle.message("button.add", new Object[0]));
            addButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ExcludedEntriesPanel.this.addPath(ExcludedEntriesConfigurable.this.myDescriptor);
                }
            });
            this.myRemoveButton = new JButton(IdeBundle.message("button.remove", new Object[0]));
            this.myRemoveButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ExcludedEntriesPanel.this.removePaths();
                }
            });
            this.myRemoveButton.setEnabled(false);
            this.myRemoveButton.getModel().addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    if (ExcludedEntriesPanel.this.myExcludedTable.getSelectedRow() == -1) {
                        ExcludedEntriesPanel.this.myRemoveButton.setEnabled(false);
                    }
                }
            });
            return new JButton[0];
        }

        private void addPath(FileChooserDescriptor descriptor2) {
            VirtualFile[] chosen;
            int selected2 = -1;
            if (selected2 < 0) {
                selected2 = ExcludedEntriesConfigurable.this.myExcludeEntryDescriptions.size();
            }
            int savedSelected = selected2;
            for (VirtualFile chosenFile : chosen = FileChooser.chooseFiles(descriptor2, ExcludedEntriesConfigurable.this.myProject, null)) {
                if (this.isFileExcluded(chosenFile)) continue;
                ExcludeEntryDescription description = chosenFile.isDirectory() ? new ExcludeEntryDescription(chosenFile, true, false, (Disposable)ExcludedEntriesConfigurable.this.myProject) : new ExcludeEntryDescription(chosenFile, false, true, (Disposable)ExcludedEntriesConfigurable.this.myProject);
                ExcludedEntriesConfigurable.this.myExcludeEntryDescriptions.add(selected2, description);
                ++selected2;
            }
            if (selected2 > savedSelected) {
                AbstractTableModel model = (AbstractTableModel)this.myExcludedTable.getModel();
                model.fireTableRowsInserted(savedSelected, selected2 - 1);
                this.myExcludedTable.setRowSelectionInterval(savedSelected, selected2 - 1);
            }
        }

        private boolean isFileExcluded(VirtualFile file2) {
            for (ExcludeEntryDescription description : ExcludedEntriesConfigurable.this.myExcludeEntryDescriptions) {
                VirtualFile descriptionFile = description.getVirtualFile();
                if (descriptionFile == null || !file2.equals(descriptionFile)) continue;
                return true;
            }
            return false;
        }

        private void removePaths() {
            TableCellEditor editor;
            int[] selected2 = this.myExcludedTable.getSelectedRows();
            if (selected2 == null || selected2.length <= 0) {
                return;
            }
            if (this.myExcludedTable.isEditing() && (editor = this.myExcludedTable.getCellEditor()) != null) {
                editor.stopCellEditing();
            }
            AbstractTableModel model = (AbstractTableModel)this.myExcludedTable.getModel();
            Arrays.sort(selected2);
            int indexToSelect = selected2[selected2.length - 1];
            int removedCount = 0;
            for (int indexToRemove : selected2) {
                int row = indexToRemove - removedCount;
                ExcludeEntryDescription description = (ExcludeEntryDescription)ExcludedEntriesConfigurable.this.myExcludeEntryDescriptions.get(row);
                Disposer.dispose(description);
                ExcludedEntriesConfigurable.this.myExcludeEntryDescriptions.remove(row);
                model.fireTableRowsDeleted(row, row);
                ++removedCount;
            }
            if (indexToSelect >= ExcludedEntriesConfigurable.this.myExcludeEntryDescriptions.size()) {
                indexToSelect = ExcludedEntriesConfigurable.this.myExcludeEntryDescriptions.size() - 1;
            }
            if (indexToSelect >= 0) {
                this.myExcludedTable.setRowSelectionInterval(indexToSelect, indexToSelect);
            }
            IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus(this.myExcludedTable, true));
        }

        @Override
        protected JComponent createMainComponent() {
            final String[] names2 = new String[]{JavaCompilerBundle.message("exclude.from.compile.table.path.column.name", new Object[0]), JavaCompilerBundle.message("exclude.from.compile.table.recursively.column.name", new Object[0])};
            AbstractTableModel dataModel = new AbstractTableModel(){

                @Override
                public int getColumnCount() {
                    return names2.length;
                }

                @Override
                public int getRowCount() {
                    return ExcludedEntriesConfigurable.this.myExcludeEntryDescriptions.size();
                }

                @Override
                public Object getValueAt(int row, int col) {
                    ExcludeEntryDescription description = (ExcludeEntryDescription)ExcludedEntriesConfigurable.this.myExcludeEntryDescriptions.get(row);
                    if (col == 0) {
                        return description.getPresentableUrl();
                    }
                    if (col == 1) {
                        if (!description.isFile()) {
                            return description.isIncludeSubdirectories();
                        }
                        return null;
                    }
                    return null;
                }

                @Override
                public String getColumnName(int column) {
                    return names2[column];
                }

                public Class getColumnClass(int c) {
                    if (c == 0) {
                        return String.class;
                    }
                    if (c == 1) {
                        return Boolean.class;
                    }
                    return null;
                }

                @Override
                public boolean isCellEditable(int row, int col) {
                    if (col == 1) {
                        ExcludeEntryDescription description = (ExcludeEntryDescription)ExcludedEntriesConfigurable.this.myExcludeEntryDescriptions.get(row);
                        return !description.isFile();
                    }
                    return true;
                }

                @Override
                public void setValueAt(Object aValue, int row, int col) {
                    ExcludeEntryDescription description = (ExcludeEntryDescription)ExcludedEntriesConfigurable.this.myExcludeEntryDescriptions.get(row);
                    if (col == 1) {
                        description.setIncludeSubdirectories(aValue.equals(Boolean.TRUE));
                    } else {
                        String path2 = (String)aValue;
                        description.setPresentableUrl(path2);
                    }
                }
            };
            this.myExcludedTable = new JBTable(dataModel);
            this.myExcludedTable.setEnableAntialiasing(true);
            this.myExcludedTable.getEmptyText().setText(JavaCompilerBundle.message("no.excludes", new Object[0]));
            this.myExcludedTable.setPreferredScrollableViewportSize(JBUI.size(300, -1));
            this.myExcludedTable.setVisibleRowCount(6);
            this.myExcludedTable.setDefaultRenderer(Boolean.class, new BooleanRenderer());
            this.myExcludedTable.setDefaultRenderer(Object.class, new MyObjectRenderer());
            this.myExcludedTable.getColumn(names2[0]).setPreferredWidth(350);
            int cbWidth = 15 + this.myExcludedTable.getTableHeader().getFontMetrics(this.myExcludedTable.getTableHeader().getFont()).stringWidth(names2[1]);
            TableColumn cbColumn = this.myExcludedTable.getColumn(names2[1]);
            cbColumn.setPreferredWidth(cbWidth);
            cbColumn.setMaxWidth(cbWidth);
            this.myExcludedTable.getSelectionModel().setSelectionMode(2);
            this.myExcludedTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    ExcludedEntriesPanel.this.myRemoveButton.setEnabled(ExcludedEntriesPanel.this.myExcludedTable.getSelectedRow() >= 0);
                }
            });
            TableCellEditor editor = this.myExcludedTable.getDefaultEditor(String.class);
            if (editor instanceof DefaultCellEditor) {
                ((DefaultCellEditor)editor).setClickCountToStart(1);
            }
            return ToolbarDecorator.createDecorator(this.myExcludedTable).disableUpAction().disableDownAction().setAddAction(new AnActionButtonRunnable(){

                @Override
                public void run(AnActionButton anActionButton) {
                    ExcludedEntriesPanel.this.addPath(ExcludedEntriesConfigurable.this.myDescriptor);
                }
            }).setRemoveAction(new AnActionButtonRunnable(){

                @Override
                public void run(AnActionButton anActionButton) {
                    ExcludedEntriesPanel.this.removePaths();
                }
            }).createPanel();
        }
    }
}

