/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diagnostic;

import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.Nullable;

public class IdeaLoggingEvent {
    private final String myMessage;
    private final Throwable myThrowable;
    private final Object myData;

    public IdeaLoggingEvent(String message, Throwable throwable) {
        this(message, throwable, null);
    }

    public IdeaLoggingEvent(String message, Throwable throwable, Object data2) {
        this.myMessage = message;
        this.myThrowable = throwable;
        this.myData = data2;
    }

    public String getMessage() {
        return this.myMessage;
    }

    public Throwable getThrowable() {
        return this.myThrowable;
    }

    public String getThrowableText() {
        return this.myThrowable != null ? StringUtil.getThrowableText(this.myThrowable) : "";
    }

    @Nullable
    public Object getData() {
        return this.myData;
    }

    public String toString() {
        return "IdeaLoggingEvent[message=" + this.myMessage + ", throwable=" + this.getThrowableText() + "]";
    }
}

