/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diagnostic;

import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.DefaultLogger;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.containers.ContainerUtil;
import java.lang.reflect.Constructor;
import java.util.function.Function;
import org.apache.log4j.Level;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Logger {
    private static Factory ourFactory = new DefaultFactory();
    static final Function<Attachment, String> ATTACHMENT_TO_STRING = attachment -> attachment.getPath() + "\n" + attachment.getDisplayText();

    public static void setFactory(@NotNull Class<? extends Factory> factory) {
        if (factory == null) {
            Logger.$$$reportNull$$$0(0);
        }
        if (Logger.isInitialized()) {
            if (factory.isInstance(ourFactory)) {
                return;
            }
            System.out.println("Changing log factory\n" + ExceptionUtil.getThrowableText(new Throwable()));
        }
        try {
            Constructor<? extends Factory> constructor2 = factory.getDeclaredConstructor(new Class[0]);
            constructor2.setAccessible(true);
            ourFactory = constructor2.newInstance(new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public static void setFactory(Factory factory) {
        if (Logger.isInitialized()) {
            System.out.println("Changing log factory\n" + ExceptionUtil.getThrowableText(new Throwable()));
        }
        ourFactory = factory;
    }

    public static Factory getFactory() {
        return ourFactory;
    }

    public static boolean isInitialized() {
        return !(ourFactory instanceof DefaultFactory);
    }

    @NotNull
    public static Logger getInstance(@NotNull String category) {
        if (category == null) {
            Logger.$$$reportNull$$$0(1);
        }
        Logger logger = ourFactory.getLoggerInstance(category);
        if (logger == null) {
            Logger.$$$reportNull$$$0(2);
        }
        return logger;
    }

    @NotNull
    public static Logger getInstance(@NotNull Class cl) {
        if (cl == null) {
            Logger.$$$reportNull$$$0(3);
        }
        return Logger.getInstance("#" + cl.getName());
    }

    public abstract boolean isDebugEnabled();

    public abstract void debug(@NonNls String var1);

    public abstract void debug(@Nullable Throwable var1);

    public abstract void debug(@NonNls String var1, @Nullable Throwable var2);

    public void debug(@NonNls @NotNull String message, Object ... details) {
        if (message == null) {
            Logger.$$$reportNull$$$0(4);
        }
        if (details == null) {
            Logger.$$$reportNull$$$0(5);
        }
        if (this.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append(message);
            for (Object detail : details) {
                sb.append(detail);
            }
            this.debug(sb.toString());
        }
    }

    public boolean isTraceEnabled() {
        return this.isDebugEnabled();
    }

    public void trace(@NonNls String message) {
        this.debug(message);
    }

    public void trace(@Nullable Throwable t) {
        this.debug(t);
    }

    public void info(@NotNull Throwable t) {
        if (t == null) {
            Logger.$$$reportNull$$$0(6);
        }
        this.info(t.getMessage(), t);
    }

    public abstract void info(@NonNls String var1);

    public abstract void info(@NonNls String var1, @Nullable Throwable var2);

    public void warn(@NonNls String message) {
        this.warn(message, null);
    }

    public void warn(@NotNull Throwable t) {
        if (t == null) {
            Logger.$$$reportNull$$$0(7);
        }
        this.warn(t.getMessage(), t);
    }

    public abstract void warn(@NonNls String var1, @Nullable Throwable var2);

    public void error(@NonNls String message) {
        this.error(message, new Throwable(message), ArrayUtilRt.EMPTY_STRING_ARRAY);
    }

    public void error(Object message) {
        this.error(String.valueOf(message));
    }

    public void error(@NonNls String message, Attachment ... attachments) {
        if (attachments == null) {
            Logger.$$$reportNull$$$0(8);
        }
        this.error(message, (Throwable)null, attachments);
    }

    public void error(@NonNls String message, @Nullable Throwable t, Attachment ... attachments) {
        if (attachments == null) {
            Logger.$$$reportNull$$$0(9);
        }
        this.error(message, t, ContainerUtil.map2Array(attachments, String.class, ATTACHMENT_TO_STRING::apply));
    }

    public void error(@NonNls String message, String ... details) {
        if (details == null) {
            Logger.$$$reportNull$$$0(10);
        }
        this.error(message, new Throwable(message), details);
    }

    public void error(@NonNls String message, @Nullable Throwable t) {
        this.error(message, t, ArrayUtilRt.EMPTY_STRING_ARRAY);
    }

    public void error(@NotNull Throwable t) {
        if (t == null) {
            Logger.$$$reportNull$$$0(11);
        }
        this.error(t.getMessage(), t, ArrayUtilRt.EMPTY_STRING_ARRAY);
    }

    public abstract void error(@NonNls String var1, @Nullable Throwable var2, String ... var3);

    @Contract(value="false,_->fail")
    public boolean assertTrue(boolean value2, @NonNls @Nullable Object message) {
        if (!value2) {
            String resultMessage = "Assertion failed";
            if (message != null) {
                resultMessage = resultMessage + ": " + message;
            }
            this.error(resultMessage, new Throwable(resultMessage));
        }
        return value2;
    }

    @Contract(value="false->fail")
    public boolean assertTrue(boolean value2) {
        return value2 || this.assertTrue(false, null);
    }

    public abstract void setLevel(Level var1);

    protected static Throwable checkException(@Nullable Throwable t) {
        return t instanceof ControlFlowException ? new Throwable("Control-flow exceptions (like " + t.getClass().getSimpleName() + ") should never be logged", t) : t;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "category";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/diagnostic/Logger";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "details";
                break;
            }
            case 6: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "t";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attachments";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/diagnostic/Logger";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setFactory";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 2: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "debug";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "info";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "warn";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "error";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class DefaultFactory
    implements Factory {
        private DefaultFactory() {
        }

        @Override
        @NotNull
        public Logger getLoggerInstance(@NotNull String category) {
            if (category == null) {
                DefaultFactory.$$$reportNull$$$0(0);
            }
            return new DefaultLogger(category);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "category", "com/intellij/openapi/diagnostic/Logger$DefaultFactory", "getLoggerInstance"));
        }
    }

    public static interface Factory {
        @NotNull
        public Logger getLoggerInstance(@NotNull String var1);
    }
}

