/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.vfs.VirtualFile;

public class DiffContentUtil {
    public static FileType getContentType(VirtualFile file2) {
        if (file2 == null) {
            return null;
        }
        return file2.getFileType();
    }

    public static boolean isTextFile(VirtualFile file2) {
        return file2 != null && file2.isValid() && !file2.isDirectory() && DiffContentUtil.isTextType(file2.getFileType());
    }

    public static boolean isTextType(FileType fileType) {
        return fileType != null && !fileType.isBinary();
    }

    public static String getTitle(VirtualFile virtualFile2) {
        VirtualFile parent = virtualFile2.getParent();
        if (parent == null) {
            return virtualFile2.getPresentableUrl();
        }
        return virtualFile2.getName() + " (" + parent.getPresentableUrl() + ")";
    }
}

