/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff;

import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diff.DiffContent;
import com.intellij.openapi.diff.DiffContentUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.util.LineSeparator;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileContent
extends DiffContent {
    @NotNull
    private final VirtualFile myFile;
    private Document myDocument;
    private final Project myProject;
    private final FileType myType;

    public FileContent(Project project2, @NotNull VirtualFile file2) {
        if (file2 == null) {
            FileContent.$$$reportNull$$$0(0);
        }
        this.myProject = project2;
        this.myFile = file2;
        this.myType = file2.getFileType();
    }

    @Override
    public Document getDocument() {
        if (this.myDocument == null && DiffContentUtil.isTextFile(this.myFile)) {
            this.myDocument = ReadAction.compute(() -> FileDocumentManager.getInstance().getDocument(this.myFile));
        }
        return this.myDocument;
    }

    @Override
    public Navigatable getOpenFileDescriptor(int offset) {
        return PsiNavigationSupport.getInstance().createNavigatable(this.myProject, this.myFile, offset);
    }

    @Override
    @NotNull
    public VirtualFile getFile() {
        VirtualFile virtualFile2 = this.myFile;
        if (virtualFile2 == null) {
            FileContent.$$$reportNull$$$0(1);
        }
        return virtualFile2;
    }

    @Override
    @Nullable
    public FileType getContentType() {
        return this.myType;
    }

    @Override
    public byte[] getBytes() throws IOException {
        if (this.myFile.isDirectory()) {
            return null;
        }
        return this.myFile.contentsToByteArray();
    }

    @Override
    public boolean isBinary() {
        return !this.myFile.isDirectory() && this.myType.isBinary();
    }

    public static FileContent createFromTempFile(Project project2, String name, String ext, byte @NotNull [] content2) throws IOException {
        if (content2 == null) {
            FileContent.$$$reportNull$$$0(2);
        }
        File tempFile = FileUtil.createTempFile(name, "." + ext);
        if (content2.length != 0) {
            FileUtil.writeToFile(tempFile, content2);
        }
        tempFile.deleteOnExit();
        LocalFileSystem lfs = LocalFileSystem.getInstance();
        VirtualFile file2 = lfs.findFileByIoFile(tempFile);
        if (file2 == null) {
            file2 = lfs.refreshAndFindFileByIoFile(tempFile);
        }
        if (file2 != null) {
            return new FileContent(project2, file2);
        }
        throw new IOException("Can not create temp file for revision content");
    }

    @Override
    @NotNull
    public LineSeparator getLineSeparator() {
        LineSeparator lineSeparator = LineSeparator.fromString(FileDocumentManager.getInstance().getLineSeparator(this.myFile, this.myProject));
        if (lineSeparator == null) {
            FileContent.$$$reportNull$$$0(3);
        }
        return lineSeparator;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/diff/FileContent";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/diff/FileContent";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getLineSeparator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createFromTempFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

