/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.dir;

import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.diff.impl.dir.DirDiffPanel;
import com.intellij.openapi.diff.impl.dir.DirDiffTableModel;
import com.intellij.openapi.diff.impl.dir.DirDiffWindow;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.table.JBTable;
import javax.swing.Action;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class DirDiffDialog
extends DialogWrapper {
    private final DirDiffTableModel myModel;
    private DirDiffPanel myDiffPanel;

    public DirDiffDialog(Project project2, DirDiffTableModel model) {
        super(project2);
        this.setModal(false);
        this.myModel = model;
        this.setTitle(DiffBundle.message("directory.diff", new Object[0]));
        this.init();
        JBTable table = this.myDiffPanel.getTable();
        table.setColumnSelectionAllowed(false);
        table.getTableHeader().setReorderingAllowed(false);
        table.getTableHeader().setResizingAllowed(false);
        Disposer.register(this.getDisposable(), this.myModel);
        Disposer.register(project2, this.getDisposable());
    }

    @Override
    protected String getDimensionServiceKey() {
        this.setSize(800, 600);
        this.myDiffPanel.setupSplitter();
        return "DirDiffDialog";
    }

    @Override
    protected JComponent createCenterPanel() {
        this.myDiffPanel = new DirDiffPanel(this.myModel, new DirDiffWindow.Dialog(this));
        Disposer.register(this.getDisposable(), this.myDiffPanel);
        return this.myDiffPanel.getPanel();
    }

    @Override
    public JComponent getPreferredFocusedComponent() {
        return this.myDiffPanel.getTable();
    }

    @Override
    protected Action @NotNull [] createActions() {
        return new Action[0];
    }

    @Override
    protected String getHelpId() {
        return "reference.dialogs.diff.folder";
    }
}

