/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.dir;

import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.diff.impl.dir.DirDiffPanel;
import com.intellij.openapi.diff.impl.dir.DirDiffTableModel;
import com.intellij.openapi.diff.impl.dir.DirDiffWindow;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.FrameWrapper;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.WindowState;
import com.intellij.util.ui.JBUI;
import org.jetbrains.annotations.Nullable;

public class DirDiffFrame
extends FrameWrapper {
    private final DirDiffPanel myPanel;

    public DirDiffFrame(Project project2, DirDiffTableModel model) {
        super(project2, "DirDiffDialog");
        this.setSize(JBUI.size(800, 600));
        this.setTitle(model.getTitle());
        this.myPanel = new DirDiffPanel(model, new DirDiffWindow.Frame(this));
        Disposer.register(this, this.myPanel);
        this.setComponent(this.myPanel.getPanel());
        this.setPreferredFocusedComponent(this.myPanel.getTable());
        if (project2 != null) {
            this.setProject(project2);
        }
        this.closeOnEsc();
        DataManager.registerDataProvider(this.myPanel.getPanel(), dataId -> {
            if (PlatformDataKeys.HELP_ID.is(dataId)) {
                return "reference.dialogs.diff.folder";
            }
            return null;
        });
    }

    @Override
    protected void loadFrameState(@Nullable WindowState state) {
        super.loadFrameState(state);
        this.myPanel.setupSplitter();
    }
}

