/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.dir;

import com.intellij.ide.diff.DirDiffOperation;
import com.intellij.openapi.diff.impl.dir.DirDiffElementImpl;
import com.intellij.openapi.diff.impl.dir.DirDiffTableModel;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumnModel;

public class DirDiffTableCellRenderer
extends DefaultTableCellRenderer {
    @Override
    public Component getTableCellRendererComponent(final JTable table, Object value2, boolean isSelected, boolean hasFocus, int row, final int column) {
        DirDiffTableModel model = (DirDiffTableModel)table.getModel();
        final DirDiffElementImpl element2 = model.getElementAt(row);
        if (element2 == null) {
            return super.getTableCellRendererComponent(table, value2, isSelected, hasFocus, row, column);
        }
        int modelColumn = table.convertColumnIndexToModel(column);
        if (element2.isSeparator()) {
            return new SimpleColoredComponent(){
                {
                    this.setIcon(ObjectUtils.chooseNotNull(element2.getSourceIcon(), element2.getTargetIcon()));
                    this.append(element2.getName());
                }

                @Override
                protected void doPaint(Graphics2D g) {
                    int offset = 0;
                    TableColumnModel columnModel = table.getColumnModel();
                    for (int i = 0; i < column; ++i) {
                        offset += columnModel.getColumn(i).getWidth();
                    }
                    g.translate(-offset, 0);
                    super.doPaint(g);
                    g.translate(offset, 0);
                }
            };
        }
        Component c = super.getTableCellRendererComponent(table, value2, isSelected, hasFocus, row, column);
        if (c instanceof JLabel) {
            JLabel label2 = (JLabel)c;
            Border border = label2.getBorder();
            if ((hasFocus || isSelected) && border != null) {
                label2.setBorder(new EmptyBorder(border.getBorderInsets(label2)));
            }
            label2.setIcon(null);
            DirDiffOperation op = element2.getOperation();
            if (modelColumn == (table.getColumnCount() - 1) / 2) {
                label2.setIcon(op.getIcon());
                label2.setHorizontalAlignment(0);
                return label2;
            }
            Color fg = isSelected ? UIUtil.getTableSelectionForeground() : op.getTextColor();
            label2.setForeground(fg);
            DirDiffTableModel.ColumnType type = ((DirDiffTableModel)table.getModel()).getColumnType(column);
            if (type == DirDiffTableModel.ColumnType.DATE) {
                label2.setHorizontalAlignment(0);
            } else if (type == DirDiffTableModel.ColumnType.SIZE) {
                label2.setHorizontalAlignment(4);
            } else {
                label2.setHorizontalAlignment(2);
                String text2 = label2.getText();
                label2.setText("  " + text2);
                if (text2 != null && text2.trim().length() > 0) {
                    label2.setIcon(modelColumn == 0 ? element2.getSourceIcon() : element2.getTargetIcon());
                }
            }
        }
        return c;
    }
}

