/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.dir;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.intellij.CommonBundle;
import com.intellij.diff.DiffRequestFactory;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.diff.AsyncDiffElement;
import com.intellij.ide.diff.DiffElement;
import com.intellij.ide.diff.DiffType;
import com.intellij.ide.diff.DirDiffModel;
import com.intellij.ide.diff.DirDiffOperation;
import com.intellij.ide.diff.DirDiffSettings;
import com.intellij.ide.diff.VirtualFileDiffElement;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.diff.impl.dir.DTree;
import com.intellij.openapi.diff.impl.dir.DirDiffElementImpl;
import com.intellij.openapi.diff.impl.dir.DirDiffModelListener;
import com.intellij.openapi.diff.impl.dir.DirDiffPanel;
import com.intellij.openapi.diff.impl.dir.actions.popup.WarnOnDeletion;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.TableUtil;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.ui.table.JBTable;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.StatusText;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DirDiffTableModel
extends AbstractTableModel
implements DirDiffModel,
Disposable {
    private static final Logger LOG = Logger.getInstance(DirDiffTableModel.class);
    public static final Key<JBLoadingPanel> DECORATOR_KEY = Key.create("DIFF_TABLE_DECORATOR");
    public static final String EMPTY_STRING = StringUtil.repeatSymbol(' ', 50);
    @Nullable
    private final Project myProject;
    private final DirDiffSettings mySettings;
    private DiffElement mySource;
    private DiffElement myTarget;
    private DTree myTree;
    private final List<DirDiffElementImpl> myElements = new ArrayList<DirDiffElementImpl>();
    private final AtomicBoolean myUpdating = new AtomicBoolean(false);
    private JBTable myTable;
    private final AtomicReference<String> text = new AtomicReference<String>(DirDiffTableModel.prepareText(""));
    private Updater myUpdater;
    private final List<DirDiffModelListener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private TableSelectionConfig mySelectionConfig;
    private final Map<String, BiMap<String, String>> mySourceToReplacingTarget = HashBiMap.create();
    private DirDiffPanel myPanel;
    private volatile boolean myDisposed;

    public DirDiffTableModel(@Nullable Project project2, DiffElement<?> source, DiffElement<?> target2, DirDiffSettings settings) {
        this.myProject = project2;
        this.mySettings = settings;
        this.mySource = source;
        this.myTarget = target2;
    }

    public void stopUpdating() {
        if (this.myUpdating.get()) {
            this.myUpdating.set(false);
        }
    }

    public void applyRemove() {
        int index;
        List<DirDiffElementImpl> selectedElements = this.getSelectedElements();
        this.myUpdating.set(true);
        Iterator<DirDiffElementImpl> i = this.myElements.iterator();
        while (i.hasNext()) {
            DiffType type = i.next().getType();
            switch (type) {
                case SOURCE: {
                    if (this.mySettings.showNewOnSource) break;
                    i.remove();
                    break;
                }
                case TARGET: {
                    if (this.mySettings.showNewOnTarget) break;
                    i.remove();
                    break;
                }
                case SEPARATOR: {
                    break;
                }
                case CHANGED: {
                    if (this.mySettings.showDifferent) break;
                    i.remove();
                    break;
                }
                case EQUAL: {
                    if (this.mySettings.showEqual) break;
                    i.remove();
                    break;
                }
            }
        }
        boolean sep = true;
        for (int j = this.myElements.size() - 1; j >= 0; --j) {
            if (this.myElements.get(j).isSeparator()) {
                if (sep) {
                    this.myElements.remove(j);
                    continue;
                }
                sep = true;
                continue;
            }
            sep = false;
        }
        this.fireTableDataChanged();
        this.myUpdating.set(false);
        if (!selectedElements.isEmpty() && (index = this.myElements.indexOf(selectedElements.get(0))) != -1) {
            this.myTable.getSelectionModel().setSelectionInterval(index, index);
            TableUtil.scrollSelectionToVisible(this.myTable);
        } else {
            this.selectFirstRow();
        }
        this.myPanel.update(true);
    }

    public void selectFirstRow() {
        if (this.myElements.size() > 0) {
            int row;
            int n = row = this.myElements.get(0).isSeparator() ? 1 : 0;
            if (row < this.myTable.getRowCount()) {
                this.myTable.getSelectionModel().setSelectionInterval(row, row);
                TableUtil.scrollSelectionToVisible(this.myTable);
            }
        }
    }

    public void setPanel(DirDiffPanel panel2) {
        this.myPanel = panel2;
    }

    public void updateFromUI() {
        this.getSettings().setFilter(this.myPanel.getFilter());
        this.myPanel.update(false);
    }

    public boolean isOperationsEnabled() {
        return !this.myDisposed && this.mySettings.enableOperations && this.mySource.isOperationsEnabled() && this.myTarget.isOperationsEnabled();
    }

    public List<DirDiffElementImpl> getElements() {
        return this.myElements;
    }

    public void setReplacement(DirDiffElementImpl source, @Nullable DirDiffElementImpl target2) {
        this.setReplacement(source.getParentNode().getPath(), source.getSourceName(), target2 == null ? null : target2.getTargetName());
    }

    public void setReplacement(@NotNull String path2, @Nullable String sourceName, @Nullable String targetName) {
        if (path2 == null) {
            DirDiffTableModel.$$$reportNull$$$0(0);
        }
        BiMap map2 = this.mySourceToReplacingTarget.computeIfAbsent(path2, p -> HashBiMap.create());
        if (targetName != null) {
            map2.forcePut((Object)sourceName, (Object)targetName);
        } else {
            map2.remove((Object)sourceName);
        }
    }

    public String getReplacementName(DirDiffElementImpl source) {
        BiMap<String, String> map2 = this.mySourceToReplacingTarget.get(source.getParentNode().getPath());
        return map2 != null ? (String)map2.get((Object)source.getSourceName()) : null;
    }

    private static String prepareText(String text2) {
        int LEN = EMPTY_STRING.length();
        String right = text2 == null ? EMPTY_STRING : (text2.length() == LEN ? text2 : (text2.length() < LEN ? text2 + EMPTY_STRING.substring(0, LEN - text2.length()) : "..." + text2.substring(text2.length() - LEN + 2)));
        return DiffBundle.message("label.dirdiff.loading.file", right);
    }

    void fireUpdateStarted() {
        for (DirDiffModelListener listener2 : this.myListeners) {
            listener2.updateStarted();
        }
    }

    void fireUpdateFinished() {
        for (DirDiffModelListener listener2 : this.myListeners) {
            listener2.updateFinished();
        }
    }

    void addModelListener(DirDiffModelListener listener2) {
        this.myListeners.add(listener2);
    }

    @Override
    public void reloadModel(boolean userForcedRefresh) {
        this.fireUpdateStarted();
        this.myUpdating.set(true);
        this.myTable.getEmptyText().setText(StatusText.getDefaultEmptyText());
        JBLoadingPanel loadingPanel = this.getLoadingPanel();
        loadingPanel.startLoading();
        ModalityState modalityState = ModalityState.current();
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            EmptyProgressIndicator indicator = new EmptyProgressIndicator(modalityState);
            ProgressManager.getInstance().executeProcessUnderProgress(() -> {
                try {
                    if (this.myDisposed) {
                        return;
                    }
                    this.myUpdater = new Updater(loadingPanel, 100);
                    this.myUpdater.start();
                    this.text.set(CommonBundle.getLoadingTreeNodeText());
                    this.myTree = new DTree(null, "", true);
                    this.mySource.refresh(userForcedRefresh);
                    this.myTarget.refresh(userForcedRefresh);
                    this.scan(this.mySource, this.myTree, true);
                    this.scan(this.myTarget, this.myTree, false);
                }
                catch (IOException e) {
                    LOG.warn(e);
                    this.reportException(VcsBundle.message("refresh.failed.message", StringUtil.decapitalize(e.getLocalizedMessage())));
                }
                finally {
                    if (this.myTree != null) {
                        this.myTree.setSource(this.mySource);
                        this.myTree.setTarget(this.myTarget);
                        this.myTree.update(this.mySettings);
                        ApplicationManager.getApplication().invokeLater(this::fireUpdateFinished, ModalityState.any());
                        this.applySettings();
                    }
                }
            }, indicator);
        });
    }

    public void reloadModelSynchronously() {
        this.myUpdating.set(true);
        try {
            this.fireUpdateStarted();
            this.myTree = new DTree(null, "", true);
            this.mySource.refresh(true);
            this.myTarget.refresh(true);
            this.scan(this.mySource, this.myTree, true);
            this.scan(this.myTarget, this.myTree, false);
        }
        catch (IOException e) {
            LOG.warn(e);
            this.reportException(VcsBundle.message("refresh.failed.message", StringUtil.decapitalize(e.getLocalizedMessage())));
        }
        finally {
            this.myTree.setSource(this.mySource);
            this.myTree.setTarget(this.myTarget);
            this.myTree.update(this.mySettings);
            ArrayList<DirDiffElementImpl> elements2 = new ArrayList<DirDiffElementImpl>();
            this.fillElements(this.myTree, elements2);
            this.myElements.clear();
            this.myElements.addAll(elements2);
            this.myUpdating.set(false);
            this.fireUpdateFinished();
        }
    }

    private void reportException(@Nullable String htmlContent) {
        if (this.myDisposed || htmlContent == null) {
            return;
        }
        Runnable balloonShower = () -> {
            Balloon balloon = JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(htmlContent, MessageType.WARNING, null).setShowCallout(false).setHideOnClickOutside(true).setHideOnAction(true).setHideOnFrameResize(true).setHideOnKeyOutside(true).createBalloon();
            Rectangle rect = this.myPanel.getPanel().getBounds();
            Point p = new Point(rect.x + rect.width - 100, rect.y + 50);
            RelativePoint point = new RelativePoint(this.myPanel.getPanel(), p);
            balloon.show(point, Balloon.Position.below);
            Disposer.register(this.myProject != null ? this.myProject : ApplicationManager.getApplication(), balloon);
        };
        ApplicationManager.getApplication().invokeLater(balloonShower, o -> this.myProject != null && !this.myProject.isDefault() && !this.myProject.isOpen());
    }

    private JBLoadingPanel getLoadingPanel() {
        return ComponentUtil.getClientProperty(this.myTable, DECORATOR_KEY);
    }

    @Override
    public void applySettings() {
        JBLoadingPanel loadingPanel;
        if (!this.myUpdating.get()) {
            this.myUpdating.set(true);
        }
        if (!(loadingPanel = this.getLoadingPanel()).isLoading()) {
            loadingPanel.startLoading();
            if (this.myUpdater == null) {
                this.myUpdater = new Updater(loadingPanel, 100);
                this.myUpdater.start();
            }
        }
        Application app = ApplicationManager.getApplication();
        app.executeOnPooledThread(() -> {
            if (this.myDisposed) {
                return;
            }
            this.myTree.updateVisibility(this.mySettings);
            ArrayList<DirDiffElementImpl> elements2 = new ArrayList<DirDiffElementImpl>();
            this.fillElements(this.myTree, elements2);
            Runnable uiThread = () -> {
                if (this.myDisposed) {
                    return;
                }
                this.clear();
                this.myElements.addAll(elements2);
                this.myUpdating.set(false);
                this.fireTableDataChanged();
                this.text.set("");
                if (loadingPanel.isLoading()) {
                    loadingPanel.stopLoading();
                }
                if (this.mySelectionConfig == null) {
                    this.selectFirstRow();
                } else {
                    this.mySelectionConfig.restore();
                }
                this.myPanel.update(true);
            };
            if (this.myProject == null || this.myProject.isDefault()) {
                SwingUtilities.invokeLater(uiThread);
            } else {
                app.invokeLater(uiThread, ModalityState.any());
            }
        });
    }

    private void fillElements(DTree tree, List<DirDiffElementImpl> elements2) {
        if (!this.myUpdating.get()) {
            return;
        }
        boolean separatorAdded = tree.getParent() == null;
        this.text.set(DirDiffTableModel.prepareText(tree.getPath()));
        for (DTree child2 : tree.getChildren()) {
            if (!this.myUpdating.get()) {
                return;
            }
            if (!child2.isContainer()) {
                DiffType type;
                if (!child2.isVisible()) continue;
                if (!separatorAdded) {
                    elements2.add(DirDiffElementImpl.createDirElement(tree, tree.getSource(), tree.getTarget(), tree.getPath()));
                    separatorAdded = true;
                }
                if ((type = child2.getType()) != null) {
                    switch (type) {
                        case SOURCE: {
                            elements2.add(DirDiffElementImpl.createSourceOnly(child2, child2.getSource()));
                            break;
                        }
                        case TARGET: {
                            elements2.add(DirDiffElementImpl.createTargetOnly(child2, child2.getTarget()));
                            break;
                        }
                        case CHANGED: {
                            elements2.add(DirDiffElementImpl.createChange(child2, child2.getSource(), child2.getTarget(), this.mySettings.customSourceChooser));
                            break;
                        }
                        case EQUAL: {
                            elements2.add(DirDiffElementImpl.createEqual(child2, child2.getSource(), child2.getTarget()));
                            break;
                        }
                        case ERROR: {
                            elements2.add(DirDiffElementImpl.createError(child2, child2.getSource(), child2.getTarget()));
                        }
                    }
                    continue;
                }
                LOG.error(String.format("Element's type is null [Name: %s, Container: %s, Source: %s, Target: %s] ", child2.getName(), child2.isContainer(), child2.getSource(), child2.getTarget()));
                continue;
            }
            this.fillElements(child2, elements2);
        }
    }

    public void clear() {
        if (!this.myElements.isEmpty()) {
            int size = this.myElements.size();
            this.myElements.clear();
            this.fireTableRowsDeleted(0, size - 1);
        }
    }

    private void scan(DiffElement<?> element2, DTree root, boolean source) throws IOException {
        if (!this.myUpdating.get()) {
            return;
        }
        if (element2.isContainer()) {
            DiffElement[] children2;
            this.text.set(DirDiffTableModel.prepareText(element2.getPath()));
            for (DiffElement child2 : children2 = element2.getChildren()) {
                if (!this.myUpdating.get()) {
                    return;
                }
                this.text.set(DirDiffTableModel.prepareText(child2.getPath()));
                BiMap<String, String> replacing = this.mySourceToReplacingTarget.get(root.getPath());
                String replacementName = replacing != null ? (source ? (String)replacing.get((Object)child2.getName()) : (String)replacing.inverse().get((Object)child2.getName())) : null;
                DTree el = root.addChild(child2, source, replacementName);
                this.scan(child2, el, source);
            }
        }
    }

    public String getTitle() {
        if (this.myDisposed) {
            return DiffBundle.message("diff.files.dialog.title", new Object[0]);
        }
        if (this.mySource instanceof VirtualFileDiffElement && this.myTarget instanceof VirtualFileDiffElement) {
            VirtualFile srcFile = ((VirtualFileDiffElement)this.mySource).getValue();
            VirtualFile trgFile = ((VirtualFileDiffElement)this.myTarget).getValue();
            return DiffRequestFactory.getInstance().getTitle(srcFile, trgFile);
        }
        return IdeBundle.message("diff.dialog.title", this.mySource.getPresentablePath(), this.myTarget.getPresentablePath());
    }

    @Nullable
    public DirDiffElementImpl getElementAt(int index) {
        return 0 <= index && index < this.myElements.size() ? this.myElements.get(index) : null;
    }

    @Override
    public DiffElement getSourceDir() {
        return this.mySource;
    }

    @Override
    public DiffElement getTargetDir() {
        return this.myTarget;
    }

    @Override
    public void setSourceDir(DiffElement src) {
        this.mySource = src;
    }

    @Override
    public void setTargetDir(DiffElement trg) {
        this.myTarget = trg;
    }

    @Override
    public int getRowCount() {
        return this.myElements.size();
    }

    @Override
    public int getColumnCount() {
        int count = 3;
        if (this.mySettings.showDate) {
            count += 2;
        }
        if (this.mySettings.showSize) {
            count += 2;
        }
        return count;
    }

    public JBTable getTable() {
        return this.myTable;
    }

    public void setTable(JBTable table) {
        this.myTable = table;
    }

    @Override
    @Nullable
    public Object getValueAt(int rowIndex, int columnIndex) {
        try {
            boolean isSrc;
            DirDiffElementImpl element2 = this.myElements.get(rowIndex);
            if (element2.isSeparator()) {
                return columnIndex == 0 ? element2.getName() : null;
            }
            ColumnType columnType = this.getColumnType(columnIndex);
            boolean bl = isSrc = columnIndex < this.getColumnCount() / 2;
            if (columnType == ColumnType.NAME) {
                return isSrc ? element2.getSourcePresentableName() : element2.getTargetPresentableName();
            }
            if (columnType == ColumnType.SIZE) {
                return isSrc ? element2.getSourceSize() : element2.getTargetSize();
            }
            if (columnType == ColumnType.DATE) {
                return isSrc ? element2.getSourceModificationDate() : element2.getTargetModificationDate();
            }
            return "";
        }
        catch (Exception e) {
            SwingUtilities.invokeLater(() -> {
                this.myElements.clear();
                this.fireTableDataChanged();
                this.myTable.getEmptyText().setText(DiffBundle.message("data.has.been.changed.externally.reloading.data", new Object[0]));
                this.reloadModel(true);
                this.myTable.repaint();
            });
            return "";
        }
    }

    public List<DirDiffElementImpl> getSelectedElements() {
        int[] rows = this.myTable.getSelectedRows();
        ArrayList<DirDiffElementImpl> elements2 = new ArrayList<DirDiffElementImpl>();
        for (int row : rows) {
            DirDiffElementImpl element2 = this.getElementAt(row);
            if (element2 == null || element2.isSeparator()) continue;
            elements2.add(element2);
        }
        return elements2;
    }

    @NotNull
    public ColumnType getColumnType(int column) {
        int count = (this.getColumnCount() - 1) / 2;
        if (column == count) {
            ColumnType columnType = ColumnType.OPERATION;
            if (columnType == null) {
                DirDiffTableModel.$$$reportNull$$$0(1);
            }
            return columnType;
        }
        if (column > count) {
            column = this.getColumnCount() - 1 - column;
        }
        switch (column) {
            case 0: {
                ColumnType columnType = ColumnType.NAME;
                if (columnType == null) {
                    DirDiffTableModel.$$$reportNull$$$0(2);
                }
                return columnType;
            }
            case 1: {
                ColumnType columnType = this.mySettings.showSize ? ColumnType.SIZE : ColumnType.DATE;
                if (columnType == null) {
                    DirDiffTableModel.$$$reportNull$$$0(3);
                }
                return columnType;
            }
            case 2: {
                ColumnType columnType = ColumnType.DATE;
                if (columnType == null) {
                    DirDiffTableModel.$$$reportNull$$$0(4);
                }
                return columnType;
            }
        }
        throw new IllegalArgumentException(String.valueOf(column));
    }

    @Override
    public String getColumnName(int column) {
        ColumnType type = this.getColumnType(column);
        switch (type) {
            case OPERATION: {
                return "*";
            }
            case NAME: {
                return DiffBundle.message("column.dirdiff.name", new Object[0]);
            }
            case SIZE: {
                return DiffBundle.message("column.dirdiff.size", new Object[0]);
            }
            case DATE: {
                return DiffBundle.message("column.dirdiff.date", new Object[0]);
            }
        }
        return type.name();
    }

    @Nullable
    public Project getProject() {
        return this.myProject;
    }

    public boolean isShowEqual() {
        return this.mySettings.showEqual;
    }

    public void setShowEqual(boolean show2) {
        this.mySettings.showEqual = show2;
    }

    public boolean isShowDifferent() {
        return this.mySettings.showDifferent;
    }

    public void setShowDifferent(boolean show2) {
        this.mySettings.showDifferent = show2;
    }

    public boolean isShowNewOnSource() {
        return this.mySettings.showNewOnSource;
    }

    public void setShowNewOnSource(boolean show2) {
        this.mySettings.showNewOnSource = show2;
    }

    public boolean isShowNewOnTarget() {
        return this.mySettings.showNewOnTarget;
    }

    public void setShowNewOnTarget(boolean show2) {
        this.mySettings.showNewOnTarget = show2;
    }

    public boolean isUpdating() {
        return this.myUpdating.get();
    }

    public DirDiffSettings.CompareMode getCompareMode() {
        return this.mySettings.compareMode;
    }

    public void setCompareMode(DirDiffSettings.CompareMode mode) {
        this.mySettings.compareMode = mode;
    }

    @Override
    public void dispose() {
        this.myDisposed = true;
        this.myListeners.clear();
        this.myElements.clear();
        this.mySource = null;
        this.myTarget = null;
        this.myTree = null;
    }

    @Override
    public DirDiffSettings getSettings() {
        return this.mySettings;
    }

    public void performCopyTo(DirDiffElementImpl element2) {
        DiffElement source = element2.getSource();
        if (source != null) {
            String path2 = element2.getParentNode().getPath();
            if (source instanceof AsyncDiffElement) {
                ((AsyncDiffElement)((Object)source)).copyToAsync(this.myTarget, element2.getTarget(), path2).onError(error -> this.reportException(error == null ? null : error.getMessage())).onSuccess(newElement -> {
                    ApplicationManager.getApplication().assertIsDispatchThread();
                    if (this.myDisposed) {
                        return;
                    }
                    if (newElement == null && element2.getTarget() != null) {
                        int row = this.myElements.indexOf(element2);
                        element2.updateTargetData();
                        this.fireTableRowsUpdated(row, row);
                    }
                    this.refreshElementAfterCopyTo((DiffElement<?>)newElement, element2);
                });
            } else {
                WriteAction.run(() -> {
                    DiffElement<?> diffElement = source.copyTo(this.myTarget, path2);
                    this.refreshElementAfterCopyTo(diffElement, element2);
                });
            }
        }
    }

    private void refreshElementAfterCopyTo(DiffElement<?> newElement, DirDiffElementImpl element2) {
        if (newElement != null) {
            DTree node = element2.getNode();
            node.setType(DiffType.EQUAL);
            node.setTarget(newElement);
            int row = this.myElements.indexOf(element2);
            if (this.getSettings().showEqual) {
                element2.updateSourceFromTarget(newElement);
                this.fireTableRowsUpdated(row, row);
            } else {
                this.removeElement(element2, false);
            }
        }
    }

    public void performCopyFrom(@NotNull DirDiffElementImpl element2) {
        DiffElement target2;
        if (element2 == null) {
            DirDiffTableModel.$$$reportNull$$$0(5);
        }
        if ((target2 = element2.getTarget()) != null) {
            String path2 = element2.getParentNode().getPath();
            if (target2 instanceof AsyncDiffElement) {
                ((AsyncDiffElement)((Object)target2)).copyToAsync(this.mySource, element2.getSource(), path2).onError(error -> this.reportException(error == null ? null : error.getMessage())).onSuccess(newElement -> {
                    if (this.myDisposed) {
                        return;
                    }
                    ApplicationManager.getApplication().assertIsDispatchThread();
                    this.refreshElementAfterCopyFrom(element2, (DiffElement<?>)newElement);
                });
            } else {
                WriteAction.run(() -> {
                    DiffElement<?> diffElement = target2.copyTo(this.mySource, path2);
                    this.refreshElementAfterCopyFrom(element2, diffElement);
                });
            }
        }
    }

    private void refreshElementAfterCopyFrom(DirDiffElementImpl element2, DiffElement<?> newElement) {
        if (newElement != null) {
            DTree node = element2.getNode();
            node.setType(DiffType.EQUAL);
            node.setSource(newElement);
            int row = this.myElements.indexOf(element2);
            if (this.getSettings().showEqual) {
                element2.updateTargetFromSource(newElement);
                this.fireTableRowsUpdated(row, row);
            } else {
                this.removeElement(element2, false);
            }
        }
    }

    private void removeElement(DirDiffElementImpl element2, boolean removeFromTree) {
        int row = this.myElements.indexOf(element2);
        if (row != -1) {
            DTree node = element2.getNode();
            if (removeFromTree) {
                DTree parentNode = element2.getParentNode();
                parentNode.remove(node);
            }
            this.myElements.remove(row);
            int start2 = row;
            if (row > 0 && row == this.myElements.size() && this.myElements.get(row - 1).isSeparator() || row != this.myElements.size() && this.myElements.get(row).isSeparator() && row > 0 && this.myElements.get(row - 1).isSeparator()) {
                DirDiffElementImpl el = this.myElements.get(row - 1);
                if (removeFromTree) {
                    el.getParentNode().remove(el.getNode());
                }
                this.myElements.remove(row - 1);
                start2 = row - 1;
            }
            this.fireTableRowsDeleted(start2, row);
        }
    }

    public void performDelete(@NotNull DirDiffElementImpl element2) {
        if (element2 == null) {
            DirDiffTableModel.$$$reportNull$$$0(6);
        }
        DiffElement source = element2.getSource();
        DiffElement target2 = element2.getTarget();
        LOG.assertTrue(source == null || target2 == null);
        if (source instanceof AsyncDiffElement || target2 instanceof AsyncDiffElement) {
            ((AsyncDiffElement)((Object)(source != null ? source : target2))).deleteAsync().onError(error -> this.reportException(error != null ? error.getMessage() : null)).onSuccess(result2 -> {
                if (!this.myDisposed && this.myElements.contains(element2)) {
                    this.removeElement(element2, true);
                }
            });
        } else {
            if (this.myElements.contains(element2)) {
                this.removeElement(element2, true);
            }
            WriteAction.run(() -> (source != null ? source : target2).delete());
        }
    }

    public void synchronizeSelected() {
        List<DirDiffElementImpl> selectedElements = this.getSelectedElements();
        if (!this.checkCanDelete(selectedElements)) {
            return;
        }
        this.rememberSelection();
        for (DirDiffElementImpl element2 : selectedElements) {
            this.syncElement(element2);
        }
        this.restoreSelection();
    }

    private void restoreSelection() {
        if (this.mySelectionConfig != null) {
            this.mySelectionConfig.restore();
        }
    }

    public void synchronizeAll() {
        ArrayList<DirDiffElementImpl> elements2 = new ArrayList<DirDiffElementImpl>(this.myElements);
        if (!this.checkCanDelete(elements2)) {
            return;
        }
        for (DirDiffElementImpl element2 : elements2) {
            this.syncElement(element2);
        }
        this.selectFirstRow();
    }

    private boolean checkCanDelete(List<DirDiffElementImpl> elements2) {
        if (WarnOnDeletion.isWarnWhenDeleteItems()) {
            int count = 0;
            for (DirDiffElementImpl element2 : elements2) {
                if (element2.getOperation() != DirDiffOperation.DELETE) continue;
                ++count;
            }
            if (count > 0 && !this.confirmDeletion(count)) {
                return false;
            }
        }
        return true;
    }

    private boolean confirmDeletion(int count) {
        return ((MessageDialogBuilder.YesNo)((MessageDialogBuilder.YesNo)((MessageDialogBuilder.YesNo)((MessageDialogBuilder.YesNo)MessageDialogBuilder.yesNo(DiffBundle.message("confirm.delete", new Object[0]), DiffBundle.message("delete.0.items", count)).project(this.myProject)).yesText(CommonBundle.message("button.delete", new Object[0]))).noText(CommonBundle.getCancelButtonText())).doNotAsk(new DialogWrapper.DoNotAskOption(){

            @Override
            public boolean isToBeShown() {
                return WarnOnDeletion.isWarnWhenDeleteItems();
            }

            @Override
            public void setToBeShown(boolean value2, int exitCode) {
                WarnOnDeletion.setWarnWhenDeleteItems(value2);
            }

            @Override
            public boolean canBeHidden() {
                return true;
            }

            @Override
            public boolean shouldSaveOptionsOnCancel() {
                return true;
            }

            @Override
            @NotNull
            public String getDoNotShowMessage() {
                String string = DiffBundle.message("do.not.ask.me.again", new Object[0]);
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/dir/DirDiffTableModel$1", "getDoNotShowMessage"));
            }
        })).show() == 0;
    }

    private void syncElement(DirDiffElementImpl element2) {
        DirDiffOperation operation = element2.getOperation();
        if (operation == null) {
            return;
        }
        switch (operation) {
            case COPY_TO: {
                this.performCopyTo(element2);
                break;
            }
            case COPY_FROM: {
                this.performCopyFrom(element2);
                break;
            }
            case DELETE: {
                this.performDelete(element2);
                break;
            }
        }
    }

    public void rememberSelection() {
        this.mySelectionConfig = new TableSelectionConfig();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/diff/impl/dir/DirDiffTableModel";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/diff/impl/dir/DirDiffTableModel";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getColumnType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setReplacement";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "performCopyFrom";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "performDelete";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public class TableSelectionConfig {
        private final int selectedRow;
        private final int rowCount;

        TableSelectionConfig() {
            this.selectedRow = DirDiffTableModel.this.myTable.getSelectedRow();
            this.rowCount = DirDiffTableModel.this.myTable.getRowCount();
        }

        void restore() {
            DirDiffElementImpl el;
            int newRowCount = DirDiffTableModel.this.myTable.getRowCount();
            if (newRowCount == 0) {
                return;
            }
            int row = Math.min(newRowCount < this.rowCount ? this.selectedRow : this.selectedRow + 1, newRowCount - 1);
            DirDiffElementImpl element2 = DirDiffTableModel.this.getElementAt(row);
            if (element2 != null && element2.isSeparator()) {
                row = DirDiffTableModel.this.getElementAt(row + 1) != null ? ++row : --row;
            }
            row = (el = DirDiffTableModel.this.getElementAt(row)) == null || el.isSeparator() ? 0 : row;
            DirDiffTableModel.this.myTable.getSelectionModel().setSelectionInterval(row, row);
            TableUtil.scrollSelectionToVisible(DirDiffTableModel.this.myTable);
        }
    }

    class Updater
    extends Thread {
        private final JBLoadingPanel myLoadingPanel;
        private final int mySleep;

        Updater(JBLoadingPanel loadingPanel, int sleep) {
            super("Loading Updater");
            this.myLoadingPanel = loadingPanel;
            this.mySleep = sleep;
        }

        @Override
        public void run() {
            if (!DirDiffTableModel.this.myDisposed && this.myLoadingPanel.isLoading()) {
                TimeoutUtil.sleep(this.mySleep);
                ApplicationManager.getApplication().invokeLater(() -> {
                    String s = (String)DirDiffTableModel.this.text.get();
                    if (s != null && this.myLoadingPanel.isLoading()) {
                        this.myLoadingPanel.setLoadingText(s);
                    }
                }, ModalityState.stateForComponent(this.myLoadingPanel));
                DirDiffTableModel.this.myUpdater = new Updater(this.myLoadingPanel, this.mySleep);
                DirDiffTableModel.this.myUpdater.start();
            } else {
                DirDiffTableModel.this.myUpdater = null;
            }
        }
    }

    public static enum ColumnType {
        OPERATION,
        NAME,
        SIZE,
        DATE;

    }
}

