/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.fragments;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.impl.fragments.Fragment;
import com.intellij.openapi.diff.impl.fragments.FragmentHighlighter;
import com.intellij.openapi.diff.impl.fragments.LineFragment;
import com.intellij.openapi.diff.impl.highlighting.FragmentSide;
import com.intellij.openapi.diff.impl.util.TextDiffTypeEnum;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;

public class InlineFragment
implements Fragment {
    private static final Logger LOG = Logger.getInstance(InlineFragment.class);
    private final TextRange myRange1;
    private final TextRange myRange2;
    private final TextDiffTypeEnum myType;

    public InlineFragment(TextDiffTypeEnum type, TextRange range1, TextRange range2) {
        this.myType = type;
        this.myRange1 = range1;
        this.myRange2 = range2;
    }

    @Override
    public TextDiffTypeEnum getType() {
        return this.myType;
    }

    @Override
    public TextRange getRange(FragmentSide side) {
        if (side == FragmentSide.SIDE1) {
            return this.myRange1;
        }
        if (side == FragmentSide.SIDE2) {
            return this.myRange2;
        }
        throw new IllegalArgumentException(String.valueOf((Object)side));
    }

    @Override
    public Fragment shift(TextRange range1, TextRange range2, int startingLine1, int startingLine2) {
        return new InlineFragment(this.myType, LineFragment.shiftRange(range1, this.myRange1), LineFragment.shiftRange(range2, this.myRange2));
    }

    @Override
    public void highlight(FragmentHighlighter fragmentHighlighter) {
        fragmentHighlighter.highlightInline(this);
    }

    @Override
    public Fragment getSubfragmentAt(int offset, FragmentSide side, Condition<? super Fragment> condition2) {
        LOG.assertTrue(this.getRange(side).getStartOffset() <= offset && offset < this.getRange(side).getEndOffset() && condition2.value(this));
        return this;
    }
}

