/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.mergeTool;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.undo.DocumentReference;
import com.intellij.openapi.command.undo.DocumentReferenceManager;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Deprecated
public interface MergeVersion {
    public Document createWorkingDocument(Project var1);

    public void applyText(@NotNull String var1, Project var2);

    @Nullable
    public VirtualFile getFile();

    public byte[] getBytes() throws IOException;

    public FileType getContentType();

    public void restoreOriginalContent(Project var1);

    public static class MergeDocumentVersion
    implements MergeVersion {
        private static final Logger LOG = Logger.getInstance(MergeDocumentVersion.class);
        protected final Document myDocument;
        private final String myOriginalText;
        private String myTextBeforeMerge;

        public MergeDocumentVersion(Document document, String originalText) {
            LOG.assertTrue(originalText != null, "text should not be null");
            LOG.assertTrue(document != null, "document should not be null");
            LOG.assertTrue(document.isWritable(), "document should be writable");
            this.myDocument = document;
            this.myOriginalText = originalText;
        }

        public String getOriginalText() {
            return this.myOriginalText;
        }

        @Override
        public Document createWorkingDocument(Project project2) {
            Document workingDocument = this.myDocument;
            workingDocument.setReadOnly(false);
            DocumentReference ref = DocumentReferenceManager.getInstance().create(workingDocument);
            this.myTextBeforeMerge = this.myDocument.getText();
            ApplicationManager.getApplication().runWriteAction(() -> {
                UndoManager undoManager;
                MergeDocumentVersion.setDocumentText(workingDocument, this.myOriginalText, DiffBundle.message("message.init.merge.content.command", new Object[0]), project2);
                if (project2 != null && (undoManager = UndoManager.getInstance(project2)) != null) {
                    undoManager.nonundoableActionPerformed(ref, false);
                }
            });
            return workingDocument;
        }

        @Override
        public void applyText(@NotNull String text2, Project project2) {
            if (text2 == null) {
                MergeDocumentVersion.$$$reportNull$$$0(0);
            }
            ApplicationManager.getApplication().runWriteAction(() -> CommandProcessor.getInstance().executeCommand(project2, () -> this.doApplyText(text2, project2), DiffBundle.message("message.finish.merge.content.command", new Object[0]), null));
        }

        protected void doApplyText(@NotNull String text2, Project project2) {
            if (text2 == null) {
                MergeDocumentVersion.$$$reportNull$$$0(1);
            }
            MergeDocumentVersion.setDocumentText(this.myDocument, text2, DiffBundle.message("save.merge.result.command.name", new Object[0]), project2);
            FileDocumentManager.getInstance().saveDocument(this.myDocument);
        }

        @Override
        public void restoreOriginalContent(Project project2) {
            ApplicationManager.getApplication().runWriteAction(() -> this.doRestoreOriginalContent(project2));
        }

        protected void doRestoreOriginalContent(@Nullable Project project2) {
            MergeDocumentVersion.setDocumentText(this.myDocument, this.myTextBeforeMerge, "", project2);
        }

        @Override
        @Nullable
        public VirtualFile getFile() {
            return FileDocumentManager.getInstance().getFile(this.myDocument);
        }

        @Override
        public byte[] getBytes() throws IOException {
            VirtualFile file2 = this.getFile();
            return file2 != null ? file2.contentsToByteArray() : this.myDocument.getText().getBytes(StandardCharsets.UTF_8);
        }

        @Override
        public FileType getContentType() {
            VirtualFile file2 = this.getFile();
            if (file2 == null) {
                return FileTypes.PLAIN_TEXT;
            }
            return file2.getFileType();
        }

        private static void setDocumentText(@NotNull Document document, @NotNull String text2, @Nullable String name, @Nullable Project project2) {
            if (document == null) {
                MergeDocumentVersion.$$$reportNull$$$0(2);
            }
            if (text2 == null) {
                MergeDocumentVersion.$$$reportNull$$$0(3);
            }
            CommandProcessor.getInstance().executeCommand(project2, () -> document.replaceString(0, document.getTextLength(), StringUtil.convertLineSeparators(text2)), name, null);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "document";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/diff/impl/mergeTool/MergeVersion$MergeDocumentVersion";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "applyText";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "doApplyText";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setDocumentText";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

