/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor;

import com.intellij.codeInsight.editorActions.TextBlockTransferableData;
import com.intellij.openapi.diagnostic.Logger;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CaretStateTransferableData
implements TextBlockTransferableData {
    private static final Logger LOG = Logger.getInstance(CaretStateTransferableData.class);
    public static final DataFlavor FLAVOR = new DataFlavor(CaretStateTransferableData.class, "Caret state");
    public final int[] startOffsets;
    public final int[] endOffsets;

    public CaretStateTransferableData(int @NotNull [] startOffsets, int @NotNull [] endOffsets) {
        if (startOffsets == null) {
            CaretStateTransferableData.$$$reportNull$$$0(0);
        }
        if (endOffsets == null) {
            CaretStateTransferableData.$$$reportNull$$$0(1);
        }
        this.startOffsets = startOffsets;
        this.endOffsets = endOffsets;
    }

    @Override
    public DataFlavor getFlavor() {
        return FLAVOR;
    }

    @Override
    public int getOffsetCount() {
        return this.startOffsets.length + this.endOffsets.length;
    }

    @Override
    public int getOffsets(int[] offsets2, int index) {
        System.arraycopy(this.startOffsets, 0, offsets2, index, this.startOffsets.length);
        System.arraycopy(this.endOffsets, 0, offsets2, index + this.startOffsets.length, this.endOffsets.length);
        return index + this.getOffsetCount();
    }

    @Override
    public int setOffsets(int[] offsets2, int index) {
        System.arraycopy(offsets2, index, this.startOffsets, 0, this.startOffsets.length);
        System.arraycopy(offsets2, index + this.startOffsets.length, this.endOffsets, 0, this.endOffsets.length);
        return index + this.getOffsetCount();
    }

    public int getCaretCount() {
        return this.startOffsets.length;
    }

    @Nullable
    public static CaretStateTransferableData getFrom(Transferable t) {
        try {
            return t.isDataFlavorSupported(FLAVOR) ? (CaretStateTransferableData)t.getTransferData(FLAVOR) : null;
        }
        catch (Exception e) {
            LOG.error(e);
            return null;
        }
    }

    public static boolean areEquivalent(@Nullable CaretStateTransferableData d1, @Nullable CaretStateTransferableData d2) {
        return (d1 == null || d1.getCaretCount() == 1) && (d2 == null || d2.getCaretCount() == 1) || d1 != null && d2 != null && Arrays.equals(d1.startOffsets, d2.startOffsets) && Arrays.equals(d1.endOffsets, d2.endOffsets);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "startOffsets";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "endOffsets";
                break;
            }
        }
        objectArray[1] = "com/intellij/openapi/editor/CaretStateTransferableData";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

