/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;

public class EditorCoreUtil {
    public static void indentLine(Project project2, @NotNull Editor editor, int lineNumber, int indent, boolean shouldUseSmartTabs) {
        if (editor == null) {
            EditorCoreUtil.$$$reportNull$$$0(0);
        }
        int caretOffset = editor.getCaretModel().getOffset();
        int newCaretOffset = EditorCoreUtil.indentLine(project2, editor, lineNumber, indent, caretOffset, shouldUseSmartTabs);
        editor.getCaretModel().moveToOffset(newCaretOffset);
    }

    public static int indentLine(Project project2, @NotNull Editor editor, int lineNumber, int indent, int caretOffset, boolean shouldUseSmartTabs) {
        int newCaretOffset;
        if (editor == null) {
            EditorCoreUtil.$$$reportNull$$$0(1);
        }
        EditorSettings editorSettings = editor.getSettings();
        int tabSize = editorSettings.getTabSize(project2);
        Document document = editor.getDocument();
        CharSequence text2 = document.getImmutableCharSequence();
        int spacesEnd = 0;
        int lineStart = 0;
        int lineEnd = 0;
        int tabsEnd = 0;
        if (lineNumber < document.getLineCount()) {
            lineStart = document.getLineStartOffset(lineNumber);
            lineEnd = document.getLineEndOffset(lineNumber);
            boolean inTabs = true;
            for (spacesEnd = lineStart; spacesEnd <= lineEnd && spacesEnd != lineEnd; ++spacesEnd) {
                char c = text2.charAt(spacesEnd);
                if (c == '\t') continue;
                if (inTabs) {
                    inTabs = false;
                    tabsEnd = spacesEnd;
                }
                if (c != ' ') break;
            }
            if (inTabs) {
                tabsEnd = lineEnd;
            }
        }
        if ((newCaretOffset = caretOffset) >= lineStart && newCaretOffset < lineEnd && spacesEnd == lineEnd) {
            spacesEnd = newCaretOffset;
            tabsEnd = Math.min(spacesEnd, tabsEnd);
        }
        int oldLength = EditorCoreUtil.getSpaceWidthInColumns(text2, lineStart, spacesEnd, tabSize);
        tabsEnd = EditorCoreUtil.getSpaceWidthInColumns(text2, lineStart, tabsEnd, tabSize);
        int newLength = oldLength + indent;
        if (newLength < 0) {
            newLength = 0;
        }
        if ((tabsEnd += indent) < 0) {
            tabsEnd = 0;
        }
        if (!shouldUseSmartTabs) {
            tabsEnd = newLength;
        }
        StringBuilder buf = new StringBuilder(newLength);
        int i = 0;
        while (i < newLength) {
            if (tabSize > 0 && editorSettings.isUseTabCharacter(project2) && i + tabSize <= tabsEnd) {
                buf.append('\t');
                i += tabSize;
                continue;
            }
            buf.append(' ');
            ++i;
        }
        int newSpacesEnd = lineStart + buf.length();
        if (newCaretOffset >= spacesEnd) {
            newCaretOffset += buf.length() - (spacesEnd - lineStart);
        } else if (newCaretOffset >= lineStart && newCaretOffset > newSpacesEnd) {
            newCaretOffset = newSpacesEnd;
        }
        if (buf.length() > 0) {
            if (spacesEnd > lineStart) {
                document.replaceString(lineStart, spacesEnd, buf.toString());
            } else {
                document.insertString(lineStart, buf.toString());
            }
        } else if (spacesEnd > lineStart) {
            document.deleteString(lineStart, spacesEnd);
        }
        return newCaretOffset;
    }

    private static int getSpaceWidthInColumns(CharSequence seq, int startOffset, int endOffset, int tabSize) {
        int result2 = 0;
        for (int i = startOffset; i < endOffset; ++i) {
            if (seq.charAt(i) == '\t') {
                result2 = (result2 / tabSize + 1) * tabSize;
                continue;
            }
            ++result2;
        }
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/editor/EditorCoreUtil", "indentLine"));
    }
}

