/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageExtension;
import com.intellij.openapi.editor.IndentStrategy;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LanguageIndentStrategy
extends LanguageExtension<IndentStrategy> {
    public static final String EP_NAME = "com.intellij.lang.indentStrategy";
    public static final LanguageIndentStrategy INSTANCE = new LanguageIndentStrategy();
    private static final DefaultIndentStrategy DEFAULT_INDENT_STRATEGY = new DefaultIndentStrategy();

    public LanguageIndentStrategy() {
        super(EP_NAME, DEFAULT_INDENT_STRATEGY);
    }

    @NotNull
    public static IndentStrategy getIndentStrategy(@Nullable PsiFile file2) {
        Language language2;
        IndentStrategy strategy;
        if (file2 != null && (strategy = (IndentStrategy)INSTANCE.forLanguage(language2 = file2.getLanguage())) != null) {
            IndentStrategy indentStrategy = strategy;
            if (indentStrategy == null) {
                LanguageIndentStrategy.$$$reportNull$$$0(0);
            }
            return indentStrategy;
        }
        DefaultIndentStrategy defaultIndentStrategy = DEFAULT_INDENT_STRATEGY;
        if (defaultIndentStrategy == null) {
            LanguageIndentStrategy.$$$reportNull$$$0(1);
        }
        return defaultIndentStrategy;
    }

    public static boolean isDefault(IndentStrategy indentStrategy) {
        return indentStrategy == DEFAULT_INDENT_STRATEGY;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/LanguageIndentStrategy", "getIndentStrategy"));
    }

    private static class DefaultIndentStrategy
    implements IndentStrategy {
        private DefaultIndentStrategy() {
        }

        @Override
        public boolean canIndent(int indentationStartOffset, int indentationEndOffset, @NotNull PsiElement element2) {
            if (element2 == null) {
                DefaultIndentStrategy.$$$reportNull$$$0(0);
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/editor/LanguageIndentStrategy$DefaultIndentStrategy", "canIndent"));
        }
    }
}

