/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.actionSystem.EditorWriteActionHandler;
import com.intellij.openapi.editor.actionSystem.LatencyAwareEditorAction;
import com.intellij.openapi.editor.actions.EditorActionUtil;
import com.intellij.openapi.editor.actions.TextComponentEditorAction;
import com.intellij.openapi.editor.ex.util.EditorUIUtil;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.util.DocumentUtil;
import org.jetbrains.annotations.NotNull;

public class BackspaceAction
extends TextComponentEditorAction
implements LatencyAwareEditorAction,
HintManagerImpl.ActionToIgnore {
    public BackspaceAction() {
        super(new Handler());
    }

    private static void doBackSpaceAtCaret(@NotNull Editor editor) {
        if (editor == null) {
            BackspaceAction.$$$reportNull$$$0(0);
        }
        VisualPosition caretPosition = editor.getCaretModel().getVisualPosition();
        if (caretPosition.column > 0 && editor.getInlayModel().hasInlineElementAt(new VisualPosition(caretPosition.line, caretPosition.column - 1))) {
            editor.getCaretModel().moveCaretRelatively(-1, 0, false, false, EditorUtil.isCurrentCaretPrimary(editor));
            return;
        }
        int lineNumber = editor.getCaretModel().getLogicalPosition().line;
        int colNumber = editor.getCaretModel().getLogicalPosition().column;
        Document document = editor.getDocument();
        int offset = editor.getCaretModel().getOffset();
        if (colNumber > 0) {
            if (EditorModificationUtil.calcAfterLineEnd(editor) > 0) {
                int columnShift = -1;
                editor.getCaretModel().moveCaretRelatively(columnShift, 0, false, false, true);
            } else {
                EditorModificationUtil.scrollToCaret(editor);
                editor.getSelectionModel().removeSelection();
                FoldRegion region = editor.getFoldingModel().getCollapsedRegionAtOffset(offset - 1);
                if (region != null && region.shouldNeverExpand()) {
                    document.deleteString(region.getStartOffset(), region.getEndOffset());
                    editor.getCaretModel().moveToOffset(region.getStartOffset());
                } else {
                    document.deleteString(DocumentUtil.getPreviousCodePointOffset(document, offset), offset);
                }
            }
        } else if (lineNumber > 0) {
            int separatorLength = document.getLineSeparatorLength(lineNumber - 1);
            int lineEnd = document.getLineEndOffset(lineNumber - 1) + separatorLength;
            document.deleteString(lineEnd - separatorLength, lineEnd);
            editor.getCaretModel().moveToOffset(lineEnd - separatorLength);
            EditorModificationUtil.scrollToCaret(editor);
            editor.getSelectionModel().removeSelection();
            CommandProcessor commandProcessor = CommandProcessor.getInstance();
            commandProcessor.setCurrentCommandGroupId(null);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/editor/actions/BackspaceAction", "doBackSpaceAtCaret"));
    }

    private static class Handler
    extends EditorWriteActionHandler {
        private Handler() {
            super(true);
        }

        @Override
        public void executeWriteAction(Editor editor, Caret caret, DataContext dataContext) {
            EditorUIUtil.hideCursorInEditor(editor);
            CommandProcessor.getInstance().setCurrentCommandGroupId(EditorActionUtil.DELETE_COMMAND_GROUP);
            if (editor instanceof EditorWindow) {
                editor = ((EditorWindow)editor).getDelegate();
            }
            BackspaceAction.doBackSpaceAtCaret(editor);
        }
    }
}

