/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorAction;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actions.EditorActionUtil;
import com.intellij.util.DocumentUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BackwardParagraphAction
extends EditorAction {
    public BackwardParagraphAction() {
        super(new Handler(false));
    }

    static class Handler
    extends EditorActionHandler {
        private final boolean myWithSelection;

        Handler(boolean withSelection) {
            super(true);
            this.myWithSelection = withSelection;
        }

        @Override
        protected void doExecute(@NotNull Editor editor, @Nullable Caret caret, DataContext dataContext) {
            boolean atLineStart;
            if (editor == null) {
                Handler.$$$reportNull$$$0(0);
            }
            assert (caret != null);
            Document document = editor.getDocument();
            int currentLine = caret.getLogicalPosition().line;
            boolean bl = atLineStart = caret.getLogicalPosition().column == 0;
            if (DocumentUtil.isLineEmpty(document, currentLine) || atLineStart) {
                while (--currentLine >= 0 && DocumentUtil.isLineEmpty(document, currentLine)) {
                }
            }
            while (--currentLine >= 0 && !DocumentUtil.isLineEmpty(document, currentLine)) {
            }
            int targetOffset = 0;
            if (currentLine >= 0) {
                int targetLineEnd;
                int targetLineStart = document.getLineStartOffset(currentLine);
                targetOffset = targetLineStart == (targetLineEnd = document.getLineEndOffset(currentLine)) ? targetLineStart : document.getLineStartOffset(currentLine + 1);
            }
            EditorActionUtil.moveCaret(caret, targetOffset, this.myWithSelection);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/editor/actions/BackwardParagraphAction$Handler", "doExecute"));
        }
    }
}

