/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.CommonBundle;
import com.intellij.icons.AllIcons;
import com.intellij.ide.ui.SplitterProportionsDataImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.JBColor;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBList;
import com.intellij.ui.speedSearch.FilteringListModel;
import com.intellij.ui.speedSearch.ListWithFilter;
import com.intellij.ui.speedSearch.SpeedSearchSupply;
import com.intellij.ui.speedSearch.SpeedSearchUtil;
import com.intellij.util.Alarm;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ContentChooser<Data>
extends DialogWrapper {
    @NotNull
    @NonNls
    public static final String RETURN_SYMBOL = "\u23ce";
    private List<Data> myAllContents;
    private Editor myViewer;
    private final boolean myUseIdeaEditor;
    private final JBList<Item> myList;
    private final JBSplitter mySplitter;
    private final Project myProject;
    private final boolean myAllowMultipleSelections;
    private final Alarm myUpdateAlarm;
    private Icon myListEntryIcon = AllIcons.FileTypes.Text;
    private boolean myUseNumbering = true;

    public ContentChooser(Project project2, String title, boolean useIdeaEditor) {
        this(project2, title, useIdeaEditor, false);
    }

    public ContentChooser(Project project2, String title, boolean useIdeaEditor, boolean allowMultipleSelections) {
        super(project2, true);
        this.myProject = project2;
        this.myUseIdeaEditor = useIdeaEditor;
        this.myAllowMultipleSelections = allowMultipleSelections;
        this.myUpdateAlarm = new Alarm(this.getDisposable());
        this.mySplitter = new JBSplitter(true, 0.3f);
        this.mySplitter.setSplitterProportionKey(this.getDimensionServiceKey() + ".splitter");
        this.myList = new JBList<Item>(new CollectionListModel<Item>(new Item[0])){

            @Override
            protected void doCopyToClipboardAction() {
                String text2 = ContentChooser.this.getSelectedText();
                if (!text2.isEmpty()) {
                    CopyPasteManager.getInstance().setContents(new StringSelection(text2));
                }
            }
        };
        this.setOKButtonText(CommonBundle.getOkButtonText());
        this.setTitle(title);
        this.init();
    }

    public void setContentIcon(@Nullable Icon icon2) {
        this.myListEntryIcon = icon2;
    }

    public void setSplitterOrientation(boolean vertical) {
        this.mySplitter.setOrientation(vertical);
    }

    public void setUseNumbering(boolean useNumbering) {
        this.myUseNumbering = useNumbering;
    }

    @Override
    public JComponent getPreferredFocusedComponent() {
        return this.myList;
    }

    @Override
    protected JComponent createCenterPanel() {
        int selectionMode = this.myAllowMultipleSelections ? 2 : 0;
        this.myList.setSelectionMode(selectionMode);
        if (this.myUseIdeaEditor) {
            EditorColorsScheme scheme = EditorColorsManager.getInstance().getGlobalScheme();
            this.myList.setFont(scheme.getFont(EditorFontType.PLAIN));
            Color fg = ObjectUtils.chooseNotNull(scheme.getDefaultForeground(), new JBColor(UIUtil::getListForeground));
            Color bg = ObjectUtils.chooseNotNull(scheme.getDefaultBackground(), new JBColor(UIUtil::getListBackground));
            this.myList.setForeground(fg);
            this.myList.setBackground(bg);
        }
        new DoubleClickListener(){

            @Override
            protected boolean onDoubleClick(MouseEvent e) {
                ContentChooser.this.close(0);
                return true;
            }
        }.installOn(this.myList);
        final MyListCellRenderer renderer = new MyListCellRenderer();
        this.myList.setCellRenderer(renderer);
        this.myList.addKeyListener(new KeyListener(){
            boolean doConsume;

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 127) {
                    int newSelectionIndex = -1;
                    for (Object o : ContentChooser.this.myList.getSelectedValuesList()) {
                        int i = ((Item)o).index;
                        ContentChooser.this.removeContentAt(ContentChooser.this.myAllContents.get(i));
                        if (newSelectionIndex >= 0) continue;
                        newSelectionIndex = i;
                    }
                    ContentChooser.this.rebuildListContent();
                    if (ContentChooser.this.myAllContents.isEmpty()) {
                        ContentChooser.this.close(1);
                        return;
                    }
                    newSelectionIndex = Math.min(newSelectionIndex, ContentChooser.this.myAllContents.size() - 1);
                    ContentChooser.this.myList.setSelectedIndex(newSelectionIndex);
                } else if (e.getKeyCode() == 10) {
                    ContentChooser.this.doOKAction();
                } else if (ContentChooser.this.myUseNumbering) {
                    SpeedSearchSupply supply = SpeedSearchSupply.getSupply(ContentChooser.this.myList);
                    if (supply != null && supply.isPopupActive()) {
                        return;
                    }
                    char aChar = e.getKeyChar();
                    if (aChar >= '0' && aChar <= '9') {
                        int idx;
                        int n = idx = aChar == '0' ? 9 : aChar - 49;
                        if (idx < ContentChooser.this.myAllContents.size()) {
                            ContentChooser.this.myList.setSelectedIndex(idx);
                            e.consume();
                            this.doConsume = true;
                            ApplicationManager.getApplication().invokeLater(() -> ContentChooser.this.doOKAction());
                        }
                    }
                }
            }

            @Override
            public void keyTyped(KeyEvent e) {
                if (this.doConsume) {
                    e.consume();
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (this.doConsume) {
                    e.consume();
                }
            }
        });
        this.mySplitter.setFirstComponent(ListWithFilter.wrap(this.myList, ScrollPaneFactory.createScrollPane(this.myList), o -> o.getShortText(renderer.previewChars), true));
        this.mySplitter.setSecondComponent(new JPanel());
        this.mySplitter.getFirstComponent().addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                FontMetrics metrics = ContentChooser.this.myList.getFontMetrics(ContentChooser.this.myList.getFont());
                int charWidth = metrics.charWidth('i');
                renderer.previewChars = ContentChooser.this.myList.getParent().getParent().getWidth() / charWidth + 10;
            }
        });
        this.rebuildListContent();
        ScrollingUtil.installActions(this.myList);
        ScrollingUtil.ensureSelectionExists(this.myList);
        this.updateViewerForSelection();
        this.myList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (ContentChooser.this.myUpdateAlarm.isDisposed()) {
                    return;
                }
                ContentChooser.this.myUpdateAlarm.cancelAllRequests();
                ContentChooser.this.myUpdateAlarm.addRequest(() -> ContentChooser.this.updateViewerForSelection(), 100);
            }
        });
        this.mySplitter.setPreferredSize(JBUI.size(500, 500));
        SplitterProportionsDataImpl d = new SplitterProportionsDataImpl();
        d.externalizeToDimensionService(this.getClass().getName());
        d.restoreSplitterProportions(this.mySplitter);
        return this.mySplitter;
    }

    protected abstract void removeContentAt(Data var1);

    @Override
    protected String getDimensionServiceKey() {
        return this.getClass().getName();
    }

    @Override
    protected void doOKAction() {
        if (this.getSelectedIndex() < 0) {
            return;
        }
        super.doOKAction();
    }

    private void updateViewerForSelection() {
        if (this.myAllContents.isEmpty()) {
            return;
        }
        String fullString = this.getSelectedText();
        if (this.myViewer != null) {
            EditorFactory.getInstance().releaseEditor(this.myViewer);
        }
        if (this.myUseIdeaEditor) {
            this.myViewer = this.createIdeaEditor(fullString);
            JComponent component2 = this.myViewer.getComponent();
            component2.setPreferredSize(JBUI.size(300, 500));
            this.mySplitter.setSecondComponent(component2);
        } else {
            JTextArea textArea = new JTextArea(fullString);
            textArea.setRows(3);
            textArea.setWrapStyleWord(true);
            textArea.setLineWrap(true);
            textArea.setSelectionStart(0);
            textArea.setSelectionEnd(textArea.getText().length());
            textArea.setEditable(false);
            this.mySplitter.setSecondComponent(ScrollPaneFactory.createScrollPane(textArea));
        }
        this.mySplitter.revalidate();
    }

    protected Editor createIdeaEditor(String text2) {
        Document doc = EditorFactory.getInstance().createDocument(text2);
        Editor editor = EditorFactory.getInstance().createViewer(doc, this.myProject);
        editor.getSettings().setFoldingOutlineShown(false);
        editor.getSettings().setLineNumbersShown(false);
        editor.getSettings().setLineMarkerAreaShown(false);
        editor.getSettings().setIndentGuidesShown(false);
        return editor;
    }

    @Override
    public void dispose() {
        super.dispose();
        SplitterProportionsDataImpl d = new SplitterProportionsDataImpl();
        d.externalizeToDimensionService(this.getClass().getName());
        d.saveSplitterProportions(this.mySplitter);
        if (this.myViewer != null) {
            EditorFactory.getInstance().releaseEditor(this.myViewer);
            this.myViewer = null;
        }
    }

    private void rebuildListContent() {
        ArrayList<Item> items = new ArrayList<Item>();
        int index = 0;
        ArrayList<Data> contents = new ArrayList<Data>(this.getContents());
        for (Object content2 : contents) {
            String longText = this.getStringRepresentationFor(content2);
            if (!StringUtil.isEmpty(longText)) {
                items.add(new Item(index, longText));
            }
            ++index;
        }
        this.myAllContents = contents;
        FilteringListModel listModel = (FilteringListModel)this.myList.getModel();
        ((CollectionListModel)listModel.getOriginalModel()).removeAll();
        listModel.addAll(items);
        ListWithFilter listWithFilter = ComponentUtil.getParentOfType(ListWithFilter.class, this.myList);
        if (listWithFilter != null) {
            listWithFilter.getSpeedSearch().update();
            if (listModel.getSize() == 0) {
                listWithFilter.resetFilter();
            }
        }
    }

    @Nullable
    protected abstract String getStringRepresentationFor(Data var1);

    @NotNull
    protected abstract List<Data> getContents();

    public int getSelectedIndex() {
        Item o = (Item)this.myList.getSelectedValue();
        return o == null ? -1 : o.index;
    }

    public void setSelectedIndex(int index) {
        this.myList.setSelectedIndex(index);
        ScrollingUtil.ensureIndexIsVisible(this.myList, index, 0);
        this.updateViewerForSelection();
    }

    @NotNull
    public List<Data> getSelectedContents() {
        List<Object> list2 = JBIterable.from(this.myList.getSelectedValuesList()).map(o -> this.myAllContents.get(o.index)).toList();
        if (list2 == null) {
            ContentChooser.$$$reportNull$$$0(0);
        }
        return list2;
    }

    @NotNull
    public List<Data> getAllContents() {
        List<Data> list2 = this.myAllContents;
        if (list2 == null) {
            ContentChooser.$$$reportNull$$$0(1);
        }
        return list2;
    }

    @NotNull
    public String getSelectedText() {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Object o : this.myList.getSelectedValuesList()) {
            if (first) {
                first = false;
            } else {
                sb.append("\n");
            }
            String s = ((Item)o).longText;
            sb.append(StringUtil.convertLineSeparators(s));
        }
        String string = sb.toString();
        if (string == null) {
            ContentChooser.$$$reportNull$$$0(2);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/openapi/editor/actions/ContentChooser";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedContents";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllContents";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedText";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class Item {
        final int index;
        final String longText;
        String shortText = "";
        boolean trimmed;

        Item(int index, String longText) {
            this.index = index;
            this.longText = longText;
        }

        String getShortText(int maxChars) {
            boolean hasSlashR;
            int len = this.shortText.length();
            if (len > 0 && !this.trimmed) {
                return this.shortText;
            }
            if (len >= maxChars && (len - maxChars) * 10 / len == 0) {
                return this.shortText;
            }
            if (len > maxChars) {
                this.shortText = StringUtil.first(this.shortText, maxChars, true);
                this.trimmed = true;
                return this.shortText;
            }
            boolean bl = hasSlashR = StringUtil.indexOf((CharSequence)this.longText, '\r', 0, Math.min(this.longText.length(), maxChars * 2 + 1)) > 0;
            if (!hasSlashR) {
                String s = StringUtil.first(this.longText, maxChars, true);
                this.trimmed = s != this.longText;
                this.shortText = StringUtil.convertLineSeparators(s, ContentChooser.RETURN_SYMBOL);
            } else {
                String s = StringUtil.first(this.longText, maxChars * 2 + 1, false);
                String s2 = StringUtil.convertLineSeparators(s, ContentChooser.RETURN_SYMBOL);
                this.shortText = StringUtil.first(s2, maxChars, true);
                this.trimmed = s != this.longText || s2 != this.shortText;
            }
            return this.shortText;
        }
    }

    private class MyListCellRenderer
    extends ColoredListCellRenderer<Item> {
        int previewChars = 80;

        private MyListCellRenderer() {
        }

        @Override
        protected void customizeCellRenderer(@NotNull JList list2, Item value2, int index, boolean selected2, boolean hasFocus) {
            if (list2 == null) {
                MyListCellRenderer.$$$reportNull$$$0(0);
            }
            this.setIcon(ContentChooser.this.myListEntryIcon);
            if (ContentChooser.this.myUseIdeaEditor && ContentChooser.this.myUseNumbering) {
                int max = list2.getModel().getSize();
                String indexString = String.valueOf(index + 1);
                int count = String.valueOf(max).length() - indexString.length();
                char[] spaces = new char[count];
                Arrays.fill(spaces, ' ');
                String prefix = indexString + new String(spaces) + "  ";
                this.append(prefix, SimpleTextAttributes.GRAYED_ATTRIBUTES, false);
            }
            String text2 = value2.getShortText(this.previewChars);
            this.append(text2, SimpleTextAttributes.REGULAR_ATTRIBUTES, true);
            SpeedSearchUtil.applySpeedSearchHighlighting(list2, this, true, selected2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/openapi/editor/actions/ContentChooser$MyListCellRenderer", "customizeCellRenderer"));
        }
    }
}

