/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorWriteActionHandler;
import com.intellij.openapi.editor.actions.KillRingUtil;
import com.intellij.openapi.editor.actions.TextComponentEditorAction;
import org.jetbrains.annotations.Nullable;

public class CutLineBackwardAction
extends TextComponentEditorAction {
    public CutLineBackwardAction() {
        super(new Handler());
    }

    static class Handler
    extends EditorWriteActionHandler {
        Handler() {
        }

        @Override
        public void executeWriteAction(Editor editor, @Nullable Caret caret, DataContext dataContext) {
            Document document = editor.getDocument();
            int caretOffset = editor.getCaretModel().getOffset();
            if (caretOffset <= 0) {
                return;
            }
            int caretLine = document.getLineNumber(caretOffset);
            int start2 = caretLine <= 0 ? 0 : document.getLineStartOffset(caretLine - 1);
            KillRingUtil.cut(editor, start2, caretOffset);
        }
    }
}

