/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.actionSystem.EditorWriteActionHandler;
import com.intellij.openapi.editor.actions.EditorActionUtil;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.util.TextRange;

class DeleteToWordBoundaryHandler
extends EditorWriteActionHandler {
    private final boolean myIsUntilStart;
    private final boolean myNegateCamelMode;

    DeleteToWordBoundaryHandler(boolean isUntilStart, boolean negateCamelMode) {
        super(true);
        this.myIsUntilStart = isUntilStart;
        this.myNegateCamelMode = negateCamelMode;
    }

    @Override
    public void executeWriteAction(Editor editor, Caret caret, DataContext dataContext) {
        TextRange range2;
        CommandProcessor.getInstance().setCurrentCommandGroupId(EditorActionUtil.DELETE_COMMAND_GROUP);
        CopyPasteManager.getInstance().stopKillRings();
        boolean camelMode = editor.getSettings().isCamelWords();
        if (this.myNegateCamelMode) {
            boolean bl = camelMode = !camelMode;
        }
        if (editor.getSelectionModel().hasSelection()) {
            EditorModificationUtil.deleteSelectedText(editor);
            return;
        }
        TextRange textRange = range2 = this.myIsUntilStart ? EditorActionUtil.getRangeToWordStart(editor, camelMode, true) : EditorActionUtil.getRangeToWordEnd(editor, camelMode, true);
        if (!range2.isEmpty()) {
            editor.getDocument().deleteString(range2.getStartOffset(), range2.getEndOffset());
        }
    }
}

