/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorBundle;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.ScrollingModel;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.actionSystem.EditorAction;
import com.intellij.openapi.editor.actionSystem.EditorWriteActionHandler;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DuplicateAction
extends EditorAction {
    public DuplicateAction() {
        super(new Handler());
    }

    private static void duplicateLineOrSelectedBlockAtCaret(Editor editor) {
        Document document = editor.getDocument();
        CaretModel caretModel = editor.getCaretModel();
        ScrollingModel scrollingModel = editor.getScrollingModel();
        if (editor.getSelectionModel().hasSelection()) {
            int start2 = editor.getSelectionModel().getSelectionStart();
            int end = editor.getSelectionModel().getSelectionEnd();
            String s = document.getCharsSequence().subSequence(start2, end).toString();
            document.insertString(end, s);
            caretModel.moveToOffset(end + s.length());
            scrollingModel.scrollToCaret(ScrollType.RELATIVE);
            editor.getSelectionModel().removeSelection();
            editor.getSelectionModel().setSelection(end, end + s.length());
        } else {
            DuplicateAction.duplicateLinesRange(editor, document, caretModel.getVisualPosition(), caretModel.getVisualPosition());
        }
    }

    @Nullable
    static Couple<Integer> duplicateLinesRange(Editor editor, Document document, VisualPosition rangeStart, VisualPosition rangeEnd) {
        Pair<LogicalPosition, LogicalPosition> lines = EditorUtil.calcSurroundingRange(editor, rangeStart, rangeEnd);
        int offset = editor.getCaretModel().getOffset();
        LogicalPosition lineStart = (LogicalPosition)lines.first;
        LogicalPosition nextLineStart = (LogicalPosition)lines.second;
        int start2 = editor.logicalPositionToOffset(lineStart);
        int end = editor.logicalPositionToOffset(nextLineStart);
        if (end <= start2) {
            return null;
        }
        String s = document.getCharsSequence().subSequence(start2, end).toString();
        int newOffset = end + offset - start2;
        int selectionStart = end;
        if (nextLineStart.line == document.getLineCount() - 1 && nextLineStart.column > 0) {
            s = "\n" + s;
            ++newOffset;
            ++selectionStart;
        }
        document.insertString(end, s);
        editor.getCaretModel().moveToOffset(newOffset);
        editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        return Couple.of(selectionStart, end + s.length());
    }

    @Override
    public void update(Editor editor, Presentation presentation, DataContext dataContext) {
        super.update(editor, presentation, dataContext);
        if (editor.getSelectionModel().hasSelection()) {
            presentation.setText(EditorBundle.message("action.duplicate.selection", new Object[0]), true);
        } else {
            presentation.setText(EditorBundle.message("action.duplicate.line", new Object[0]), true);
        }
    }

    private static class Handler
    extends EditorWriteActionHandler {
        Handler() {
            super(true);
        }

        @Override
        public void executeWriteAction(Editor editor, Caret caret, DataContext dataContext) {
            DuplicateAction.duplicateLineOrSelectedBlockAtCaret(editor);
        }

        @Override
        public boolean isEnabledForCaret(@NotNull Editor editor, @NotNull Caret caret, DataContext dataContext) {
            if (editor == null) {
                Handler.$$$reportNull$$$0(0);
            }
            if (caret == null) {
                Handler.$$$reportNull$$$0(1);
            }
            return !editor.isOneLineMode() || editor.getSelectionModel().hasSelection();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "editor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "caret";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/editor/actions/DuplicateAction$Handler";
            objectArray[2] = "isEnabledForCaret";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

