/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.actionSystem.EditorAction;
import com.intellij.openapi.editor.actionSystem.EditorWriteActionHandler;
import com.intellij.openapi.editor.actions.DuplicateAction;
import com.intellij.openapi.util.Couple;
import com.intellij.util.DocumentUtil;

public class DuplicateLinesAction
extends EditorAction {
    public DuplicateLinesAction() {
        super(new Handler());
    }

    private static class Handler
    extends EditorWriteActionHandler {
        Handler() {
            super(true);
        }

        @Override
        public void executeWriteAction(Editor editor, Caret caret, DataContext dataContext) {
            if (editor.getSelectionModel().hasSelection()) {
                int selStart = editor.getSelectionModel().getSelectionStart();
                int selEnd = editor.getSelectionModel().getSelectionEnd();
                if (selEnd > selStart && DocumentUtil.isAtLineStart(selEnd, editor.getDocument())) {
                    --selEnd;
                }
                VisualPosition rangeStart = editor.offsetToVisualPosition(Math.min(selStart, selEnd));
                VisualPosition rangeEnd = editor.offsetToVisualPosition(Math.max(selStart, selEnd));
                Couple<Integer> copiedRange = DuplicateAction.duplicateLinesRange(editor, editor.getDocument(), rangeStart, rangeEnd);
                if (copiedRange != null) {
                    editor.getSelectionModel().setSelection((Integer)copiedRange.first, (Integer)copiedRange.second);
                }
            } else {
                VisualPosition caretPos = editor.getCaretModel().getVisualPosition();
                DuplicateAction.duplicateLinesRange(editor, editor.getDocument(), caretPos, caretPos);
            }
        }
    }
}

