/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.lang.ASTNode;
import com.intellij.lang.BracePair;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageBraceMatching;
import com.intellij.lang.LanguageExtension;
import com.intellij.lang.PairedBraceMatcher;
import com.intellij.lang.parser.GeneratedParserUtilBase;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.JBIterable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlipCommaIntention
implements IntentionAction {
    @Override
    @NotNull
    public String getText() {
        String string = this.getFamilyName();
        if (string == null) {
            FlipCommaIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public String getFamilyName() {
        return "Flip ','";
    }

    @Override
    public boolean isAvailable(@NotNull Project project2, @NotNull Editor editor, @NotNull PsiFile file2) {
        PsiElement comma;
        if (project2 == null) {
            FlipCommaIntention.$$$reportNull$$$0(1);
        }
        if (editor == null) {
            FlipCommaIntention.$$$reportNull$$$0(2);
        }
        if (file2 == null) {
            FlipCommaIntention.$$$reportNull$$$0(3);
        }
        if ((comma = FlipCommaIntention.currentCommaElement(editor, file2)) == null) {
            return false;
        }
        PsiElement left = FlipCommaIntention.smartAdvance(comma, false);
        PsiElement right = FlipCommaIntention.smartAdvance(comma, true);
        return left != null && right != null && !left.getText().equals(right.getText()) && Flipper.isCanFlip(left, right);
    }

    @Override
    public void invoke(@NotNull Project project2, @NotNull Editor editor, @NotNull PsiFile file2) {
        PsiElement element2;
        if (project2 == null) {
            FlipCommaIntention.$$$reportNull$$$0(4);
        }
        if (editor == null) {
            FlipCommaIntention.$$$reportNull$$$0(5);
        }
        if (file2 == null) {
            FlipCommaIntention.$$$reportNull$$$0(6);
        }
        if ((element2 = FlipCommaIntention.currentCommaElement(editor, file2)) != null) {
            FlipCommaIntention.swapAtComma(element2);
        }
    }

    @Override
    public boolean startInWriteAction() {
        return true;
    }

    private static void swapAtComma(@NotNull PsiElement comma) {
        if (comma == null) {
            FlipCommaIntention.$$$reportNull$$$0(7);
        }
        PsiElement prev = FlipCommaIntention.smartAdvance(comma, false);
        PsiElement next = FlipCommaIntention.smartAdvance(comma, true);
        if (prev != null && next != null) {
            if (Flipper.tryFlip(prev, next)) {
                return;
            }
            FlipCommaIntention.swapViaDocument(comma, prev, next);
        }
    }

    private static void swapViaDocument(@NotNull PsiElement comma, PsiElement prev, PsiElement next) {
        DocumentEx document;
        if (comma == null) {
            FlipCommaIntention.$$$reportNull$$$0(8);
        }
        if ((document = (DocumentEx)comma.getContainingFile().getViewProvider().getDocument()) == null) {
            return;
        }
        String prevText = prev.getText();
        String nextText = next.getText();
        TextRange prevRange = prev.getTextRange();
        TextRange nextRange = next.getTextRange();
        document.replaceString(prevRange.getStartOffset(), prevRange.getEndOffset(), nextText);
        nextRange = nextRange.shiftRight(nextText.length() - prevText.length());
        document.replaceString(nextRange.getStartOffset(), nextRange.getEndOffset(), prevText);
    }

    private static PsiElement currentCommaElement(@NotNull Editor editor, @NotNull PsiFile file2) {
        PsiElement element2;
        if (editor == null) {
            FlipCommaIntention.$$$reportNull$$$0(9);
        }
        if (file2 == null) {
            FlipCommaIntention.$$$reportNull$$$0(10);
        }
        if (!FlipCommaIntention.isComma(element2 = FlipCommaIntention.leftElement(editor, file2)) && !FlipCommaIntention.isComma(element2 = FlipCommaIntention.rightElement(editor, file2))) {
            return null;
        }
        return element2;
    }

    @Nullable
    private static PsiElement leftElement(@NotNull Editor editor, @NotNull PsiFile file2) {
        if (editor == null) {
            FlipCommaIntention.$$$reportNull$$$0(11);
        }
        if (file2 == null) {
            FlipCommaIntention.$$$reportNull$$$0(12);
        }
        return file2.findElementAt(editor.getCaretModel().getOffset() - 1);
    }

    @Nullable
    private static PsiElement rightElement(@NotNull Editor editor, @NotNull PsiFile file2) {
        if (editor == null) {
            FlipCommaIntention.$$$reportNull$$$0(13);
        }
        if (file2 == null) {
            FlipCommaIntention.$$$reportNull$$$0(14);
        }
        return file2.findElementAt(editor.getCaretModel().getOffset());
    }

    private static boolean isComma(@Nullable PsiElement element2) {
        return element2 != null && element2.textMatches(",");
    }

    @NotNull
    private static JBIterable<PsiElement> getSiblings(PsiElement element2, boolean fwd) {
        SyntaxTraverser.ApiEx<PsiElement> api = fwd ? SyntaxTraverser.psiApi() : SyntaxTraverser.psiApiReversed();
        JBIterable<PsiElement> flatSiblings = JBIterable.generate(element2, api::next).skip(1);
        JBIterable<PsiElement> jBIterable = ((SyntaxTraverser)((SyntaxTraverser)SyntaxTraverser.syntaxTraverser(api).withRoots((Iterable<PsiElement>)flatSiblings)).expandAndSkip(e -> api.typeOf((PsiElement)e) == GeneratedParserUtilBase.DUMMY_BLOCK)).traverse();
        if (jBIterable == null) {
            FlipCommaIntention.$$$reportNull$$$0(15);
        }
        return jBIterable;
    }

    private static boolean isFlippable(PsiElement e) {
        if (e instanceof PsiWhiteSpace || e instanceof PsiComment) {
            return false;
        }
        return StringUtil.isNotEmpty(e.getText());
    }

    @Nullable
    private static PsiElement smartAdvance(PsiElement element2, boolean fwd) {
        PsiElement candidate = FlipCommaIntention.getSiblings(element2, fwd).filter(e -> FlipCommaIntention.isFlippable(e)).first();
        if (candidate != null && FlipCommaIntention.isBrace(candidate)) {
            return null;
        }
        return candidate;
    }

    private static boolean isBrace(@NotNull PsiElement candidate) {
        PairedBraceMatcher braceMatcher;
        ASTNode node;
        if (candidate == null) {
            FlipCommaIntention.$$$reportNull$$$0(16);
        }
        if ((node = candidate.getNode()) != null && node.getFirstChildNode() == null && (braceMatcher = (PairedBraceMatcher)LanguageBraceMatching.INSTANCE.forLanguage(candidate.getLanguage())) != null) {
            IElementType elementType = node.getElementType();
            for (BracePair pair : braceMatcher.getPairs()) {
                if (elementType != pair.getLeftBraceType() && elementType != pair.getRightBraceType()) continue;
                return true;
            }
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/actions/FlipCommaIntention";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 5: 
            case 9: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: 
            case 6: 
            case 10: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comma";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/actions/FlipCommaIntention";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getSiblings";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "swapAtComma";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "swapViaDocument";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "currentCommaElement";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "leftElement";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "rightElement";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isBrace";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface Flipper {
        public static final LanguageExtension<Flipper> EXTENSION = new LanguageExtension("com.intellij.flipCommaIntention.flipper");

        public boolean flip(@NotNull PsiElement var1, @NotNull PsiElement var2);

        default public boolean canFlip(@NotNull PsiElement left, @NotNull PsiElement right) {
            if (left == null) {
                Flipper.$$$reportNull$$$0(0);
            }
            if (right == null) {
                Flipper.$$$reportNull$$$0(1);
            }
            return true;
        }

        public static boolean tryFlip(PsiElement left, PsiElement right) {
            Language language2 = left.getLanguage();
            for (Flipper handler2 : EXTENSION.allForLanguage(language2)) {
                if (!handler2.flip(left, right)) continue;
                return true;
            }
            return false;
        }

        public static boolean isCanFlip(PsiElement left, PsiElement right) {
            Language language2 = left.getLanguage();
            for (Flipper handler2 : EXTENSION.allForLanguage(language2)) {
                if (handler2.canFlip(left, right)) continue;
                return false;
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "left";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "right";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/editor/actions/FlipCommaIntention$Flipper";
            objectArray[2] = "canFlip";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

