/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.editor.actionSystem.EditorWriteActionHandler;
import com.intellij.openapi.editor.actions.TextComponentEditorAction;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.NotNull;

public class HungryBackspaceAction
extends TextComponentEditorAction {
    public HungryBackspaceAction() {
        super(new Handler());
    }

    private static class Handler
    extends EditorWriteActionHandler {
        Handler() {
            super(true);
        }

        @Override
        public void executeWriteAction(@NotNull Editor editor, Caret caret, DataContext dataContext) {
            if (editor == null) {
                Handler.$$$reportNull$$$0(0);
            }
            Document document = editor.getDocument();
            int caretOffset = editor.getCaretModel().getOffset();
            if (caretOffset < 1) {
                return;
            }
            SelectionModel selectionModel = editor.getSelectionModel();
            CharSequence text2 = document.getCharsSequence();
            char c = text2.charAt(caretOffset - 1);
            if (!selectionModel.hasSelection() && StringUtil.isWhiteSpace(c)) {
                int startOffset = CharArrayUtil.shiftBackward(text2, caretOffset - 2, "\t \n") + 1;
                document.deleteString(startOffset, caretOffset);
            } else {
                EditorActionHandler handler2 = EditorActionManager.getInstance().getActionHandler("EditorBackSpace");
                handler2.execute(editor, caret, dataContext);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/editor/actions/HungryBackspaceAction$Handler", "executeWriteAction"));
        }
    }
}

