/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorWriteActionHandler;
import com.intellij.openapi.editor.actions.CaretStop;
import com.intellij.openapi.editor.actions.CaretStopPolicy;
import com.intellij.openapi.editor.actions.EditorActionUtil;
import com.intellij.openapi.editor.actions.KillRingUtil;
import com.intellij.openapi.editor.actions.TextComponentEditorAction;

public class KillToWordEndAction
extends TextComponentEditorAction {
    public KillToWordEndAction() {
        super(new Handler());
    }

    private static class Handler
    extends EditorWriteActionHandler {
        public static final CaretStopPolicy WORD_END_IGNORE_LINE_BREAK = new CaretStopPolicy(CaretStop.END, CaretStop.NONE);

        private Handler() {
        }

        @Override
        public void executeWriteAction(Editor editor, Caret caret, DataContext dataContext) {
            int endOffset;
            boolean camelMode = editor.getSettings().isCamelWords();
            int startOffset = editor.getCaretModel().getOffset();
            if (startOffset != (endOffset = EditorActionUtil.getNextCaretStopOffset(editor, WORD_END_IGNORE_LINE_BREAK, camelMode, true))) {
                KillRingUtil.cut(editor, startOffset, endOffset);
            }
        }
    }
}

