/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorWriteActionHandler;
import com.intellij.openapi.editor.actions.CaretStop;
import com.intellij.openapi.editor.actions.CaretStopPolicy;
import com.intellij.openapi.editor.actions.EditorActionUtil;
import com.intellij.openapi.editor.actions.KillRingUtil;
import com.intellij.openapi.editor.actions.TextComponentEditorAction;

public class KillToWordStartAction
extends TextComponentEditorAction {
    public KillToWordStartAction() {
        super(new Handler());
    }

    private static class Handler
    extends EditorWriteActionHandler {
        public static final CaretStopPolicy WORD_START_IGNORE_LINE_BREAK = new CaretStopPolicy(CaretStop.START, CaretStop.NONE);

        private Handler() {
        }

        @Override
        public void executeWriteAction(Editor editor, Caret caret, DataContext dataContext) {
            boolean camelMode = editor.getSettings().isCamelWords();
            int endOffset = editor.getCaretModel().getOffset();
            int startOffset = EditorActionUtil.getPreviousCaretStopOffset(editor, WORD_START_IGNORE_LINE_BREAK, camelMode, true);
            if (startOffset != endOffset) {
                KillRingUtil.cut(editor, startOffset, endOffset);
            }
        }
    }
}

