/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.ScrollingModel;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.impl.EditorImpl;
import org.jetbrains.annotations.NotNull;

class MoveCaretLeftOrRightHandler
extends EditorActionHandler {
    private final Direction myDirection;

    MoveCaretLeftOrRightHandler(Direction direction) {
        super(true);
        this.myDirection = direction;
    }

    @Override
    public void doExecute(@NotNull Editor editor, Caret caret, DataContext dataContext) {
        if (editor == null) {
            MoveCaretLeftOrRightHandler.$$$reportNull$$$0(0);
        }
        SelectionModel selectionModel = editor.getSelectionModel();
        CaretModel caretModel = editor.getCaretModel();
        ScrollingModel scrollingModel = editor.getScrollingModel();
        if (!(!selectionModel.hasSelection() || editor instanceof EditorEx && ((EditorEx)editor).isStickySelection())) {
            int start2 = selectionModel.getSelectionStart();
            int end = selectionModel.getSelectionEnd();
            int caretOffset = caretModel.getOffset();
            if (start2 <= caretOffset && end >= caretOffset) {
                VisualPosition targetPosition = this.myDirection == Direction.RIGHT ? caret.getSelectionEndPosition() : caret.getSelectionStartPosition();
                selectionModel.removeSelection();
                caretModel.moveToVisualPosition(targetPosition);
                if (caret == editor.getCaretModel().getPrimaryCaret()) {
                    scrollingModel.scrollToCaret(ScrollType.RELATIVE);
                }
                return;
            }
        }
        VisualPosition currentPosition = caret.getVisualPosition();
        if (caret.isAtBidiRunBoundary() && this.myDirection == Direction.RIGHT ^ currentPosition.leansRight) {
            caret.moveToVisualPosition(currentPosition.leanRight(!currentPosition.leansRight));
        } else {
            boolean scrollToCaret = (!(editor instanceof EditorImpl) || ((EditorImpl)editor).isScrollToCaret()) && caret == editor.getCaretModel().getPrimaryCaret();
            caretModel.moveCaretRelatively(this.myDirection == Direction.RIGHT ? 1 : -1, 0, false, false, scrollToCaret);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/editor/actions/MoveCaretLeftOrRightHandler", "doExecute"));
    }

    static enum Direction {
        LEFT,
        RIGHT;

    }
}

