/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.keymap.impl.ModifierKeyDoubleClickHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class MoveCaretLeftOrRightWithSelectionHandler
extends EditorActionHandler {
    private final boolean myMoveRight;

    MoveCaretLeftOrRightWithSelectionHandler(boolean moveRight) {
        super(true);
        this.myMoveRight = moveRight;
    }

    @Override
    protected boolean isEnabledForCaret(@NotNull Editor editor, @NotNull Caret caret, DataContext dataContext) {
        if (editor == null) {
            MoveCaretLeftOrRightWithSelectionHandler.$$$reportNull$$$0(0);
        }
        if (caret == null) {
            MoveCaretLeftOrRightWithSelectionHandler.$$$reportNull$$$0(1);
        }
        return !ModifierKeyDoubleClickHandler.getInstance().isRunningAction() || EditorSettingsExternalizable.getInstance().addCaretsOnDoubleCtrl();
    }

    @Override
    protected void doExecute(@NotNull Editor editor, @Nullable Caret caret, DataContext dataContext) {
        if (editor == null) {
            MoveCaretLeftOrRightWithSelectionHandler.$$$reportNull$$$0(2);
        }
        assert (caret != null);
        VisualPosition currentPosition = caret.getVisualPosition();
        if (caret.isAtBidiRunBoundary() && this.myMoveRight ^ currentPosition.leansRight) {
            int selectionStartToUse = caret.getLeadSelectionOffset();
            VisualPosition selectionStartPositionToUse = caret.getLeadSelectionPosition();
            caret.moveToVisualPosition(currentPosition.leanRight(!currentPosition.leansRight));
            caret.setSelection(selectionStartPositionToUse, selectionStartToUse, caret.getVisualPosition(), caret.getOffset());
        } else {
            editor.getCaretModel().moveCaretRelatively(this.myMoveRight ? 1 : -1, 0, true, editor.isColumnMode(), caret == editor.getCaretModel().getPrimaryCaret());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caret";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/editor/actions/MoveCaretLeftOrRightWithSelectionHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isEnabledForCaret";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "doExecute";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

