/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actions.EditorActionUtil;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class NextPrevWordHandler
extends EditorActionHandler {
    private final boolean myNext;
    private final boolean myWithSelection;
    private final boolean myInDifferentHumpsMode;

    NextPrevWordHandler(boolean next, boolean withSelection, boolean inDifferentHumpsMode) {
        super(true);
        this.myNext = next;
        this.myWithSelection = withSelection;
        this.myInDifferentHumpsMode = inDifferentHumpsMode;
    }

    @Override
    protected void doExecute(@NotNull Editor editor, @Nullable Caret caret, DataContext dataContext) {
        if (editor == null) {
            NextPrevWordHandler.$$$reportNull$$$0(0);
        }
        assert (caret != null);
        if (EditorUtil.isPasswordEditor(editor)) {
            int selectionStartOffset = caret.getLeadSelectionOffset();
            caret.moveToOffset(this.myNext ? editor.getDocument().getTextLength() : 0);
            if (this.myWithSelection) {
                caret.setSelection(selectionStartOffset, caret.getOffset());
            }
        } else {
            VisualPosition currentPosition = caret.getVisualPosition();
            if (caret.isAtBidiRunBoundary() && this.myNext ^ currentPosition.leansRight) {
                int selectionStartOffset = caret.getLeadSelectionOffset();
                VisualPosition selectionStartPosition = caret.getLeadSelectionPosition();
                caret.moveToVisualPosition(currentPosition.leanRight(!currentPosition.leansRight));
                if (this.myWithSelection) {
                    caret.setSelection(selectionStartPosition, selectionStartOffset, caret.getVisualPosition(), caret.getOffset());
                }
            } else if (this.myNext ^ caret.isAtRtlLocation()) {
                EditorActionUtil.moveCaretToNextWord(editor, this.myWithSelection, this.myInDifferentHumpsMode ^ editor.getSettings().isCamelWords());
            } else {
                EditorActionUtil.moveCaretToPreviousWord(editor, this.myWithSelection, this.myInDifferentHumpsMode ^ editor.getSettings().isCamelWords());
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/editor/actions/NextPrevWordHandler", "doExecute"));
    }
}

