/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.find.FindManager;
import com.intellij.find.FindModel;
import com.intellij.find.FindResult;
import com.intellij.find.FindUtil;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.actionSystem.EditorAction;
import com.intellij.openapi.editor.actions.IncrementalFindAction;
import com.intellij.openapi.editor.actions.SelectOccurrencesActionHandler;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SelectAllOccurrencesAction
extends EditorAction {
    protected SelectAllOccurrencesAction() {
        super(new Handler());
    }

    private static class Handler
    extends SelectOccurrencesActionHandler {
        private Handler() {
        }

        @Override
        public boolean isEnabledForCaret(@NotNull Editor editor, @NotNull Caret caret, DataContext dataContext) {
            if (editor == null) {
                Handler.$$$reportNull$$$0(0);
            }
            if (caret == null) {
                Handler.$$$reportNull$$$0(1);
            }
            return editor.getProject() != null && editor.getCaretModel().supportsMultipleCarets() && IncrementalFindAction.SEARCH_DISABLED.get(editor, false) == false;
        }

        @Override
        public void doExecute(final @NotNull Editor editor, @Nullable Caret c, DataContext dataContext) {
            TextRange wordSelectionRange;
            if (editor == null) {
                Handler.$$$reportNull$$$0(2);
            }
            Caret caret = c == null ? editor.getCaretModel().getPrimaryCaret() : c;
            boolean wholeWordsSearch = false;
            if (!caret.hasSelection() && (wordSelectionRange = Handler.getSelectionRange(editor, caret)) != null) {
                Handler.setSelection(editor, caret, wordSelectionRange);
                wholeWordsSearch = true;
            }
            String selectedText = caret.getSelectedText();
            Project project2 = editor.getProject();
            if (project2 == null || selectedText == null) {
                return;
            }
            int caretShiftFromSelectionStart = caret.getOffset() - caret.getSelectionStart();
            final FindManager findManager = FindManager.getInstance(project2);
            final FindModel model = Handler.getFindModel(selectedText, wholeWordsSearch);
            FindUtil.selectSearchResultsInEditor(editor, (Iterator<? extends FindResult>)new Iterator<FindResult>(){
                FindResult findResult;
                {
                    this.findResult = findManager.findString(editor.getDocument().getCharsSequence(), 0, model);
                }

                @Override
                public boolean hasNext() {
                    return this.findResult.isStringFound();
                }

                @Override
                public FindResult next() {
                    FindResult result2 = this.findResult;
                    this.findResult = findManager.findString(editor.getDocument().getCharsSequence(), this.findResult.getEndOffset(), model);
                    return result2;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            }, caretShiftFromSelectionStart);
            editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "caret";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/editor/actions/SelectAllOccurrencesAction$Handler";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isEnabledForCaret";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "doExecute";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

