/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.ScrollingModel;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actions.TextComponentEditorAction;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.fileEditor.ex.IdeDocumentHistory;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextEndAction
extends TextComponentEditorAction {
    public TextEndAction() {
        super(new Handler());
    }

    private static class Handler
    extends EditorActionHandler {
        private Handler() {
        }

        @Override
        public void doExecute(@NotNull Editor editor, @Nullable Caret caret, DataContext dataContext) {
            IdeDocumentHistory instance2;
            if (editor == null) {
                Handler.$$$reportNull$$$0(0);
            }
            editor.getCaretModel().removeSecondaryCarets();
            int offset = editor.getDocument().getTextLength();
            if (editor instanceof EditorImpl) {
                editor.getCaretModel().moveToLogicalPosition(editor.offsetToLogicalPosition(offset).leanForward(true));
            } else {
                editor.getCaretModel().moveToOffset(offset);
            }
            editor.getSelectionModel().removeSelection();
            ScrollingModel scrollingModel = editor.getScrollingModel();
            scrollingModel.disableAnimation();
            scrollingModel.scrollToCaret(ScrollType.CENTER);
            scrollingModel.enableAnimation();
            Project project2 = CommonDataKeys.PROJECT.getData(dataContext);
            if (project2 != null && (instance2 = IdeDocumentHistory.getInstance(project2)) != null) {
                instance2.includeCurrentCommandAsNavigation();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/editor/actions/TextEndAction$Handler", "doExecute"));
        }
    }
}

