/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.colors.impl;

import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorFontCache;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.colors.FontPreferences;
import com.intellij.openapi.editor.colors.impl.AppEditorFontOptions;
import com.intellij.util.ObjectUtils;
import java.awt.Font;
import java.util.EnumMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditorFontCacheImpl
extends EditorFontCache {
    @NotNull
    private final Map<EditorFontType, Font> myFonts = new EnumMap<EditorFontType, Font>(EditorFontType.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public Font getFont(@Nullable EditorFontType key) {
        Map<EditorFontType, Font> map2 = this.myFonts;
        // MONITORENTER : map2
        if (this.myFonts.isEmpty()) {
            this.initFonts();
        }
        EditorFontType fontType = ObjectUtils.notNull(key, EditorFontType.PLAIN);
        Font font = this.myFonts.get((Object)fontType);
        assert (font != null) : "Font " + (Object)((Object)fontType) + " not found.";
        UISettings uiSettings = UISettings.getInstance();
        if (uiSettings.getPresentationMode()) {
            Font font2 = new Font(font.getName(), font.getStyle(), uiSettings.getPresentationModeFontSize());
            // MONITOREXIT : map2
            if (font2 != null) return font2;
            EditorFontCacheImpl.$$$reportNull$$$0(0);
            return font2;
        }
        Font font3 = font;
        // MONITOREXIT : map2
        if (font3 != null) return font3;
        EditorFontCacheImpl.$$$reportNull$$$0(1);
        return font3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() {
        Map<EditorFontType, Font> map2 = this.myFonts;
        synchronized (map2) {
            this.myFonts.clear();
        }
    }

    protected EditorColorsScheme getFontCacheScheme() {
        return EditorColorsManager.getInstance().getGlobalScheme();
    }

    private void initFonts() {
        int editorFontSize;
        EditorColorsScheme scheme = this.getFontCacheScheme();
        String editorFontName = scheme.getFontPreferences().getFontFamily();
        String fallbackName = EditorFontCacheImpl.getFallbackName(editorFontName, editorFontSize = scheme.getEditorFontSize());
        if (fallbackName != null) {
            editorFontName = fallbackName;
        }
        Font plainFont = new Font(editorFontName, 0, editorFontSize);
        Font boldFont = new Font(editorFontName, 1, editorFontSize);
        Font italicFont = new Font(editorFontName, 2, editorFontSize);
        Font boldItalicFont = new Font(editorFontName, 3, editorFontSize);
        this.myFonts.put(EditorFontType.PLAIN, plainFont);
        this.myFonts.put(EditorFontType.BOLD, boldFont);
        this.myFonts.put(EditorFontType.ITALIC, italicFont);
        this.myFonts.put(EditorFontType.BOLD_ITALIC, boldItalicFont);
        String consoleFontName = scheme.getConsoleFontName();
        int consoleFontSize = scheme.getConsoleFontSize();
        Font consolePlainFont = new Font(consoleFontName, 0, consoleFontSize);
        Font consoleBoldFont = new Font(consoleFontName, 1, consoleFontSize);
        Font consoleItalicFont = new Font(consoleFontName, 2, consoleFontSize);
        Font consoleBoldItalicFont = new Font(consoleFontName, 3, consoleFontSize);
        this.myFonts.put(EditorFontType.CONSOLE_PLAIN, consolePlainFont);
        this.myFonts.put(EditorFontType.CONSOLE_BOLD, consoleBoldFont);
        this.myFonts.put(EditorFontType.CONSOLE_ITALIC, consoleItalicFont);
        this.myFonts.put(EditorFontType.CONSOLE_BOLD_ITALIC, consoleBoldItalicFont);
    }

    @Nullable
    private static String getFallbackName(@NotNull String fontName, int fontSize) {
        Font plainFont;
        if (fontName == null) {
            EditorFontCacheImpl.$$$reportNull$$$0(2);
        }
        if ((plainFont = new Font(fontName, 0, fontSize)).getFamily().equals("Dialog") && !"Dialog".equals(fontName) && !fontName.startsWith("Dialog.")) {
            FontPreferences appPrefs = AppEditorFontOptions.getInstance().getFontPreferences();
            return appPrefs.getFontFamily();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/colors/impl/EditorFontCacheImpl";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fontName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFont";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/colors/impl/EditorFontCacheImpl";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getFallbackName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

