/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.colors.impl;

import com.intellij.application.options.EditorFontsConstants;
import com.intellij.openapi.editor.colors.FontPreferences;
import com.intellij.openapi.editor.colors.ModifiableFontPreferences;
import gnu.trove.TObjectIntHashMap;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FontPreferencesImpl
extends ModifiableFontPreferences {
    @NotNull
    private final TObjectIntHashMap<String> myFontSizes = new TObjectIntHashMap();
    @NotNull
    private final List<String> myEffectiveFontFamilies = new ArrayList<String>();
    @NotNull
    private final List<String> myRealFontFamilies = new ArrayList<String>();
    private boolean myUseLigatures;
    private float myLineSpacing = 1.2f;
    @Nullable
    private Runnable myChangeListener;
    private int myTemplateFontSize = DEFAULT_FONT_SIZE;

    public void setChangeListener(@Nullable Runnable changeListener) {
        this.myChangeListener = changeListener;
    }

    @Nullable
    public Runnable getChangeListener() {
        return this.myChangeListener;
    }

    @Override
    public void clear() {
        this.myFontSizes.clear();
        this.clearFonts();
    }

    @Override
    public void clearFonts() {
        this.myEffectiveFontFamilies.clear();
        this.myRealFontFamilies.clear();
        this.myUseLigatures = false;
        if (this.myChangeListener != null) {
            this.myChangeListener.run();
        }
    }

    @Override
    public boolean hasSize(@NotNull String fontName) {
        if (fontName == null) {
            FontPreferencesImpl.$$$reportNull$$$0(0);
        }
        return this.myFontSizes.containsKey(fontName);
    }

    @Override
    public float getLineSpacing() {
        return this.myLineSpacing;
    }

    @Override
    public void setLineSpacing(float lineSpacing) {
        this.myLineSpacing = EditorFontsConstants.checkAndFixEditorLineSpacing(lineSpacing);
    }

    @Override
    public int getSize(@NotNull String fontFamily) {
        int result2;
        if (fontFamily == null) {
            FontPreferencesImpl.$$$reportNull$$$0(1);
        }
        if ((result2 = this.myFontSizes.get(fontFamily)) <= 0) {
            result2 = this.myTemplateFontSize;
        }
        return result2 > 0 ? result2 : DEFAULT_FONT_SIZE;
    }

    public void setSize(@NotNull String fontFamily, int size) {
        if (fontFamily == null) {
            FontPreferencesImpl.$$$reportNull$$$0(2);
        }
        this.myFontSizes.put(fontFamily, size);
        this.myTemplateFontSize = size;
        if (this.myChangeListener != null) {
            this.myChangeListener.run();
        }
    }

    @Override
    @NotNull
    public List<String> getEffectiveFontFamilies() {
        List<String> list2 = this.myEffectiveFontFamilies;
        if (list2 == null) {
            FontPreferencesImpl.$$$reportNull$$$0(3);
        }
        return list2;
    }

    @Override
    @NotNull
    public List<String> getRealFontFamilies() {
        List<String> list2 = this.myRealFontFamilies;
        if (list2 == null) {
            FontPreferencesImpl.$$$reportNull$$$0(4);
        }
        return list2;
    }

    @Override
    public void register(@NotNull String fontFamily, int size) {
        String effectiveFontFamily;
        if (fontFamily == null) {
            FontPreferencesImpl.$$$reportNull$$$0(5);
        }
        String fallbackFontFamily = FontPreferences.getFallbackName(fontFamily, size, null);
        if (!this.myRealFontFamilies.contains(fontFamily)) {
            this.myRealFontFamilies.add(fontFamily);
        }
        String string = effectiveFontFamily = fallbackFontFamily == null ? fontFamily : fallbackFontFamily;
        if (!this.myEffectiveFontFamilies.contains(effectiveFontFamily)) {
            this.myEffectiveFontFamilies.add(effectiveFontFamily);
        }
        this.setSize(fontFamily, size);
    }

    @Override
    @NotNull
    public String getFontFamily() {
        String string = this.myEffectiveFontFamilies.isEmpty() ? DEFAULT_FONT_NAME : this.myEffectiveFontFamilies.get(0);
        if (string == null) {
            FontPreferencesImpl.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Override
    public void addFontFamily(@NotNull String fontFamily) {
        String effectiveFontFamily;
        if (fontFamily == null) {
            FontPreferencesImpl.$$$reportNull$$$0(7);
        }
        String fallbackFontFamily = FontPreferences.getFallbackName(fontFamily, DEFAULT_FONT_SIZE, null);
        if (!this.myRealFontFamilies.contains(fontFamily)) {
            this.myRealFontFamilies.add(fontFamily);
        }
        String string = effectiveFontFamily = fallbackFontFamily == null ? fontFamily : fallbackFontFamily;
        if (!this.myEffectiveFontFamilies.contains(effectiveFontFamily)) {
            this.myEffectiveFontFamilies.add(effectiveFontFamily);
        }
        if (this.myChangeListener != null) {
            this.myChangeListener.run();
        }
    }

    @Override
    public void copyTo(@NotNull FontPreferences preferences) {
        if (preferences == null) {
            FontPreferencesImpl.$$$reportNull$$$0(8);
        }
        if (preferences instanceof ModifiableFontPreferences) {
            ModifiableFontPreferences modifiablePreferences = (ModifiableFontPreferences)preferences;
            modifiablePreferences.setEffectiveFontFamilies(this.myEffectiveFontFamilies);
            modifiablePreferences.setRealFontFamilies(this.myRealFontFamilies);
            modifiablePreferences.setTemplateFontSize(this.myTemplateFontSize);
            modifiablePreferences.resetFontSizes();
            for (String fontFamily : this.myRealFontFamilies) {
                if (!this.myFontSizes.containsKey(fontFamily)) continue;
                modifiablePreferences.setFontSize(fontFamily, this.myFontSizes.get(fontFamily));
            }
            modifiablePreferences.setUseLigatures(this.myUseLigatures);
            modifiablePreferences.setLineSpacing(this.myLineSpacing);
        }
    }

    @Override
    public void resetFontSizes() {
        this.myFontSizes.clear();
    }

    @Override
    public void setFontSize(@NotNull String fontFamily, int size) {
        if (fontFamily == null) {
            FontPreferencesImpl.$$$reportNull$$$0(9);
        }
        this.myFontSizes.put(fontFamily, size);
    }

    @Override
    public void setTemplateFontSize(int size) {
        this.myTemplateFontSize = size;
    }

    @Override
    public void setEffectiveFontFamilies(@NotNull List<String> fontFamilies) {
        if (fontFamilies == null) {
            FontPreferencesImpl.$$$reportNull$$$0(10);
        }
        this.myEffectiveFontFamilies.clear();
        this.myEffectiveFontFamilies.addAll(fontFamilies);
    }

    @Override
    public void setRealFontFamilies(@NotNull List<String> fontFamilies) {
        if (fontFamilies == null) {
            FontPreferencesImpl.$$$reportNull$$$0(11);
        }
        this.myRealFontFamilies.clear();
        this.myRealFontFamilies.addAll(fontFamilies);
    }

    public int hashCode() {
        return this.myRealFontFamilies.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FontPreferencesImpl that = (FontPreferencesImpl)o;
        if (!this.myRealFontFamilies.equals(that.myRealFontFamilies)) {
            return false;
        }
        for (String fontFamily : this.myRealFontFamilies) {
            if (this.myFontSizes.get(fontFamily) == that.myFontSizes.get(fontFamily)) continue;
            return false;
        }
        if (this.myUseLigatures != that.myUseLigatures) {
            return false;
        }
        return this.myLineSpacing == that.myLineSpacing;
    }

    @Override
    public boolean useLigatures() {
        return this.myUseLigatures;
    }

    @Override
    public void setUseLigatures(boolean useLigatures) {
        if (useLigatures != this.myUseLigatures) {
            this.myUseLigatures = useLigatures;
            if (this.myChangeListener != null) {
                this.myChangeListener.run();
            }
        }
    }

    public String toString() {
        return "Effective font families: " + this.myEffectiveFontFamilies;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fontName";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fontFamily";
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/colors/impl/FontPreferencesImpl";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "preferences";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fontFamilies";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/colors/impl/FontPreferencesImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getEffectiveFontFamilies";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getRealFontFamilies";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFontFamily";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "hasSize";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getSize";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setSize";
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "register";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addFontFamily";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "copyTo";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setFontSize";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setEffectiveFontFamilies";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setRealFontFamilies";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

