/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.colors.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColorUtil;
import java.awt.Color;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

class ValueElementReader {
    @NonNls
    private static final String VALUE = "value";
    @NonNls
    private static final String MAC = "mac";
    @NonNls
    private static final String LINUX = "linux";
    @NonNls
    private static final String WINDOWS = "windows";
    private static final String OS = SystemInfo.isWindows ? "windows" : (SystemInfo.isMac ? "mac" : "linux");
    private static final Logger LOG = Logger.getInstance(ValueElementReader.class);
    private String myAttribute;

    ValueElementReader() {
    }

    public void setAttribute(String attribute) {
        this.myAttribute = StringUtil.isEmpty(attribute) ? null : attribute;
    }

    @Nullable
    public <T> T read(Class<T> type, Element element2) {
        T value2 = null;
        if (element2 != null) {
            if (this.myAttribute != null) {
                value2 = this.read(type, element2, this.myAttribute);
            }
            if (value2 == null && (value2 = (T)this.read(type, element2, OS)) == null) {
                value2 = this.read(type, element2, VALUE);
            }
        }
        return value2;
    }

    private <T> T read(Class<T> type, Element element2, String attribute) {
        block6: {
            String value2 = element2.getAttributeValue(attribute);
            if (value2 != null) {
                if ((value2 = value2.trim()).isEmpty()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("empty attribute: " + attribute);
                    }
                } else {
                    try {
                        return this.convert(type, value2);
                    }
                    catch (Exception exception) {
                        if (!LOG.isDebugEnabled()) break block6;
                        LOG.debug("wrong attribute: " + attribute, exception);
                    }
                }
            }
        }
        return null;
    }

    protected <T> T convert(Class<T> type, String value2) {
        if (String.class.equals(type)) {
            return (T)value2;
        }
        if (Integer.class.equals(type)) {
            return (T)Integer.valueOf(value2);
        }
        if (Float.class.equals(type)) {
            return (T)Float.valueOf(value2);
        }
        if (Color.class.equals(type)) {
            return (T)ValueElementReader.toColor(value2);
        }
        if (Enum.class.isAssignableFrom(type)) {
            return ValueElementReader.toEnum(type, value2);
        }
        if (Boolean.class.equals(type)) {
            return (T)Boolean.valueOf(value2);
        }
        throw new IllegalArgumentException("unsupported " + type);
    }

    private static <T extends Enum> T toEnum(Class<T> type, String value2) {
        for (Enum field : (Enum[])type.getEnumConstants()) {
            if (!value2.equalsIgnoreCase(field.name()) && !value2.equals(String.valueOf(field.ordinal()))) continue;
            return (T)field;
        }
        throw new IllegalArgumentException(value2);
    }

    private static Color toColor(String value2) {
        int rgb;
        try {
            if (6 <= value2.length()) {
                return ColorUtil.fromHex(value2);
            }
            LOG.debug("short color value: ", value2);
        }
        catch (Exception exception) {
            LOG.debug("wrong color value: ", value2);
        }
        try {
            rgb = Integer.parseInt(value2, 16);
        }
        catch (NumberFormatException ignored) {
            rgb = Integer.decode(value2);
        }
        return new Color(rgb);
    }
}

