/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.ex.util;

import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.ex.util.DataStorage;
import com.intellij.openapi.editor.ex.util.LayerDescriptor;
import com.intellij.openapi.editor.ex.util.LayeredHighlighterIterator;
import com.intellij.openapi.editor.ex.util.LexerEditorHighlighter;
import com.intellij.openapi.editor.ex.util.LimitedRangeHighlighterIterator;
import com.intellij.openapi.editor.ex.util.SegmentArray;
import com.intellij.openapi.editor.ex.util.SegmentArrayWithData;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterClient;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.containers.IntArrayList;
import com.intellij.util.text.MergingCharSequence;
import gnu.trove.TIntIntHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LayeredLexerEditorHighlighter
extends LexerEditorHighlighter {
    private static final Logger LOG = Logger.getInstance(LayeredLexerEditorHighlighter.class);
    private final Map<IElementType, LayerDescriptor> myTokensToLayer;

    public LayeredLexerEditorHighlighter(@NotNull SyntaxHighlighter highlighter, @NotNull EditorColorsScheme scheme) {
        if (highlighter == null) {
            LayeredLexerEditorHighlighter.$$$reportNull$$$0(0);
        }
        if (scheme == null) {
            LayeredLexerEditorHighlighter.$$$reportNull$$$0(1);
        }
        super(highlighter, scheme);
        this.myTokensToLayer = new HashMap<IElementType, LayerDescriptor>();
    }

    @Override
    @NotNull
    protected SegmentArrayWithData createSegments() {
        return new MappingSegments(this.createStorage());
    }

    public synchronized void registerLayer(@NotNull IElementType tokenType, @NotNull LayerDescriptor layerHighlighter) {
        if (tokenType == null) {
            LayeredLexerEditorHighlighter.$$$reportNull$$$0(2);
        }
        if (layerHighlighter == null) {
            LayeredLexerEditorHighlighter.$$$reportNull$$$0(3);
        }
        this.myTokensToLayer.put(tokenType, layerHighlighter);
        this.getSegments().removeAll();
    }

    public synchronized void unregisterLayer(@NotNull IElementType tokenType) {
        LayerDescriptor layer;
        if (tokenType == null) {
            LayeredLexerEditorHighlighter.$$$reportNull$$$0(4);
        }
        if ((layer = this.myTokensToLayer.remove(tokenType)) != null) {
            this.getSegments().myLayerBuffers.remove(layer);
            this.getSegments().removeAll();
        }
    }

    @Override
    @NotNull
    public MappingSegments getSegments() {
        MappingSegments mappingSegments = (MappingSegments)super.getSegments();
        if (mappingSegments == null) {
            LayeredLexerEditorHighlighter.$$$reportNull$$$0(5);
        }
        return mappingSegments;
    }

    @Override
    public void setText(@NotNull CharSequence text2) {
        if (text2 == null) {
            LayeredLexerEditorHighlighter.$$$reportNull$$$0(6);
        }
        if (this.updateLayers()) {
            this.resetText(text2);
        } else {
            super.setText(text2);
        }
    }

    @Override
    @NotNull
    protected LexerEditorHighlighter.TokenProcessor createTokenProcessor(final int startIndex, SegmentArrayWithData segments2, final CharSequence text2) {
        final MappingSegments mappingSegments = (MappingSegments)segments2;
        return new LexerEditorHighlighter.TokenProcessor(){
            final Map<Mapper, LightMapper> docTexts = FactoryMap.create(key -> {
                MappedRange predecessor = key.findPredecessor(startIndex, mappingSegments);
                return new LightMapper((Mapper)key, predecessor != null ? predecessor.range.getEndOffset() : 0);
            });

            @Override
            public void addToken(int tokenIndex, int startOffset, int endOffset, int data2, @NotNull IElementType tokenType) {
                if (tokenType == null) {
                    1.$$$reportNull$$$0(0);
                }
                mappingSegments.setElementLight(tokenIndex, startOffset, endOffset, data2);
                Mapper mapper = mappingSegments.getMappingDocument(tokenType);
                if (mapper != null) {
                    this.docTexts.get(mapper).addToken(text2.subSequence(startOffset, endOffset), tokenType, tokenIndex);
                }
            }

            @Override
            public void finish() {
                for (LightMapper mapper : this.docTexts.values()) {
                    mapper.finish();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tokenType", "com/intellij/openapi/editor/ex/util/LayeredLexerEditorHighlighter$1", "addToken"));
            }
        };
    }

    protected boolean updateLayers() {
        return false;
    }

    protected boolean updateLayers(@NotNull DocumentEvent e) {
        if (e == null) {
            LayeredLexerEditorHighlighter.$$$reportNull$$$0(7);
        }
        return this.updateLayers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void documentChanged(@NotNull DocumentEvent e) {
        if (e == null) {
            LayeredLexerEditorHighlighter.$$$reportNull$$$0(8);
        }
        boolean changed2 = this.updateLayers(e);
        LayeredLexerEditorHighlighter layeredLexerEditorHighlighter = this;
        synchronized (layeredLexerEditorHighlighter) {
            if (changed2) {
                super.setText(e.getDocument().getImmutableCharSequence());
            } else {
                super.documentChanged(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public HighlighterIterator createIterator(int startOffset) {
        LayeredLexerEditorHighlighter layeredLexerEditorHighlighter = this;
        // MONITORENTER : layeredLexerEditorHighlighter
        LayeredHighlighterIteratorImpl layeredHighlighterIteratorImpl = new LayeredHighlighterIteratorImpl(startOffset);
        // MONITOREXIT : layeredLexerEditorHighlighter
        if (layeredHighlighterIteratorImpl != null) return layeredHighlighterIteratorImpl;
        LayeredLexerEditorHighlighter.$$$reportNull$$$0(9);
        return layeredHighlighterIteratorImpl;
    }

    @NotNull
    public HighlighterIterator createBaseIterator(int startOffset) {
        HighlighterIterator highlighterIterator = super.createIterator(startOffset);
        if (highlighterIterator == null) {
            LayeredLexerEditorHighlighter.$$$reportNull$$$0(10);
        }
        return highlighterIterator;
    }

    @Override
    public void setColorScheme(@NotNull EditorColorsScheme scheme) {
        if (scheme == null) {
            LayeredLexerEditorHighlighter.$$$reportNull$$$0(11);
        }
        super.setColorScheme(scheme);
        for (MappedRange mapping2 : this.getSegments().myRanges) {
            Mapper mapper;
            Mapper mapper2 = mapper = mapping2 == null ? null : mapping2.mapper;
            if (mapper == null) continue;
            mapper.resetCachedTextAttributes();
        }
    }

    @Override
    protected boolean hasAdditionalData(int segmentIndex) {
        return this.getSegments().myRanges[segmentIndex] != null;
    }

    private static MappedRange @NotNull [] reallocateArray(MappedRange @NotNull [] array, int index) {
        if (array == null) {
            LayeredLexerEditorHighlighter.$$$reportNull$$$0(12);
        }
        if (index < array.length) {
            if (array == null) {
                LayeredLexerEditorHighlighter.$$$reportNull$$$0(13);
            }
            return array;
        }
        MappedRange[] mappedRangeArray = ArrayUtil.realloc(array, SegmentArray.calcCapacity(array.length, index), MappedRange[]::new);
        if (mappedRangeArray == null) {
            LayeredLexerEditorHighlighter.$$$reportNull$$$0(14);
        }
        return mappedRangeArray;
    }

    @Override
    public String toString() {
        return this.myText.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 9: 
            case 10: 
            case 13: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 9: 
            case 10: 
            case 13: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlighter";
                break;
            }
            case 1: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scheme";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tokenType";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "layerHighlighter";
                break;
            }
            case 5: 
            case 9: 
            case 10: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/ex/util/LayeredLexerEditorHighlighter";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "array";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/ex/util/LayeredLexerEditorHighlighter";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSegments";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createIterator";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createBaseIterator";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "reallocateArray";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "registerLayer";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "unregisterLayer";
                break;
            }
            case 5: 
            case 9: 
            case 10: 
            case 13: 
            case 14: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setText";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "updateLayers";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "documentChanged";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setColorScheme";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "reallocateArray";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 9: 
            case 10: 
            case 13: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class LayeredHighlighterIteratorImpl
    implements LayeredHighlighterIterator {
        private final HighlighterIterator myBaseIterator;
        private HighlighterIterator myLayerIterator;
        private int myLayerStartOffset;
        private Mapper myCurrentMapper;

        private LayeredHighlighterIteratorImpl(int offset) {
            this.myBaseIterator = LayeredLexerEditorHighlighter.this.createBaseIterator(offset);
            if (!this.myBaseIterator.atEnd()) {
                int shift = offset - this.myBaseIterator.getStart();
                this.initLayer(shift);
            }
        }

        private void initLayer(int shiftInToken) {
            if (this.myBaseIterator.atEnd()) {
                this.myLayerIterator = null;
                this.myCurrentMapper = null;
                return;
            }
            MappedRange mapping2 = LayeredLexerEditorHighlighter.this.getSegments().myRanges[((LexerEditorHighlighter.HighlighterIteratorImpl)this.myBaseIterator).currentIndex()];
            if (mapping2 != null) {
                this.myCurrentMapper = mapping2.mapper;
                this.myLayerIterator = this.myCurrentMapper.createIterator(mapping2, shiftInToken);
                this.myLayerStartOffset = this.myBaseIterator.getStart() - mapping2.range.getStartOffset();
            } else {
                this.myCurrentMapper = null;
                this.myLayerIterator = null;
            }
        }

        @Override
        public TextAttributes getTextAttributes() {
            if (this.myCurrentMapper != null) {
                return this.myCurrentMapper.getAttributes(this.getTokenType());
            }
            return this.myBaseIterator.getTextAttributes();
        }

        @Override
        @NotNull
        public SyntaxHighlighter getActiveSyntaxHighlighter() {
            if (this.myCurrentMapper != null) {
                SyntaxHighlighter syntaxHighlighter = this.myCurrentMapper.mySyntaxHighlighter;
                if (syntaxHighlighter == null) {
                    LayeredHighlighterIteratorImpl.$$$reportNull$$$0(0);
                }
                return syntaxHighlighter;
            }
            SyntaxHighlighter syntaxHighlighter = LayeredLexerEditorHighlighter.this.getSyntaxHighlighter();
            if (syntaxHighlighter == null) {
                LayeredHighlighterIteratorImpl.$$$reportNull$$$0(1);
            }
            return syntaxHighlighter;
        }

        @Override
        public int getStart() {
            if (this.myLayerIterator != null) {
                return this.myLayerIterator.getStart() + this.myLayerStartOffset;
            }
            return this.myBaseIterator.getStart();
        }

        @Override
        public int getEnd() {
            if (this.myLayerIterator != null) {
                return this.myLayerIterator.getEnd() + this.myLayerStartOffset;
            }
            return this.myBaseIterator.getEnd();
        }

        @Override
        public IElementType getTokenType() {
            return this.myLayerIterator != null ? this.myLayerIterator.getTokenType() : this.myBaseIterator.getTokenType();
        }

        @Override
        public void advance() {
            if (this.myLayerIterator != null) {
                this.myLayerIterator.advance();
                if (!this.myLayerIterator.atEnd()) {
                    return;
                }
            }
            this.myBaseIterator.advance();
            this.initLayer(0);
        }

        @Override
        public void retreat() {
            if (this.myLayerIterator != null) {
                this.myLayerIterator.retreat();
                if (!this.myLayerIterator.atEnd()) {
                    return;
                }
            }
            this.myBaseIterator.retreat();
            this.initLayer(this.myBaseIterator.atEnd() ? 0 : this.myBaseIterator.getEnd() - this.myBaseIterator.getStart() - 1);
        }

        @Override
        public boolean atEnd() {
            return this.myBaseIterator.atEnd();
        }

        @Override
        public Document getDocument() {
            return this.myBaseIterator.getDocument();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/ex/util/LayeredLexerEditorHighlighter$LayeredHighlighterIteratorImpl", "getActiveSyntaxHighlighter"));
        }
    }

    private static class MappedRange {
        private RangeMarker range;
        private final Mapper mapper;
        private final IElementType outerToken;

        MappedRange(@NotNull Mapper mapper, @NotNull RangeMarker range2, @NotNull IElementType outerToken) {
            if (range2 == null) {
                MappedRange.$$$reportNull$$$0(0);
            }
            if (outerToken == null) {
                MappedRange.$$$reportNull$$$0(1);
            }
            if (mapper == null) {
                MappedRange.$$$reportNull$$$0(2);
            }
            this.mapper = mapper;
            this.range = range2;
            this.outerToken = outerToken;
            assert (mapper.doc == range2.getDocument());
        }

        public String toString() {
            return "MappedRange{range=" + this.range + ", outerToken=" + this.outerToken + '}';
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "range";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "outerToken";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "mapper";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/editor/ex/util/LayeredLexerEditorHighlighter$MappedRange";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class Mapper
    implements HighlighterClient {
        private final DocumentImpl doc;
        private final EditorHighlighter highlighter;
        private final String mySeparator;
        private final Map<IElementType, TextAttributes> myAttributesMap;
        @NotNull
        private final SyntaxHighlighter mySyntaxHighlighter;
        private final TextAttributesKey myBackground;

        private Mapper(LayerDescriptor descriptor2) {
            if (descriptor2 == null) {
                Mapper.$$$reportNull$$$0(0);
            }
            this.myAttributesMap = new HashMap<IElementType, TextAttributes>();
            this.doc = new DocumentImpl("", true);
            this.mySyntaxHighlighter = descriptor2.getLayerHighlighter();
            this.myBackground = descriptor2.getBackgroundKey();
            this.highlighter = new LexerEditorHighlighter(this.mySyntaxHighlighter, LayeredLexerEditorHighlighter.this.getScheme());
            this.mySeparator = descriptor2.getTokenSeparator();
            this.highlighter.setEditor(this);
            this.doc.addDocumentListener(this.highlighter);
        }

        @NotNull
        public TextAttributes getAttributes(IElementType tokenType) {
            TextAttributes attrs = this.myAttributesMap.get(tokenType);
            if (attrs == null) {
                attrs = LayeredLexerEditorHighlighter.this.convertAttributes(SyntaxHighlighterBase.pack(this.myBackground, this.mySyntaxHighlighter.getTokenHighlights(tokenType)));
                this.myAttributesMap.put(tokenType, attrs);
            }
            TextAttributes textAttributes = attrs;
            if (textAttributes == null) {
                Mapper.$$$reportNull$$$0(1);
            }
            return textAttributes;
        }

        @NotNull
        public HighlighterIterator createIterator(@NotNull MappedRange mapper, int shift) {
            if (mapper == null) {
                Mapper.$$$reportNull$$$0(2);
            }
            int rangeStart = mapper.range.getStartOffset();
            int rangeEnd = mapper.range.getEndOffset();
            return new LimitedRangeHighlighterIterator(this.highlighter.createIterator(rangeStart + shift), rangeStart, rangeEnd);
        }

        @Override
        public Project getProject() {
            return LayeredLexerEditorHighlighter.this.getClient().getProject();
        }

        @Override
        public void repaint(int start2, int end) {
        }

        @Override
        public Document getDocument() {
            return LayeredLexerEditorHighlighter.this.getDocument();
        }

        void resetCachedTextAttributes() {
            this.myAttributesMap.clear();
        }

        void updateMapping(int tokenIndex, @NotNull MappedRange oldMapping) {
            if (oldMapping == null) {
                Mapper.$$$reportNull$$$0(3);
            }
            CharSequence tokenText = this.getTokenText(tokenIndex);
            int start2 = oldMapping.range.getStartOffset();
            int end = oldMapping.range.getEndOffset();
            if (Comparing.equal(this.doc.getCharsSequence().subSequence(start2, end), tokenText)) {
                return;
            }
            this.doc.replaceString(start2, end, tokenText);
            int newEnd = start2 + tokenText.length();
            if (oldMapping.range.getStartOffset() != start2 || oldMapping.range.getEndOffset() != newEnd) {
                assert (oldMapping.range.getDocument() == this.doc);
                oldMapping.range.dispose();
                oldMapping.range = this.doc.createRangeMarker(start2, newEnd);
            }
        }

        @NotNull
        private MappedRange insertMapping(int tokenIndex, @NotNull IElementType outerToken) {
            if (outerToken == null) {
                Mapper.$$$reportNull$$$0(4);
            }
            CharSequence tokenText = this.getTokenText(tokenIndex);
            int length = tokenText.length();
            MappedRange predecessor = this.findPredecessor(tokenIndex, LayeredLexerEditorHighlighter.this.getSegments());
            int insertOffset = predecessor != null ? predecessor.range.getEndOffset() : 0;
            this.doc.insertString(insertOffset, new MergingCharSequence(this.mySeparator, tokenText));
            RangeMarker marker = this.doc.createRangeMarker(insertOffset += this.mySeparator.length(), insertOffset + length);
            return new MappedRange(this, marker, outerToken);
        }

        @NotNull
        private CharSequence getTokenText(int tokenIndex) {
            CharSequence charSequence = LayeredLexerEditorHighlighter.this.myText.subSequence(LayeredLexerEditorHighlighter.this.getSegments().getSegmentStart(tokenIndex), LayeredLexerEditorHighlighter.this.getSegments().getSegmentEnd(tokenIndex));
            if (charSequence == null) {
                Mapper.$$$reportNull$$$0(5);
            }
            return charSequence;
        }

        @Nullable
        MappedRange findPredecessor(int token, MappingSegments segments2) {
            --token;
            while (token >= 0) {
                MappedRange mappedRange = segments2.myRanges[token];
                if (mappedRange != null && mappedRange.mapper == this) {
                    return mappedRange;
                }
                --token;
            }
            return null;
        }

        private void removeMapping(@NotNull MappedRange mapping2) {
            RangeMarker rangeMarker;
            if (mapping2 == null) {
                Mapper.$$$reportNull$$$0(6);
            }
            if ((rangeMarker = mapping2.range).isValid()) {
                int start2 = rangeMarker.getStartOffset();
                int end = rangeMarker.getEndOffset();
                assert (this.doc == rangeMarker.getDocument());
                this.doc.deleteString(start2 - this.mySeparator.length(), end);
                rangeMarker.dispose();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 1: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/editor/ex/util/LayeredLexerEditorHighlighter$Mapper";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "mapper";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "oldMapping";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "outerToken";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "mapping";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/editor/ex/util/LayeredLexerEditorHighlighter$Mapper";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAttributes";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTokenText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 5: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "createIterator";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "updateMapping";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "insertMapping";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "removeMapping";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class MappingSegments
    extends SegmentArrayWithData {
        private MappedRange[] myRanges;
        private final Map<LayerDescriptor, Mapper> myLayerBuffers;

        private MappingSegments(DataStorage o) {
            super(o);
            this.myRanges = new MappedRange[64];
            this.myLayerBuffers = new HashMap<LayerDescriptor, Mapper>();
        }

        @Nullable
        Mapper getMappingDocument(@NotNull IElementType token) {
            LayerDescriptor descriptor2;
            if (token == null) {
                MappingSegments.$$$reportNull$$$0(0);
            }
            if ((descriptor2 = (LayerDescriptor)LayeredLexerEditorHighlighter.this.myTokensToLayer.get(token)) == null) {
                return null;
            }
            Mapper mapper = this.myLayerBuffers.get(descriptor2);
            if (mapper == null) {
                mapper = new Mapper(descriptor2);
                this.myLayerBuffers.put(descriptor2, mapper);
            }
            return mapper;
        }

        @Override
        public void removeAll() {
            if (this.mySegmentCount != 0) {
                Arrays.fill(this.myRanges, null);
            }
            this.myLayerBuffers.clear();
            super.removeAll();
        }

        @Override
        public void setElementAt(int i, int startOffset, int endOffset, int data2) {
            this.setElementLight(i, startOffset, endOffset, data2);
            MappedRange range2 = this.myRanges[i];
            if (range2 != null) {
                range2.mapper.removeMapping(range2);
                this.myRanges[i] = null;
            }
            this.updateMappingForToken(i);
        }

        private void setElementLight(int i, int startOffset, int endOffset, int data2) {
            super.setElementAt(i, startOffset, endOffset, data2);
            this.myRanges = LayeredLexerEditorHighlighter.reallocateArray(this.myRanges, i + 1);
        }

        @Override
        public void remove(int startIndex, int endIndex) {
            Map<Mapper, Integer> mins = FactoryMap.create(key -> Integer.MAX_VALUE);
            Map<Mapper, Integer> maxs = FactoryMap.create(key -> 0);
            for (int i = startIndex; i < endIndex; ++i) {
                MappedRange range2 = this.myRanges[i];
                if (range2 != null && range2.range.isValid()) {
                    mins.put(range2.mapper, Math.min(mins.get(range2.mapper), range2.range.getStartOffset()));
                    maxs.put(range2.mapper, Math.max(maxs.get(range2.mapper), range2.range.getEndOffset()));
                }
                this.myRanges[i] = null;
            }
            for (Map.Entry<Mapper, Integer> entry : maxs.entrySet()) {
                Mapper mapper = entry.getKey();
                mapper.doc.deleteString(mins.get(mapper), entry.getValue());
            }
            this.removeRange(this.myRanges, startIndex, endIndex);
            super.remove(startIndex, endIndex);
        }

        @Override
        public void replace(int startOffset, @NotNull SegmentArrayWithData data2, int len) {
            if (data2 == null) {
                MappingSegments.$$$reportNull$$$0(1);
            }
            super.replace(startOffset, data2, len);
            for (int i = startOffset; i < startOffset + len; ++i) {
                this.updateMappingForToken(i);
            }
        }

        private MappedRange @NotNull [] insert(MappedRange @NotNull [] array, MappedRange @NotNull [] insertArray, int startIndex, int insertLength) {
            if (array == null) {
                MappingSegments.$$$reportNull$$$0(2);
            }
            if (insertArray == null) {
                MappingSegments.$$$reportNull$$$0(3);
            }
            MappedRange[] newArray = LayeredLexerEditorHighlighter.reallocateArray(array, this.mySegmentCount + insertLength);
            if (startIndex < this.mySegmentCount) {
                System.arraycopy(newArray, startIndex, newArray, startIndex + insertLength, this.mySegmentCount - startIndex);
            }
            System.arraycopy(insertArray, 0, newArray, startIndex, insertLength);
            if (newArray == null) {
                MappingSegments.$$$reportNull$$$0(4);
            }
            return newArray;
        }

        private <T> void removeRange(T @NotNull [] array, int startIndex, int endIndex) {
            if (array == null) {
                MappingSegments.$$$reportNull$$$0(5);
            }
            if (endIndex < this.mySegmentCount) {
                System.arraycopy(array, endIndex, array, startIndex, this.mySegmentCount - endIndex);
            }
            Arrays.fill(array, this.mySegmentCount - (endIndex - startIndex), this.mySegmentCount, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void insert(@NotNull SegmentArrayWithData segmentArray, int startIndex) {
            if (segmentArray == null) {
                MappingSegments.$$$reportNull$$$0(6);
            }
            LayeredLexerEditorHighlighter layeredLexerEditorHighlighter = LayeredLexerEditorHighlighter.this;
            synchronized (layeredLexerEditorHighlighter) {
                super.insert(segmentArray, startIndex);
                int newCount = segmentArray.getSegmentCount();
                MappedRange[] newRanges = new MappedRange[newCount];
                this.myRanges = this.insert(this.myRanges, newRanges, startIndex, newCount);
                int endIndex = startIndex + segmentArray.getSegmentCount();
                LexerEditorHighlighter.TokenProcessor processor2 = LayeredLexerEditorHighlighter.this.createTokenProcessor(startIndex, LayeredLexerEditorHighlighter.this.getSegments(), LayeredLexerEditorHighlighter.this.myText);
                for (int i = startIndex; i < endIndex; ++i) {
                    int data2 = this.getSegmentData(i);
                    IElementType token = LayeredLexerEditorHighlighter.this.getSegments().unpackTokenFromData(data2);
                    processor2.addToken(i, this.getSegmentStart(i), this.getSegmentEnd(i), data2, token);
                }
                processor2.finish();
            }
        }

        private void updateMappingForToken(int i) {
            int data2 = this.getSegmentData(i);
            IElementType token = LayeredLexerEditorHighlighter.this.getSegments().unpackTokenFromData(data2);
            Mapper mapper = this.getMappingDocument(token);
            MappedRange oldMapping = this.myRanges[i];
            if (mapper != null) {
                if (oldMapping != null) {
                    if (oldMapping.mapper == mapper && oldMapping.outerToken == token) {
                        mapper.updateMapping(i, oldMapping);
                    } else {
                        oldMapping.mapper.removeMapping(oldMapping);
                        this.myRanges[i] = mapper.insertMapping(i, token);
                    }
                } else {
                    this.myRanges[i] = mapper.insertMapping(i, token);
                }
            } else if (oldMapping != null) {
                oldMapping.mapper.removeMapping(oldMapping);
                this.myRanges[i] = null;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "token";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "array";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "insertArray";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/editor/ex/util/LayeredLexerEditorHighlighter$MappingSegments";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "segmentArray";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/editor/ex/util/LayeredLexerEditorHighlighter$MappingSegments";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "insert";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getMappingDocument";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "replace";
                    break;
                }
                case 2: 
                case 3: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "insert";
                    break;
                }
                case 4: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "removeRange";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class LightMapper {
        final Mapper mapper;
        final StringBuilder text;
        final IntArrayList lengths;
        final List<IElementType> tokenTypes;
        final TIntIntHashMap index2Global;
        private final String mySeparator;
        final int insertOffset;

        LightMapper(Mapper mapper, int insertOffset) {
            if (mapper == null) {
                LightMapper.$$$reportNull$$$0(0);
            }
            this.text = new StringBuilder();
            this.lengths = new IntArrayList();
            this.tokenTypes = new ArrayList<IElementType>();
            this.index2Global = new TIntIntHashMap();
            this.mapper = mapper;
            this.mySeparator = mapper.mySeparator;
            this.insertOffset = insertOffset;
        }

        void addToken(@NotNull CharSequence tokenText, @NotNull IElementType tokenType, int globalIndex) {
            if (tokenText == null) {
                LightMapper.$$$reportNull$$$0(1);
            }
            if (tokenType == null) {
                LightMapper.$$$reportNull$$$0(2);
            }
            this.index2Global.put(this.tokenTypes.size(), globalIndex);
            this.text.append(this.mySeparator).append(tokenText);
            this.lengths.add(tokenText.length());
            this.tokenTypes.add(tokenType);
        }

        void finish() {
            assert (this.insertOffset >= 0);
            DocumentImpl document = this.mapper.doc;
            document.insertString(this.insertOffset, this.text);
            int start2 = this.insertOffset;
            for (int i = 0; i < this.tokenTypes.size(); ++i) {
                IElementType type = this.tokenTypes.get(i);
                int len = this.lengths.get(i);
                int globalIndex = this.index2Global.get(i);
                MappedRange[] ranges2 = LayeredLexerEditorHighlighter.this.getSegments().myRanges;
                this.checkNull(type, ranges2[globalIndex]);
                ranges2[globalIndex] = new MappedRange(this.mapper, document.createRangeMarker(start2 += this.mySeparator.length(), start2 + len), type);
                start2 += len;
            }
        }

        private void checkNull(@NotNull IElementType type, @Nullable MappedRange range2) {
            if (type == null) {
                LightMapper.$$$reportNull$$$0(3);
            }
            if (range2 != null) {
                Document mainDocument = LayeredLexerEditorHighlighter.this.getDocument();
                VirtualFile file2 = mainDocument == null ? null : FileDocumentManager.getInstance().getFile(mainDocument);
                LOG.error("Expected null range on " + type + ", found " + range2 + "; highlighter=" + LayeredLexerEditorHighlighter.this.getSyntaxHighlighter(), new Attachment(file2 != null ? file2.getName() : "editorText.txt", LayeredLexerEditorHighlighter.this.myText.toString()));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "mapper";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tokenText";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tokenType";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/editor/ex/util/LayeredLexerEditorHighlighter$LightMapper";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addToken";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "checkNull";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

