/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.ex.util;

import com.intellij.lexer.FlexAdapter;
import com.intellij.lexer.Lexer;
import com.intellij.lexer.RestartableLexer;
import com.intellij.lexer.TokenIterator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.ExceptionWithAttachments;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.ex.PrioritizedDocumentListener;
import com.intellij.openapi.editor.ex.util.DataStorage;
import com.intellij.openapi.editor.ex.util.IntBasedStorage;
import com.intellij.openapi.editor.ex.util.SegmentArrayWithData;
import com.intellij.openapi.editor.ex.util.ShortBasedStorage;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterClient;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileTypes.PlainSyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ArrayUtil;
import com.intellij.util.text.ImmutableCharSequence;
import com.intellij.util.text.MergingCharSequence;
import com.intellij.util.text.SingleCharSequence;
import com.intellij.util.ui.UIUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LexerEditorHighlighter
implements EditorHighlighter,
PrioritizedDocumentListener {
    private static final Logger LOG = Logger.getInstance(LexerEditorHighlighter.class);
    private static final int LEXER_INCREMENTALITY_THRESHOLD = 200;
    private static final Set<Class<?>> ourNonIncrementalLexers = new HashSet();
    private HighlighterClient myEditor;
    private final Lexer myLexer;
    private final Map<IElementType, TextAttributes> myAttributesMap;
    private SegmentArrayWithData mySegments;
    private final SyntaxHighlighter myHighlighter;
    @NotNull
    private EditorColorsScheme myScheme;
    private final int myInitialState;
    protected CharSequence myText;

    public LexerEditorHighlighter(@NotNull SyntaxHighlighter highlighter, @NotNull EditorColorsScheme scheme) {
        if (highlighter == null) {
            LexerEditorHighlighter.$$$reportNull$$$0(0);
        }
        if (scheme == null) {
            LexerEditorHighlighter.$$$reportNull$$$0(1);
        }
        this.myAttributesMap = new HashMap<IElementType, TextAttributes>();
        this.myScheme = scheme;
        this.myLexer = highlighter.getHighlightingLexer();
        this.myLexer.start(ArrayUtil.EMPTY_CHAR_SEQUENCE);
        this.myInitialState = this.myLexer.getState();
        this.myHighlighter = highlighter;
        this.mySegments = this.createSegments();
    }

    @NotNull
    protected SegmentArrayWithData createSegments() {
        return new SegmentArrayWithData(this.createStorage());
    }

    @NotNull
    protected DataStorage createStorage() {
        return this.myLexer instanceof RestartableLexer ? new IntBasedStorage() : new ShortBasedStorage();
    }

    public boolean isPlain() {
        return this.myHighlighter instanceof PlainSyntaxHighlighter;
    }

    @Nullable
    protected final Document getDocument() {
        return this.myEditor != null ? this.myEditor.getDocument() : null;
    }

    public final synchronized boolean checkContentIsEqualTo(@NotNull CharSequence sequence) {
        Document document;
        if (sequence == null) {
            LexerEditorHighlighter.$$$reportNull$$$0(2);
        }
        return (document = this.getDocument()) != null && this.isInSyncWithDocument() && Comparing.equal(document.getImmutableCharSequence(), sequence);
    }

    @NotNull
    public EditorColorsScheme getScheme() {
        EditorColorsScheme editorColorsScheme = this.myScheme;
        if (editorColorsScheme == null) {
            LexerEditorHighlighter.$$$reportNull$$$0(3);
        }
        return editorColorsScheme;
    }

    @NotNull
    protected Lexer getLexer() {
        Lexer lexer = this.myLexer;
        if (lexer == null) {
            LexerEditorHighlighter.$$$reportNull$$$0(4);
        }
        return lexer;
    }

    @Override
    public void setEditor(@NotNull HighlighterClient editor) {
        if (editor == null) {
            LexerEditorHighlighter.$$$reportNull$$$0(5);
        }
        LOG.assertTrue(this.myEditor == null, "Highlighters cannot be reused with different editors");
        this.myEditor = editor;
    }

    @Override
    public void setColorScheme(@NotNull EditorColorsScheme scheme) {
        if (scheme == null) {
            LexerEditorHighlighter.$$$reportNull$$$0(6);
        }
        this.myScheme = scheme;
        this.myAttributesMap.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public HighlighterIterator createIterator(int startOffset) {
        int latestValidOffset;
        LexerEditorHighlighter lexerEditorHighlighter = this;
        // MONITORENTER : lexerEditorHighlighter
        if (!this.isInSyncWithDocument()) {
            Document document = this.getDocument();
            assert (document != null);
            if (document.isInBulkUpdate()) {
                document.setInBulkUpdate(false);
            }
            this.doSetText(document.getImmutableCharSequence());
        }
        HighlighterIteratorImpl highlighterIteratorImpl = new HighlighterIteratorImpl(startOffset <= (latestValidOffset = this.mySegments.getLastValidOffset()) ? startOffset : latestValidOffset);
        // MONITOREXIT : lexerEditorHighlighter
        if (highlighterIteratorImpl != null) return highlighterIteratorImpl;
        LexerEditorHighlighter.$$$reportNull$$$0(7);
        return highlighterIteratorImpl;
    }

    public boolean isValid() {
        Project project2 = this.myEditor.getProject();
        return project2 != null && !project2.isDisposed();
    }

    private boolean isInSyncWithDocument() {
        Document document = this.getDocument();
        return document == null || document.getTextLength() == 0 || this.mySegments.getSegmentCount() > 0;
    }

    private boolean isInitialState(int data2) {
        if (this.myLexer instanceof RestartableLexer) {
            int state = this.mySegments.unpackStateFromData(data2);
            return ((RestartableLexer)((Object)this.myLexer)).isRestartableState(state);
        }
        return data2 >= 0;
    }

    @Override
    public synchronized void documentChanged(@NotNull DocumentEvent e) {
        if (e == null) {
            LexerEditorHighlighter.$$$reportNull$$$0(8);
        }
        try {
            Class<?> lexerClass;
            int initialState;
            int oldStartIndex;
            int data2;
            int startIndex;
            Document document = e.getDocument();
            CharSequence text2 = document.getImmutableCharSequence();
            if (document.isInBulkUpdate()) {
                this.myText = null;
                this.mySegments.removeAll();
                return;
            }
            if (this.mySegments.getSegmentCount() == 0) {
                this.setText(text2);
                return;
            }
            this.myText = text2;
            int oldStartOffset = e.getOffset();
            int segmentIndex = this.mySegments.findSegmentIndex(oldStartOffset) - 2;
            for (startIndex = oldStartIndex = Math.max(0, segmentIndex); !this.isInitialState(data2 = this.mySegments.getSegmentData(startIndex)) && startIndex != 0; --startIndex) {
            }
            int startOffset = this.mySegments.getSegmentStart(startIndex);
            int textLength = text2.length();
            if (startOffset == 0 && this.myLexer instanceof RestartableLexer) {
                initialState = ((RestartableLexer)((Object)this.myLexer)).getStartState();
                this.myLexer.start(text2, startOffset, text2.length(), initialState);
            } else if (this.myLexer instanceof RestartableLexer) {
                initialState = this.mySegments.unpackStateFromData(this.mySegments.getSegmentData(startIndex));
                ((RestartableLexer)((Object)this.myLexer)).start(text2, startOffset, text2.length(), initialState, this.createTokenIterator(startIndex));
            } else {
                initialState = this.myInitialState;
                this.myLexer.start(text2, startOffset, text2.length(), initialState);
            }
            int lastTokenStart = -1;
            int lastLexerState = -1;
            IElementType lastTokenType = null;
            IElementType tokenType = this.myLexer.getTokenType();
            while (tokenType != null && startIndex < oldStartIndex) {
                int tokenStart = this.myLexer.getTokenStart();
                int lexerState = this.myLexer.getState();
                if (tokenStart == lastTokenStart && lexerState == lastLexerState && tokenType == lastTokenType) {
                    throw new IllegalStateException("Lexer is not progressing after calling advance()");
                }
                int tokenEnd = this.myLexer.getTokenEnd();
                data2 = this.mySegments.packData(tokenType, lexerState, this.canRestart(lexerState));
                if (this.mySegments.getSegmentStart(startIndex) != tokenStart || this.mySegments.getSegmentEnd(startIndex) != tokenEnd || this.mySegments.getSegmentData(startIndex) != data2) break;
                ++startIndex;
                this.myLexer.advance();
                lastTokenType = tokenType;
                lastTokenStart = tokenStart;
                lastLexerState = lexerState;
                tokenType = this.myLexer.getTokenType();
            }
            if (ApplicationManager.getApplication().isInternal() && startOffset == 0 && startIndex > 200 && !ourNonIncrementalLexers.contains(lexerClass = this.myLexer.getClass())) {
                LOG.warn(String.format("%s is probably not incremental: no initial state throughout %d tokens", lexerClass.getName(), startIndex));
                ourNonIncrementalLexers.add(lexerClass);
            }
            startOffset = this.mySegments.getSegmentStart(startIndex);
            lastTokenType = null;
            SegmentArrayWithData insertSegments = new SegmentArrayWithData(this.mySegments.createStorage());
            int repaintEnd = -1;
            int insertSegmentCount = 0;
            int oldEndIndex = -1;
            IElementType tokenType2 = this.myLexer.getTokenType();
            while (tokenType2 != null) {
                int shiftedTokenStart;
                int index;
                int tokenStart = this.myLexer.getTokenStart();
                int lexerState = this.myLexer.getState();
                if (tokenStart == lastTokenStart && lexerState == lastLexerState && tokenType2 == lastTokenType) {
                    throw new IllegalStateException("Lexer is not progressing after calling advance()");
                }
                lastTokenStart = tokenStart;
                lastLexerState = lexerState;
                lastTokenType = tokenType2;
                int tokenEnd = this.myLexer.getTokenEnd();
                data2 = this.mySegments.packData(tokenType2, lexerState, this.canRestart(lexerState));
                int newEndOffset = e.getOffset() + e.getNewLength();
                if (tokenStart >= newEndOffset && this.canRestart(lexerState) && this.mySegments.getSegmentStart(index = this.mySegments.findSegmentIndex(shiftedTokenStart = tokenStart - e.getNewLength() + e.getOldLength())) == shiftedTokenStart && this.mySegments.getSegmentData(index) == data2) {
                    repaintEnd = tokenStart;
                    oldEndIndex = index;
                    break;
                }
                insertSegments.setElementAt(insertSegmentCount, tokenStart, tokenEnd, data2);
                ++insertSegmentCount;
                this.myLexer.advance();
                tokenType2 = this.myLexer.getTokenType();
            }
            int shift = e.getNewLength() - e.getOldLength();
            if (repaintEnd > 0) {
                while (insertSegmentCount > 0 && oldEndIndex > startIndex && LexerEditorHighlighter.segmentsEqual(this.mySegments, oldEndIndex - 1, insertSegments, insertSegmentCount - 1, shift) && !this.hasAdditionalData(oldEndIndex - 1)) {
                    --oldEndIndex;
                    repaintEnd = insertSegments.getSegmentStart(--insertSegmentCount);
                    insertSegments.remove(insertSegmentCount, insertSegmentCount + 1);
                }
            }
            if (repaintEnd == -1) {
                repaintEnd = textLength;
            }
            if (oldEndIndex < 0) {
                oldEndIndex = this.mySegments.getSegmentCount();
            }
            this.mySegments.shiftSegments(oldEndIndex, shift);
            this.mySegments.replace(startIndex, oldEndIndex, insertSegments);
            if (insertSegmentCount == 0 || oldEndIndex == startIndex + 1 && insertSegmentCount == 1 && data2 == this.mySegments.getSegmentData(startIndex)) {
                return;
            }
            this.myEditor.repaint(startOffset, repaintEnd);
        }
        catch (ProcessCanceledException ex) {
            this.myText = null;
            this.mySegments.removeAll();
            throw ex;
        }
        catch (RuntimeException ex) {
            throw new InvalidStateException(this, "Error updating  after " + e, ex);
        }
    }

    @NotNull
    private TokenIterator createTokenIterator(final int start2) {
        return new TokenIterator(){

            @Override
            public int getStartOffset(int index) {
                return LexerEditorHighlighter.this.mySegments.getSegmentStart(index);
            }

            @Override
            public int getEndOffset(int index) {
                return LexerEditorHighlighter.this.mySegments.getSegmentEnd(index);
            }

            @Override
            public IElementType getType(int index) {
                return LexerEditorHighlighter.this.mySegments.unpackTokenFromData(LexerEditorHighlighter.this.mySegments.getSegmentData(index));
            }

            @Override
            public int getState(int index) {
                return LexerEditorHighlighter.this.mySegments.unpackStateFromData(LexerEditorHighlighter.this.mySegments.getSegmentData(index));
            }

            @Override
            public int getTokenCount() {
                return LexerEditorHighlighter.this.mySegments.getSegmentCount();
            }

            @Override
            public int initialTokenIndex() {
                return start2;
            }
        };
    }

    private boolean canRestart(int lexerState) {
        if (this.myLexer instanceof RestartableLexer) {
            return ((RestartableLexer)((Object)this.myLexer)).isRestartableState(lexerState);
        }
        return lexerState == this.myInitialState;
    }

    protected boolean hasAdditionalData(int segmentIndex) {
        return false;
    }

    @Override
    public int getPriority() {
        return 80;
    }

    private static boolean segmentsEqual(@NotNull SegmentArrayWithData a1, int idx1, @NotNull SegmentArrayWithData a2, int idx2, int offsetShift) {
        if (a1 == null) {
            LexerEditorHighlighter.$$$reportNull$$$0(9);
        }
        if (a2 == null) {
            LexerEditorHighlighter.$$$reportNull$$$0(10);
        }
        return a1.getSegmentStart(idx1) + offsetShift == a2.getSegmentStart(idx2) && a1.getSegmentEnd(idx1) + offsetShift == a2.getSegmentEnd(idx2) && a1.getSegmentData(idx1) == a2.getSegmentData(idx2);
    }

    public HighlighterClient getClient() {
        return this.myEditor;
    }

    final synchronized void resetText(@NotNull CharSequence text2) {
        if (text2 == null) {
            LexerEditorHighlighter.$$$reportNull$$$0(11);
        }
        this.myText = null;
        this.doSetText(text2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setText(@NotNull CharSequence text2) {
        if (text2 == null) {
            LexerEditorHighlighter.$$$reportNull$$$0(12);
        }
        LexerEditorHighlighter lexerEditorHighlighter = this;
        synchronized (lexerEditorHighlighter) {
            this.doSetText(text2);
        }
    }

    private void doSetText(@NotNull CharSequence text2) {
        IElementType tokenType;
        if (text2 == null) {
            LexerEditorHighlighter.$$$reportNull$$$0(13);
        }
        if (Comparing.equal(this.myText, text2)) {
            return;
        }
        text2 = ImmutableCharSequence.asImmutable(text2);
        SegmentArrayWithData tempSegments = this.createSegments();
        TokenProcessor processor2 = this.createTokenProcessor(0, tempSegments, text2);
        int textLength = text2.length();
        this.myLexer.start(text2, 0, textLength, this.myLexer instanceof RestartableLexer ? ((RestartableLexer)((Object)this.myLexer)).getStartState() : this.myInitialState);
        int i = 0;
        while ((tokenType = this.myLexer.getTokenType()) != null) {
            int state = this.myLexer.getState();
            int data2 = tempSegments.packData(tokenType, state, this.canRestart(state));
            processor2.addToken(i, this.myLexer.getTokenStart(), this.myLexer.getTokenEnd(), data2, tokenType);
            if (++i % 1024 == 0) {
                ProgressManager.checkCanceled();
            }
            this.myLexer.advance();
        }
        this.myText = text2;
        this.mySegments = tempSegments;
        processor2.finish();
        if (textLength > 0 && (this.mySegments.mySegmentCount == 0 || this.mySegments.myEnds[this.mySegments.mySegmentCount - 1] != textLength)) {
            throw new IllegalStateException("Unexpected termination offset for lexer " + this.myLexer);
        }
        if (this.myEditor != null && !ApplicationManager.getApplication().isHeadlessEnvironment()) {
            UIUtil.invokeLaterIfNeeded(() -> this.myEditor.repaint(0, textLength));
        }
    }

    @NotNull
    protected TokenProcessor createTokenProcessor(int startIndex, SegmentArrayWithData segments2, CharSequence myText) {
        TokenProcessor tokenProcessor = (tokenIndex, startOffset, endOffset, data2, tokenType) -> segments2.setElementAt(tokenIndex, startOffset, endOffset, data2);
        if (tokenProcessor == null) {
            LexerEditorHighlighter.$$$reportNull$$$0(14);
        }
        return tokenProcessor;
    }

    @NotNull
    public SyntaxHighlighter getSyntaxHighlighter() {
        SyntaxHighlighter syntaxHighlighter = this.myHighlighter;
        if (syntaxHighlighter == null) {
            LexerEditorHighlighter.$$$reportNull$$$0(15);
        }
        return syntaxHighlighter;
    }

    @NotNull
    private TextAttributes getAttributes(@NotNull IElementType tokenType) {
        TextAttributes attrs;
        if (tokenType == null) {
            LexerEditorHighlighter.$$$reportNull$$$0(16);
        }
        if ((attrs = this.myAttributesMap.get(tokenType)) == null) {
            attrs = this.convertAttributes(this.myHighlighter.getTokenHighlights(tokenType));
            this.myAttributesMap.put(tokenType, attrs);
        }
        TextAttributes textAttributes = attrs;
        if (textAttributes == null) {
            LexerEditorHighlighter.$$$reportNull$$$0(17);
        }
        return textAttributes;
    }

    @NotNull
    public List<TextAttributes> getAttributesForPreviousAndTypedChars(@NotNull Document document, int offset, char c) {
        if (document == null) {
            LexerEditorHighlighter.$$$reportNull$$$0(18);
        }
        CharSequence text2 = document.getImmutableCharSequence();
        MergingCharSequence newText = StringUtil.replaceSubSequence(text2, offset, offset, new SingleCharSequence(c));
        List<IElementType> tokenTypes = this.getTokenType(newText, offset);
        List<TextAttributes> list2 = Arrays.asList(this.getAttributes(tokenTypes.get(0)).clone(), this.getAttributes(tokenTypes.get(1)).clone());
        if (list2 == null) {
            LexerEditorHighlighter.$$$reportNull$$$0(19);
        }
        return list2;
    }

    @NotNull
    private List<IElementType> getTokenType(@NotNull CharSequence text2, int offset) {
        if (text2 == null) {
            LexerEditorHighlighter.$$$reportNull$$$0(20);
        }
        int startOffset = 0;
        int data2 = 0;
        boolean isDataSet = false;
        int oldStartIndex = 0;
        int startIndex = 0;
        if (offset > 0 && this.mySegments.getSegmentCount() > 0) {
            int segmentIndex = this.mySegments.findSegmentIndex(offset - 1) - 2;
            startIndex = oldStartIndex = Math.max(0, segmentIndex);
            while (true) {
                data2 = this.mySegments.getSegmentData(startIndex);
                isDataSet = true;
                if (this.isInitialState(data2) || startIndex == 0) break;
                --startIndex;
            }
            startOffset = this.mySegments.getSegmentStart(startIndex);
        }
        int state = this.myLexer instanceof RestartableLexer ? (isDataSet ? this.mySegments.unpackStateFromData(data2) : ((RestartableLexer)((Object)this.myLexer)).getStartState()) : this.myInitialState;
        if (offset == 0 && this.myLexer instanceof RestartableLexer) {
            this.myLexer.start(text2, startOffset, text2.length(), ((RestartableLexer)((Object)this.myLexer)).getStartState());
        } else if (this.myLexer instanceof RestartableLexer) {
            ((RestartableLexer)((Object)this.myLexer)).start(text2, startOffset, text2.length(), state, this.createTokenIterator(startIndex));
        } else {
            this.myLexer.start(text2, startOffset, text2.length(), state);
        }
        while (this.myLexer.getTokenType() != null && startIndex < oldStartIndex) {
            int tokenStart = this.myLexer.getTokenStart();
            int lexerState = this.myLexer.getState();
            int tokenEnd = this.myLexer.getTokenEnd();
            data2 = this.mySegments.packData(this.myLexer.getTokenType(), lexerState, this.canRestart(lexerState));
            if (this.mySegments.getSegmentStart(startIndex) != tokenStart || this.mySegments.getSegmentEnd(startIndex) != tokenEnd || this.mySegments.getSegmentData(startIndex) != data2) break;
            ++startIndex;
            this.myLexer.advance();
        }
        IElementType tokenType1 = null;
        IElementType tokenType2 = null;
        while (this.myLexer.getTokenType() != null) {
            int lexerState = this.myLexer.getState();
            data2 = this.mySegments.packData(this.myLexer.getTokenType(), lexerState, this.canRestart(lexerState));
            if (tokenType1 == null && this.myLexer.getTokenEnd() >= offset) {
                tokenType1 = this.mySegments.unpackTokenFromData(data2);
            }
            if (this.myLexer.getTokenEnd() >= offset + 1) {
                tokenType2 = this.mySegments.unpackTokenFromData(data2);
                break;
            }
            this.myLexer.advance();
        }
        List<IElementType> list2 = Arrays.asList(tokenType1, tokenType2);
        if (list2 == null) {
            LexerEditorHighlighter.$$$reportNull$$$0(21);
        }
        return list2;
    }

    @NotNull
    TextAttributes convertAttributes(TextAttributesKey @NotNull [] keys2) {
        if (keys2 == null) {
            LexerEditorHighlighter.$$$reportNull$$$0(22);
        }
        TextAttributes resultAttributes = new TextAttributes();
        boolean firstPass = true;
        for (TextAttributesKey key : keys2) {
            TextAttributes attributesByKey = this.myScheme.getAttributes(key);
            if (attributesByKey == null) continue;
            if (firstPass) {
                resultAttributes.copyFrom(attributesByKey);
                firstPass = false;
                continue;
            }
            resultAttributes = TextAttributes.merge(resultAttributes, attributesByKey);
        }
        TextAttributes textAttributes = resultAttributes;
        if (textAttributes == null) {
            LexerEditorHighlighter.$$$reportNull$$$0(23);
        }
        return textAttributes;
    }

    public String toString() {
        return this.getClass().getName() + "(" + (this.myLexer.getClass() == FlexAdapter.class ? this.myLexer.toString() : this.myLexer.getClass().getName()) + "): '" + this.myLexer.getBufferSequence() + "'";
    }

    @NotNull
    public SegmentArrayWithData getSegments() {
        SegmentArrayWithData segmentArrayWithData = this.mySegments;
        if (segmentArrayWithData == null) {
            LexerEditorHighlighter.$$$reportNull$$$0(24);
        }
        return segmentArrayWithData;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 14: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 23: 
            case 24: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 14: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 23: 
            case 24: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlighter";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scheme";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sequence";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 14: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/ex/util/LexerEditorHighlighter";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "a1";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "a2";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tokenType";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keys";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/ex/util/LexerEditorHighlighter";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getScheme";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getLexer";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createIterator";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createTokenProcessor";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getSyntaxHighlighter";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttributes";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttributesForPreviousAndTypedChars";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getTokenType";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "convertAttributes";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getSegments";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "checkContentIsEqualTo";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 14: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 23: 
            case 24: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setEditor";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setColorScheme";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "documentChanged";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "segmentsEqual";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "resetText";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setText";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "doSetText";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getAttributes";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getAttributesForPreviousAndTypedChars";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getTokenType";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "convertAttributes";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 14: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 23: 
            case 24: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class InvalidStateException
    extends RuntimeException
    implements ExceptionWithAttachments {
        private final Attachment[] myAttachments;

        private InvalidStateException(LexerEditorHighlighter highlighter, String message, Throwable cause) {
            super(highlighter.getClass().getName() + "(" + (highlighter.myLexer.getClass() == FlexAdapter.class ? highlighter.myLexer.toString() : highlighter.myLexer.getClass().getName()) + "): " + message, cause);
            this.myAttachments = new Attachment[]{new Attachment("content.txt", highlighter.myLexer.getBufferSequence().toString())};
        }

        @Override
        public Attachment @NotNull [] getAttachments() {
            if (this.myAttachments == null) {
                InvalidStateException.$$$reportNull$$$0(0);
            }
            return this.myAttachments;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/ex/util/LexerEditorHighlighter$InvalidStateException", "getAttachments"));
        }
    }

    public class HighlighterIteratorImpl
    implements HighlighterIterator {
        private int mySegmentIndex;

        HighlighterIteratorImpl(int startOffset) {
            try {
                this.mySegmentIndex = LexerEditorHighlighter.this.mySegments.findSegmentIndex(startOffset);
            }
            catch (IllegalStateException e) {
                throw new InvalidStateException(LexerEditorHighlighter.this, "wrong state", e);
            }
        }

        public int currentIndex() {
            return this.mySegmentIndex;
        }

        @Override
        public TextAttributes getTextAttributes() {
            return LexerEditorHighlighter.this.getAttributes(this.getTokenType());
        }

        @Override
        public int getStart() {
            return LexerEditorHighlighter.this.mySegments.getSegmentStart(this.mySegmentIndex);
        }

        @Override
        public int getEnd() {
            return LexerEditorHighlighter.this.mySegments.getSegmentEnd(this.mySegmentIndex);
        }

        @Override
        public IElementType getTokenType() {
            return LexerEditorHighlighter.this.mySegments.unpackTokenFromData(LexerEditorHighlighter.this.mySegments.getSegmentData(this.mySegmentIndex));
        }

        @Override
        public void advance() {
            ++this.mySegmentIndex;
        }

        @Override
        public void retreat() {
            --this.mySegmentIndex;
        }

        @Override
        public boolean atEnd() {
            return this.mySegmentIndex >= LexerEditorHighlighter.this.mySegments.getSegmentCount() || this.mySegmentIndex < 0;
        }

        @Override
        public Document getDocument() {
            return LexerEditorHighlighter.this.getDocument();
        }
    }

    protected static interface TokenProcessor {
        public void addToken(int var1, int var2, int var3, int var4, @NotNull IElementType var5);

        default public void finish() {
        }
    }
}

